@extends('layouts.master')
@section('title')
@parent
client edit
@stop

@section('content')
<div class="row">
    <div class="col-sm-12">
        <h4 class="pull-left page-title"> </h4>
        <ol class="breadcrumb pull-right">
            <li><a href="{!! route('home.index') !!}">Dashboard</a></li>
            <li><a href="{!! URL::route('client.index') !!}">Client</a></li> 
            <li class="active" >Edit client  </li> 
            <li class="active" >{!! $client->name !!} </li>

        </ol>
    </div>
</div> 

{!! Form::model($client, ['method' => 'PATCH', 'route' => ['client.update', $client->id]]) !!}


<div class="panel panel-default">
    <div class="panel-heading">
        <div class="row"> 
            <div class="col-md-12">
                <div class="panel-heading pull-left">
                    <h3 class="panel-title"> General  </h3>
                </div>

                <div class="pull-right">

                </div> 
            </div>
        </div>
    </div>
    <div class="panel-body">
        <div class="row"> 
            <div class="col-md-6">

                <div class="form-group {!! ($errors->has('email')) ? 'has-error' : '' !!}">
                    {!! Form::label('email', 'Email') !!}
                    {!! Form::text('email', null, array('class' => 'form-control', 'placeholder' => 'Eg: example@example.com', 'autocomplete' => 'off')) !!}
                    {!! ($errors->has('email') ? $errors->first('email') : '') !!}
                </div>

                <div class="form-group {!! ($errors->has('registered_name')) ? 'has-error' : '' !!}">
                    {!! Form::label('registered_name', 'Registered name') !!}
                    {!! Form::text('registered_name', null, array('class' => 'form-control', 'placeholder' => 'Eg: facebook')) !!}
                    {!! ($errors->has('registered_name') ? $errors->first('registered_name') : '') !!}
                </div> 

                <div class="form-group {!! ($errors->has('registered_name2')) ? 'has-error' : '' !!}">
                    {!! Form::label('registered_name2', 'Registered name2') !!}
                    {!! Form::text('registered_name2', null, array('class' => 'form-control', 'placeholder' => 'Eg: facebook')) !!}
                    {!! ($errors->has('registered_name2') ? $errors->first('registered_name2') : '') !!}
                </div> 

                <div class="form-group {!! ($errors->has('name')) ? 'has-error' : '' !!}">
                    {!! Form::label('name', 'Name') !!}
                    {!! Form::text('name', null, array('class' => 'form-control', 'placeholder' => 'Eg: Ryan')) !!}
                    {!! ($errors->has('name') ? $errors->first('name') : '') !!}
                </div> 

                <div class="form-group {!! ($errors->has('contact_person')) ? 'has-error' : '' !!}">
                    {!! Form::label('contact_person', 'Contact person') !!}
                    {!! Form::text('contact_person', null, array('class' => 'form-control', 'placeholder' => 'Eg: Ryan')) !!}
                    {!! ($errors->has('contact_person') ? $errors->first('contact_person') : '') !!}
                </div> 
                <div class="form-group {!! ($errors->has('tel_number')) ? 'has-error' : '' !!}">
                    {!! Form::label('tel_number', 'Tel number') !!}
                    {!! Form::text('tel_number', null, array('class' => 'form-control', 'placeholder' => 'Eg: 0777243109')) !!}
                    {!! ($errors->has('tel_number') ? $errors->first('tel_number') : '') !!}
                </div>  
                 <div class="form-group {!! ($errors->has('mobile_number')) ? 'has-error' : '' !!}">
                    {!! Form::label('mobile_number', 'Mobile Number') !!}
                    {!! Form::text('mobile_number', null, array('class' => 'form-control', 'placeholder' => 'Eg: 0777243109')) !!}
                    {!! ($errors->has('mobile_number') ? $errors->first('mobile_number') : '') !!}
                </div> 

            </div>
            <div class="col-md-6"> 
                <div class="form-group {!! ($errors->has('address1')) ? 'has-error' : '' !!}">
                    {!! Form::label('address1', ' Billing address') !!}
                    {!! Form::text('address1', null, array('class' => 'form-control', 'placeholder' => 'Eg: aus')) !!}
                    {!! ($errors->has('address1') ? $errors->first('address1') : '') !!}
                </div> 
                <div class="form-group {!! ($errors->has('address2')) ? 'has-error' : '' !!}">
                    {!! Form::label('address2', 'Billing suburb') !!}
                    {!! Form::text('address2', null, array('class' => 'form-control', 'placeholder' => 'Eg: aus')) !!}
                    {!! ($errors->has('address2') ? $errors->first('address2') : '') !!}
                </div> 
                 <div class="form-group {!! ($errors->has('address3')) ? 'has-error' : '' !!}">
                    {!! Form::label('address3', 'Billing state') !!} 
                     {!!  Form::select('address3',  ['' => '', 'NSW'=>'NSW', 'TAS'=>'TAS', 'QLD'=>'QLD', 'WA'=>'WA', 'SA'=>'SA', 'VIC'=>'VIC', 'ACT'=>'ACT', 'NT'=>'NT'], null  ,['class' => 'form-control', 'placeholder' => 'state', 'id'=>'state'])  !!}
                    
                     <input id="new-state" type="text" />
                     <button type="button" id="btn-add-state">Set new state value</button>

                    {!! ($errors->has('address3') ? $errors->first('address3') : '') !!}
                </div> 

                <div class="form-group {!! ($errors->has('post_code')) ? 'has-error' : '' !!}">
                    {!! Form::label('post_code', 'Post code') !!}
                    {!! Form::text('post_code', null, array('class' => 'form-control', 'placeholder' => 'Eg: Ryan')) !!}
                    {!! ($errors->has('post_code') ? $errors->first('post_code') : '') !!}
                </div>  

                <div class="form-group {!! ($errors->has('state_of_incorp')) ? 'has-error' : '' !!}">
                    {!! Form::label('state_of_incorporatione', 'State of incorporatione') !!}
                    {!! Form::text('state_of_incorporatione', null, array('class' => 'form-control', 'placeholder' => 'Eg: Ryan')) !!}
                    {!! ($errors->has('state_of_incorporatione') ? $errors->first('state_of_incorporatione') : '') !!}
                </div> 



                <div class="form-group {!! ($errors->has('registered_office')) ? 'has-error' : '' !!}">
                    {!! Form::label('registered_office', 'ABN Number') !!}
                    {!! Form::text('registered_office', null, array('class' => 'form-control', 'placeholder' => 'Eg: facebook')) !!}
                    {!! ($errors->has('registered_office') ? $errors->first('registered_office') : '') !!}
                </div> 
            </div>
        </div>
    </div>
</div> 

<div class="panel panel-default">
    <div class="panel-heading">
        <div class="row"> 
            <div class="col-md-12">
                <div class="panel-heading pull-left">
                    <h3 class="panel-title"> Payment Detail </h3>
                </div>

                <div class="pull-right">

                </div> 
            </div>
        </div>
    </div>
    <div class="panel-body">
        <div class="row"> 
            <div class="col-md-6">
               
                <div class="form-group {!! ($errors->has('personal_call_rate')) ? 'has-error' : '' !!}">
                    {!! Form::label('personal_call_rate', 'Personal call rate') !!}
                    {!! Form::text('personal_call_rate', null, array('class' => 'form-control text-right', 'placeholder' => 'Eg: 0.00')) !!}
                    {!! ($errors->has('personal_call_rate') ? $errors->first('personal_call_rate') : '') !!}
                </div> 
                <div class="form-group {!! ($errors->has('final_demand_rate')) ? 'has-error' : '' !!}">
                    {!! Form::label('final_demand_rate', 'Final demand rate') !!}
                    {!! Form::text('final_demand_rate', null, array('class' => 'form-control text-right', 'placeholder' => 'Eg: 0.00')) !!}
                    {!! ($errors->has('final_demand_rate') ? $errors->first('final_demand_rate') : '') !!}
                </div> 
                <div class="form-group {!! ($errors->has('commission')) ? 'has-error' : '' !!}">
                    {!! Form::label('commission', 'Commission') !!} 
                    <div class="input-group">
                        {!! Form::text('commission', null, array('class' => 'form-control text-right', 'placeholder' => 'Eg: 0.00')) !!}
                        <span class="input-group-addon" id="basic-addon2">%</span> 
                    </div>
                    {!! ($errors->has('commission') ? $errors->first('commission') : '') !!}
                </div>
            </div>
            <div class="col-md-6">
               

                <div class="form-group {!! ($errors->has('red_letter_rate')) ? 'has-error' : '' !!}">
                    {!! Form::label('red_letter_rate', 'Red letter rate') !!}
                    {!! Form::text('red_letter_rate', null, array('class' => 'form-control text-right', 'placeholder' => 'Eg: 0.00')) !!}
                    {!! ($errors->has('red_letter_rate') ? $errors->first('red_letter_rate') : '') !!}
                </div> 
                <div class="form-group {!! ($errors->has('credit_limit')) ? 'has-error' : '' !!}">
                    {!! Form::label('credit_limit', 'Credit limit') !!}
                    {!! Form::text('credit_limit', null, array('class' => 'form-control text-right', 'placeholder' => 'Eg: 0.00')) !!}
                    {!! ($errors->has('credit_limit') ? $errors->first('credit_limit') : '') !!}
                </div> 
            </div> 
        </div>
    </div>
</div>
<div class="panel-footer"> 

    {!! Form::submit('Update', array('class' => 'btn btn-success')) !!} &nbsp;&nbsp;
    <a href="{!!URL::route('client.index')!!}" class="btn btn-default">Cancel</a>
    {!!Form::close()!!} 

</div>


@stop
@section('include-js')
@parent

@stop

@section('document-ready-js')
@parent


$("#btn-add-state").on("click", function(){
    var newStateVal = $("#new-state").val();
    // Set the value, creating a new option if necessary
    if ($("#state").find("option[value='" + newStateVal + "']").length) {
      $("#state").val(newStateVal).trigger("change");
    } else { 
      // Create the DOM option that is pre-selected by default
      var newState = new Option(newStateVal, newStateVal, true, true);
      // Append it to the select
      $("#state").append(newState).trigger('change');
    } 
  });  

@stop
