@extends('layouts.master')
@section('title')
@parent
Clients
@stop
@section('inline-css')
@parent
<link rel="stylesheet" type="text/css" href="{!! asset('assets/form-wizard/jquery.steps.css') !!}" />
@stop
@section('content')
<div class="row">
    <div class="col-sm-12">
        <h4 class="pull-left page-title"> </h4>
        <ol class="breadcrumb pull-right">
            <li><a href="{!! route('home.index') !!}">Dashboard</a></li>
            <li class="active">Client</li>
        </ol>
    </div>
</div>
@if($datas['import_type']== 'upload')
<div class="panel panel-default">
    <div class="panel-heading">
        <div class="row">
            <div class="col-md-12">
                <div class="panel-heading pull-left">
                    <h3 class="panel-title">Client</h3>
                </div>

                <div class="pull-right">

                </div>
            </div>
        </div>
    </div><!-- /.box-header -->
    <div class="panel-body">
        <div class="row">
            <div class="col-md-12 portlets">
                <!-- Your awesome content goes here -->
                <div class="m-b-30">

                    {!! Form::open(array('route' => array('file.import', $datas['clientId']), 'class' => 'form', 'novalidate' => 'novalidate', 'files' => true)) !!}
                    <input type="hidden" name="file_import_type" value="upload" />
                    <input type="hidden" name="model_name" value="client" />
                    <div class="fallback">
                        {!! Form::file('file', null) !!}

                    </div>

                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">

            </div>
        </div>

    </div><!-- /.box-body -->
    <div class="panel-footer">
        {!! Form::submit('Upload', array('class' => 'btn btn-success')) !!} &nbsp;&nbsp;
        <a href="{!!URL::route('client.index')!!}" class="btn btn-default">Cancel</a>
        {!!Form::close()!!}
    </div>
</div>

<div class="panel panel-default">
    <div class="panel-heading">
        <div class="row">
            <div class="col-md-12">
                <div class="panel-heading pull-left">
                    <h3 class="panel-title">Last Import Debtor</h3>
                </div>

                <div class="pull-right">

                </div>
            </div>
        </div>
    </div><!-- /.box-header -->
    <div class="panel-body">
        <div class="row">
            <div class="col-md-12 portlets">

               <table id="tech-companies-1" class="table  table-bordered ">
                            <thead>

                                <tr>

                                    <th data-priority="1" >
                                        Debtor code
                                    </th>
                                    <th  >Invoice code</th>
                                    <th data-priority="6" >Invoice date</th>
                                    <th data-priority="6" >Invoice state</th>
                                    <th data-priority="1" >Original debt </th>
                                    <th data-priority="1" >current balance</th>
                                     <th data-priority="1" >Import file name</th>
                                    <th data-priority="3" >Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            @foreach($debtors as $debtor)

                            <tr>

                                <td>{!!$debtor->debtor->debtor_code !!}</td>
                                <td>{!!    $debtor->invoice_code !!}</td>
                                <td>
                                    {!! $debtor->invoice_date !!}
                                </td>
                                <td>
                                    {!! $debtor->invoice_state !!}
                                </td>
                                <td>
                                    {!! $debtor->original_debt !!}
                                </td>

                                <td>
                                    {!! $debtor->current_balance !!}
                                </td>
                                <td>
                                @if(is_array($debtor->import) && count($debtor->import) > 0)

                                    {!! $debtor->import->file_name !!}
                                @endif
                                </td>
                                <td>

                                    <a href="{!! route('client.debtor.invoice.show', [$datas['clientId'], $debtor->id]) !!}"><i class="fa  fa-bars" rel="tooltip" title="Detail"></i>  </a>&nbsp;&nbsp;



                                    <a href="{!! route('client.debtor.invoice.edit', [$datas['clientId'], $debtor->id]) !!}"><i class="fa  fa-edit" rel="tooltip" title="Edit"></i>  </a>&nbsp;&nbsp;
                                    @if($debtor->invoice_status_code_id != 18)
                                     <a href="{!! route('client.debtor.invoice.delete', [$datas['clientId'], $debtor->id]) !!}"><i class="fa  fa-archive" rel="tooltip" title="Edit"></i>  </a>&nbsp;&nbsp;
                                     @endif
                                    <a href="{!! route('client.debtor.invoice.payment', [$datas['clientId'], $debtor->id]) !!}"><i class="fa  fa-money" rel="tooltip" title="Payment"></i>  </a>&nbsp;&nbsp;
                                 <a href="{!! route('client.debtor.invoice.due', [$datas['clientId'], $debtor->id]) !!}"><i class="fa  fa-pie-chart" rel="tooltip" title="Due"></i>  </a>&nbsp;&nbsp;
                                <a href="{!! route('client.debtor.invoice.follow', [$datas['clientId'], $debtor->id]) !!}"><i class="fa  fa-leaf" rel="tooltip" title="Follow"></i>  </a>&nbsp;&nbsp;


                                </td>

                            </tr>
                            @endforeach
                            </tbody>
                        </table>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">

            </div>
        </div>

    </div><!-- /.box-body -->
    <div class="panel-footer">
      <div class="panel-footer">
        {!! $debtors->render() !!}
    </div>
    </div>
</div>
@else
<div class="panel panel-default">
    <div class="panel-heading">
        <div class="row">
            <div class="col-md-12">
                <div class="panel-heading pull-left">
                    <h3 class="panel-title">Client</h3>
                </div>

                <div class="pull-right">

                </div>
            </div>
        </div>
    </div><!-- /.box-header -->
    <div class="panel-body">
        {!! Form::open(array('route' => array('file.import','clientId'=> $datas['clientId']), 'class' => 'form', 'novalidate' => 'novalidate', 'files' => true)) !!}
        <input type="hidden" name="file_import_type" value="mapping" />
        <input type="hidden" name="model_name" value="client" />
        <div class="row">
            <div class="col-lg-12">
                <table class="table table-bordered">
                    <tr>
                        <th style="width: 10px">#</th>
                        <th>Header</th>
                        <th>Row 1</th>
                        <th>Client field</th>


                    </tr>
                    @foreach($datas['datas'][0] as $key => $value)
                    <tr>
                        <td></td>
                        <td>{!! $value !!}</td>
                        <td>{!! $datas['datas'][1][$key] !!}</td>
                        <td>

                            <input type="hidden" data-head="{!! $value !!}" data-id="{!! $key !!}" id="field-select-index{!! $key !!}" data-text="{!! $key !!}"  class="field-select-index"
                            value="{!! array_search($value, $datas['fieldsCheck']) !!}"
                             name="array_id_{!! $key !!}">

                        </td>

                    </tr>
                    @endforeach
                </table>
            </div>
        </div>

    </div><!-- /.box-body -->
    <div class="panel-footer">
        {!! Form::submit('Import', array('class' => 'btn btn-success')) !!} &nbsp;&nbsp;
        <a href="{!!URL::route('client.index')!!}" class="btn btn-default">Cancel</a>
        {!!Form::close()!!}
    </div>
</div>
@endif


@stop
@section('include-js')
@parent

<script src="{!! asset('assets/form-wizard/bootstrap-validator.min.js') !!}" type="text/javascript"></script>

<!--Form Wizard-->
<script src="{!! asset('assets/form-wizard/jquery.steps.min.js') !!}" type="text/javascript"></script>
<script type="text/javascript" src="{!! asset('assets/jquery.validate/jquery.validate.min.js') !!}"></script>

<!--wizard initialization-->
<script src="{!! asset('assets/form-wizard/wizard-init.js') !!}" type="text/javascript"></script>



@stop

            @section('document-ready-js')
            @parent

//  $("#dropzone").dropzone({ url: "{!! route('file.import') !!}" });

            var getFieldUrl = '{!! route("field.index") !!}';
            var fieldArray = [];
            function field(dataAuto)
            {
            $((dataAuto.class)).select2({
            width: '100%',
                    minimumInputLength: 0,
                    ajax: {
                    url: getFieldUrl,
                            dataType: 'json',
                            quietMillis: 100,
                            data: function (term) {
                            console.log($(this));
                                    return {
                                    term: term,
                                            action:'field',
                                            model_id: '6'
                                    };
                            },
                            results: function (data) {

                            //  console.log(data);
                            var results = [];
                                    $.each(data, function (index, item) {

                                    fieldArray[item.db_name] = item.name;
                                            results.push({
                                            id: item.db_name,
                                                    text: item.name,
                                            });
                                    });
                                    console.log(fieldArray);
                                    return {
                                    results: results
                                    };
                            }
                    },
                    initSelection : function (element, callback) {
                       if(dataAuto.check == 'int')
                       {
                var data = {id: dataAuto.val, text: dataAuto.text };
                    callback(data);
                       }
                    }
            });

            }

    $clientFieldArray = <?php echo json_encode($datas["fields"]); ?>;

    $('.field-select-index').each(function () {



        if ($(this).attr('data-head'))
        {
           var id = $(this).attr('data-id');
           var dbName = $(this).attr('data-head');
           var valDb='';

            $('#field-select-index'+id).select2({
                width: '100%',
                minimumInputLength: 0,
                data : $clientFieldArray,

            });


        }

    //data.push({id: $( this ).attr('data-id'), text: $( this ).attr('data-name')});
    });
            @stop
