@extends('layouts.master')
@section('title')
@parent
Customers
@stop

@section('content')
<div class="box">
    <div class="box-header">
        <h3 class="box-title">Customers </h3> 
        <div class="btn-group pull-right">
                    {!! link_to_route('customer.create' , 'Add customer', [], ['class' => 'btn btn-success btn-create']) !!}
                </div>
    </div><!-- /.box-header -->
    <div class="box-body">
        <table class="table table-bordered">
            <tr>
                <th style="width: 10px">#</th>
                <th>First name</th>
                <th>Last name</th>
                <th>Email</th>
                <th >Action</th>
            </tr> 

            @foreach($customers as $customer)

            <tr>
                <td></td>
                <td>{!!$customer->first_name !!}</td>
                <td>{!! $customer->last_name !!}</td>
                <td>
                    {!! $customer->email !!}
                </td>
                <td>
                    {!! link_to_route('customer.edit', 'Edit', [$customer->id], ['role' => 'menuitem', 'class'=>'btn btn-info']) !!}
                    {!! link_to_route('customer.delete', 'Delete', [$customer->id], ['role' => 'menuitem', 'class'=>'btn btn-danger']) !!}    

                </td>
            </tr>
            @endforeach
        </table>
    </div><!-- /.box-body -->
    <div class="box-footer clearfix">
        {!! $customers->render() !!}
    </div>
</div>

@stop
@section('include-js')
@parent

@stop

