@extends('layouts.master')
@section('title')
@parent
Client detail
@stop

@section('content')
<div class="row">
    <div class="col-sm-12">
        <h4 class="pull-left page-title"> </h4>
        <ol class="breadcrumb pull-right">
            <li><a href="{!! route('home.index') !!}">Dashboard</a></li>
            <li><a href="{!! URL::route('client.index') !!}">Client</a></li>  

            <li><a href="{!! URL::route('client.detail', [$client->id]) !!}">{!! $client->name !!}</a></li> 
            <li><a href="{!! URL::route('client.invoice', [$client->id]) !!}">Client invoice</a></li> 
            <li>{!! $clientInvoice->invoice_code !!}</li>
        </ol>
    </div>
</div> 
<div class="row"> 
    <div class="col-md-9"> 
        <div class="nav-tabs-custom">
            @include('clients/nav')
            <div class="tab-content">
                <div class="tab-pane active"> 
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <div class="row"> 
                                <div class="col-md-12">
                                    <div class="panel-heading pull-left">
                                        <h3 class="panel-title">Client invoice Detail</h3>
                                    </div>

                                    <div class="pull-right">

                                        <div class="btn-group pull-right">
                                            <input class="form-control" value=""  id="month-select" >
                                        </div> 

                                    </div> 
                                </div>
                            </div>
                        </div><!-- /.box-header -->
                        <div class="panel-body table-rep-plugin">  
                            <table class="table table-bordered detail-table">
                                <tr class="detail-header">
                                    <th class="" colspan="4" >General Details</th>
                                </tr>
                                <tr>
                                    <td class="detail-content-label">Debtor Name :</td>
                                    <td class="detail-content-value">{!! $clientInvoice->debtor->name !!}</td>
                                    <td class="detail-content-label"></td>
                                    <td class="detail-content-value " > {!! ( $clientInvoice->debtorInvoice)? $clientInvoice->debtorInvoice->invoice_date : '' !!}</td>

                                </tr>
                                <tr>

                                    <td class="detail-content-value" colspan="2" > 
                                        <h3 class="text-center" >Collection list </h3> 
                                        @foreach(  $clientInvoice->debtorInvoice->payments()->get() as $collection )
                                        <div class="row">
                                            <div class="col-md-6" > {!! $collection->payment_date !!} </div>
                                            <div class="col-md-6 text-right" > {!! $collection->amount !!} </div>
                                        </div>

                                        @endforeach

                                    </td> 
                                    <td class="detail-content-value" colspan="2" > 
                                        <h3 class="text-center" >Pay list </h3> 
                                        @foreach(  $clientInvoice->clientTransactions()->get() as $transaction )
                                        <div class="row">
                                            <div class="col-md-6" > {!! $transaction->paid_date !!} </div>
                                            <div class="col-md-6 text-right" > {!! $transaction->amount !!} </div>
                                        </div>

                                        @endforeach

                                    </td>
                                </tr> 
                                <tr>
                                    <td class="detail-content-label">Total</td>
                                    <td class="detail-content-value text-right" >{!! $clientInvoice->debtorInvoice->payments()->sum('amount') !!}</td>
                                    <td class="detail-content-label">Total</td>
                                    <td class="detail-content-value text-right" > {!! $clientInvoice->clientTransactions()->sum('amount') !!} </td>

                                </tr>

                            </table>
                        </div>
                    </div> 
                </div>
            </div><!-- /.tab-content -->
        </div>
    </div>

    <div class="col-md-3">
        <div class="panel panel-color panel-primary p-0  m-t-20">
            <div class="panel-heading"> 
                <h3 class="panel-title">Invoice Detail</h3> 
            </div>
            <div class="panel-body p-0">


                <a  href="{!! URL::route('client.invoice.pdf', [$client->id, $clientInvoice->id])!!}" class="list-group-item no-border" ><i class="fa fa-envelope-o"></i> Invoice Pdf  </a>

            </div><!-- /.box-body -->
        </div>
    </div> 
</div>


@stop
@section('include-js')
@parent

@stop

@section('document-ready-js')
@parent
$('#month-select').monthpicker().bind('monthpicker-click-month', function (e, month) {
var url      = "{!! route('client.invoice.detail', [$clientInvoice->client_id, $clientInvoice->id]) !!}";
var value = $(this).val();
window.location.href = url+"?filter=filter&&value="+value;
});

@stop

