@extends('layouts.master')
@section('title')
@parent
client edit
@stop

@section('content')
<div class="row">
    <div class="col-sm-12">
        <h4 class="pull-left page-title"> </h4>
        <ol class="breadcrumb pull-right">
            <li><a href="{!! route('home.index') !!}">Dashboard</a></li>
            <li><a href="{!! URL::route('client.index') !!}">Client</a></li>  

            <li><a href="{!! URL::route('client.detail', [$client->id]) !!}">{!! $client->name !!}</a></li> 
            <li><a href="{!! URL::route('client.invoice', [$client->id]) !!}">Client invoice</a></li> 
            <li>{!! $clientInvoice->invoice_code !!}</li>
        </ol>
    </div>
</div>

{!! Form::model($clientInvoice, ['method' => 'PATCH', 'route' => ['client.invoice.update', $client->id, $clientInvoice->id]]) !!}

<div class="panel panel-default">
    <div class="panel-heading">
        <div class="row"> 
            <div class="col-md-12">
                <div class="panel-heading pull-left">
                    <h3 class="panel-title"> Client Invoice Edit </h3>
                </div>

                <div class=" pull-right"> 

                </div>
            </div>
        </div>
    </div><!-- /.box-header -->
    <div class="panel-body">
        <div class="row"> 
            <div class="col-md-6">


                <div class="form-group {!! ($errors->has('commission_amount')) ? 'has-error' : '' !!}">
                    {!! Form::label('commission_amount', 'Amount') !!}
                    {!! Form::text('commission_amount', null, array('class' => 'form-control text-right', 'placeholder' => 'Eg: 0.00')) !!}
                    {!! ($errors->has('commission_amount') ? $errors->first('minimum_fees') : '') !!}
                </div> 



            </div>
            <div class="col-md-6"> 


            </div>
        </div>
    </div> 
    <div class="panel-footer"> 

        {!! Form::submit('Update', array('class' => 'btn btn-info')) !!} &nbsp;&nbsp;
        <a href="{!! URL::route('client.invoice', [$client->id])!!}" class="btn btn-default">Cancel</a>
        {!!Form::close()!!} 

    </div>
</div> 


@stop
@section('include-js')
@parent

@stop

