@extends('layouts.master')
@section('title')
@parent
Client detail
@stop

@section('content') 
<div class="row"> 
    <div class="col-md-9"> 
          <ol class="breadcrumb">
                                <li><a href="{!! URL::route('client.index') !!}">Client</a></li> 
                                <li><a href="{!! URL::route('client.detail', [$client->id]) !!}">{!! $client->name !!}</a></li> 
                                <li><a href="{!! URL::route('client.debtor.invoice', [$client->id]) !!}">Debtor invoice</a></li>
                           <li>Debtor invoice detail</li> 
                           <li>{!! $invoice->invoice_code !!}</li>
                                     
                                     </ol>
        <div class="nav-tabs-custom">
            <div class="pull-right">
                <a href="{!!URL::route('client.debtor.invoice.edit', [$client->id,$invoice->id])!!}" class="btn btn-info">Edit</a>
            </div>
            @include('clients/nav')
            
            <div class="tab-content">
                <div class="tab-pane active"> 

                    <div class="box ">
                        <div class="box-header">

                        </div> 
                        <div class="box-body">  


                            <table class="table table-bordered detail-table">
                                <tr class="detail-header">
                                   
                                    <th class="" colspan="4" >General Details</th>

                                </tr>
                                <tr>
                                    <td class="detail-content-label">Invoice code :</td>
                                    <td class="detail-content-value">{!! $invoice->invoice_code !!}</td>
                                    <td class="detail-content-label"> Client  : </td>
                                    <td class="detail-content-value">{!! ($invoice->client)? $invoice->client->name : '' !!}</td>
                                </tr> 
                                <tr>
                                    <td class="detail-content-label">Debtor :</td>
                                    <td class="detail-content-value" >{!! ($invoice->debtor)? $invoice->debtor->name : '' !!}</td>
                                    <td class="detail-content-label"> Invoice date : </td>
                                    <td class="detail-content-value" >{!! $invoice->invoice_date !!}</td>
                                </tr>  
                                <tr>
                                    <td class="detail-content-label">Invoice state:</td>
                                    <td class="detail-content-value" >{!! $invoice->invoice_state !!}</td>
                                    <td class="detail-content-label"> Account state  : </td>
                                    <td class="detail-content-value" >{!! $invoice->account_state !!}</td>
                                </tr>  
                                <tr>
                                    <td class="detail-content-label">Follow up :</td>
                                    <td class="detail-content-value" >{!! ($invoice->user)? $invoice->user->first_name.' '.$invoice->user->last_name : ''  !!}</td>
                                    <td class="detail-content-label"></td>
                                    <td class="detail-content-value" ></td>
                                </tr> 


                            </table>


                        </div>
                    </div> 
                    <div class="box ">
                        <div class="box-header">

                        </div> 
                        <div class="box-body">  
                            <table class="table table-bordered detail-table">
                                <tr class="detail-header">
                                    <th class="" colspan="4" >Acount detail Details</th>

                                </tr>
                                <tr>
                                    <td class="detail-content-label">Original debt :</td>
                                    <td class="detail-content-value">{!! $invoice->original_debt !!}</td>
                                    <td class="detail-content-label"> Current balance : </td>
                                    <td class="detail-content-value">{!! $invoice->current_balance !!}</td>
                                </tr>
                                <tr>
                                    <td class="detail-content-label">Total paid :</td>
                                    <td class="detail-content-value" >{!! $invoice->total_paid !!}</td>
                                    <td class="detail-content-label"> Last payment: </td>
                                    <td class="detail-content-value" >{!! $invoice->last_payment !!}</td>
                                </tr>  
                                <tr>
                                    <td class="detail-content-label">Last paid </td>
                                    <td class="detail-content-value" >{!! $invoice->last_paid !!}</td>
                                    <td class="detail-content-label"> Solicitor costs to date : </td>
                                    <td class="detail-content-value" >{!! $invoice->solicitor_cost_date !!}</td>
                                </tr> 
                                <tr>
                                    <td class="detail-content-label">Recoverable costs to date </td>
                                    <td class="detail-content-value" >{!! $invoice->recoverable_cost_date !!}</td>
                                    <td class="detail-content-label"> Non recoverable costs date: </td>
                                    <td class="detail-content-value" >{!! $invoice->non_recoverable_cost_date !!}</td>
                                </tr>  
                                <tr>
                                    <td class="detail-content-label">Debt recovered to date </td>
                                    <td class="detail-content-value" >{!! $invoice->debt_recovered_date !!}</td>
                                    <td class="detail-content-label"> costs recovered to date : </td>
                                    <td class="detail-content-value" >{!! $invoice->costs_recovered_date !!}</td>
                                </tr>  


                            </table>


                            <div class="box-footer clearfix"> 
                                <div class=" pull-right"> 


                                </div>
                            </div>

                        </div> 


                    </div>   

                    @if($invoice->invoice_state =='legal action')
                    <div class="box ">
                        <div class="box-header">

                        </div> 
                        <div class="box-body">  
                            <table class="table table-bordered detail-table">
                                <tr class="detail-header">
                                    <th class="" colspan="4" >Legal arrangement</th>

                                </tr>
                                 <tr>
                                    <td class="detail-content-label">Plaint filed :</td>
                                    <td class="detail-content-value" colspan="3" >{!! nl2br( $invoice->plaint_filed) !!}</td>
                                </tr>
                                <tr>
                                     <td class="detail-content-label">judgement date </td>
                                    <td class="detail-content-value" >{!! $invoice->judgement_date !!}</td>
                                    <td class="detail-content-label"> Plaint served : </td>
                                    <td class="detail-content-value">{!! $invoice->plaint_served !!}</td>
                                </tr>
                                <tr>
                                    <td class="detail-content-label">court :</td>
                                    <td class="detail-content-value" >{!! $invoice->court !!}</td>
                                    <td class="detail-content-label"> Plaint number: </td>
                                    <td class="detail-content-value" >{!! $invoice->plaint_number !!}</td>
                                </tr> 
                               
                                <tr>
                                   
                                    <td class="detail-content-label"> arrangement : </td>
                                    <td class="detail-content-value" colspan="3" >{!! nl2br($invoice->arrangement) !!}</td>
                                </tr> 
                                 


                            </table>


                            <div class="box-footer clearfix"> 
                                <div class=" pull-right"> 


                                </div>
                            </div>

                        </div> 


                    </div>  

                    @endif
                    
                    @include('clients/invoices/debtor/menu/footerMenu')

                </div> 

            </div>
        </div><!-- /.tab-content -->
    </div> 
    <div class="col-md-3 "> 
        <div class="box box-solid">
            <div class="box-header with-border right-side-nav-header">
                <h3 class="box-title">Client Detail</h3>
            </div>
            <div class="box-body no-padding">
                <ul class="nav nav-pills nav-stacked">
                    <li ><a href="#"><i class="fa fa-envelope-o"></i> Mail  </a></li>
                    <li><a href="#"><i class="fa  fa-building-o"></i> Email template</a></li>
                    <li><a href="#"><i class="fa fa-users"></i> Contact</a> </li>
                    <li><a href="#"><i class="fa fa-filter"></i> Legal </a></li>
                    <li><a href="#" id="email-pop-button"><i class="fa fa-envelope-o"></i> Send FDL </a></li>

                </ul>
            </div><!-- /.box-body -->
        </div>
    </div>
</div>

@include('clients/include/pop/debtorInvoice/sendFDLEmail')

@stop
@section('include-js')
@parent

@stop

<script>
    @section('document-ready-js')
            @parent

            @include('clients/include/pop/debtorInvoice/sendFDLEmailJs')

            $('#email-content-data').textcomplete([
        {// tech companies 
            words: ['apple', 'google', 'facebook', 'github'],
            match: /\b(\w{2,})$/,
            search: function(term, callback) {

                alert(1);
                callback($.map(this.words, function(word) {
                    return word.indexOf(term) === 0 ? word : null;
                }));


            },
            index: 1,
            replace: function(word) {
                return word + ' ';
            }
        }
    ]);



    @stop

</script>