@extends('layouts.master')
@section('title')
@parent
Debitor invoice
@stop

@section('content')
<div class="box">
    <div class="box-header">
        <h3 class="box-title">Debitor invoice create</h3>
    </div><!-- /.box-header -->
    <div class="box-body">
        {!! Form::open(array('route' => array('client.debtor.invoice.store', $client->id), 'autocomplete' => 'off')) !!}

       <div class="form-group {!! ($errors->has('debtor_id')) ? 'has-error' : '' !!}">
           {!! Form::label('debtor_id', 'Debtor', ['class' => 'control-label']) !!}
           {!!  Form::select('debtor_id',  $debtors, null  ,['class' => 'form-control', 'placeholder' => 'state', 'required'])  !!}
            <span class="help-block">{!! ($errors->has('debtor_id') ? $errors->first('debtor_id') : '') !!}</span>
       </div>
        <div class="form-group {!! ($errors->has('invoice_date')) ? 'has-error' : '' !!}">
            {!! Form::label('invoice_date', 'Invoice date') !!}
            {!! Form::text('invoice_date', null, array('class' => 'form-control datepicker', 'placeholder' => 'Eg: 03/19/2015', 'autocomplete' => 'off')) !!}
            {!! ($errors->has('invoice_date') ? $errors->first('invoice_date') : '') !!}
        </div> 
        
        <div class="form-group {!! ($errors->has('invoice_state')) ? 'has-error' : '' !!}">
           {!! Form::label('invoice_state', 'Invoice state', ['class' => 'control-label']) !!}
           {!!  Form::select('invoice_state',  [ 'create'=>'Create', 'processing'=>'Processing', 'complete'=>'Complete', 'legal action'=>'Legal action', 'cancel'=>'Cancel'], null  ,['class' => 'form-control', 'placeholder' => 'state', 'required'])  !!}
            <span class="help-block">{!! ($errors->has('invoice_state') ? $errors->first('invoice_state') : '') !!}</span>
       </div> 
        
        <div class="form-group {!! ($errors->has('account_state')) ? 'has-error' : '' !!}">
           {!! Form::label('account_state', 'Account state', ['class' => 'control-label']) !!}
           {!!  Form::select('account_state',  [ 'p'=>'p', 't'=>'t'], null  ,['class' => 'form-control', 'placeholder' => 'state', 'required'])  !!}
            <span class="help-block">{!! ($errors->has('account_state') ? $errors->first('account_state') : '') !!}</span>
       </div>
        
        <div class="form-group {!! ($errors->has('user_id')) ? 'has-error' : '' !!}">
           {!! Form::label('user_id', 'Follow up', ['class' => 'control-label']) !!}
           {!!  Form::select('user_id',  $users, null  ,['class' => 'form-control', 'placeholder' => 'state', 'required'])  !!}
            <span class="help-block">{!! ($errors->has('user_id') ? $errors->first('user_id') : '') !!}</span>
       </div>
          <div class="form-group {!! ($errors->has('original_debt')) ? 'has-error' : '' !!}">
            {!! Form::label('original_debt', 'Original debt') !!}
            {!! Form::text('original_debt', null, array('class' => 'form-control', 'placeholder' => 'Eg: 259.00', 'autocomplete' => 'off')) !!}
            {!! ($errors->has('original_debt') ? $errors->first('invoice_date') : '') !!}
        </div>  
        
          <div class="form-group {!! ($errors->has('current_balance')) ? 'has-error' : '' !!}">
            {!! Form::label('current_balance', 'Current balance') !!}
            {!! Form::text('current_balance', null, array('class' => 'form-control', 'placeholder' => 'Eg: 25.00', 'autocomplete' => 'off')) !!}
            {!! ($errors->has('current_balance') ? $errors->first('current_balance') : '') !!}
        </div> 
        
         <div class="form-group {!! ($errors->has('last_payment')) ? 'has-error' : '' !!}">
            {!! Form::label('last_payment', 'Last payment') !!}
            {!! Form::text('last_payment', null, array('class' => 'form-control', 'placeholder' => 'Eg: 201.00', 'autocomplete' => 'off')) !!}
            {!! ($errors->has('last_payment') ? $errors->first('last_payment') : '') !!}
        </div> 
        <div class="form-group {!! ($errors->has('last_paid')) ? 'has-error' : '' !!}">
            {!! Form::label('last_paid', 'Last payment') !!}
            {!! Form::text('last_paid', null, array('class' => 'form-control datepicker', 'placeholder' => 'Eg: 03/19/2015', 'autocomplete' => 'off')) !!}
            {!! ($errors->has('last_paid') ? $errors->first('last_paid') : '') !!}
        </div> 
    </div>
    <div class="box-footer clearfix"> 
        <div class=" pull-right">
            {!! Form::submit('Create', array('class' => 'btn btn-success')) !!} &nbsp;&nbsp;
            <a href="{!!URL::route('client.debtor', [$client->id])!!}" class="btn btn-default">Cancel</a>
            {!!Form::close()!!} 
        </div>
    </div>
</div>

@stop
@section('include-js')
@parent

@stop

