@extends('layouts.master')
@section('title')
@parent
Debitor invoice
@stop

@section('content')


<div class="nav-tabs-custom">
    @include('clients/nav')
    <div class="tab-content">

        <!-- /.tab-pane -->

        <div class="tab-pane active" >
            <div class="box">
                <div class="box-header">
                    <h3 class="box-title">Debitor invoice create</h3>
                </div>
                <div class="box-body"> 
                    <div class="box box-info">
                        <div class="box-header">  
                            <ol class="breadcrumb">
                                <li><a href="{!! URL::route('client.index') !!}">Client</a></li> 
                                <li><a href="{!! URL::route('client.debtor', [$client->id]) !!}">Debtor invoice</a></li>
                                <li>Create invoice</li>
                            </ol>
                            <h3 class="box-title">Invoice general</h3>
                        </div> 
                        <div class="box-body">
                            <div class="row"> 
                                <div class="col-md-6">
                                    {!! Form::open(array('route' => array('client.debtor.invoice.store', $client->id), 'autocomplete' => 'off')) !!}

                                    <div class="form-group {!! ($errors->has('debtor_id')) ? 'has-error' : '' !!}">
                                        {!! Form::label('debtor_id', 'Debtor', ['class' => 'control-label']) !!}
                                        {!!  Form::select('debtor_id',  $debtors, null  ,['class' => 'form-control ', 'placeholder' => 'state', 'required'])  !!}
                                        <span class="help-block">{!! ($errors->has('debtor_id') ? $errors->first('debtor_id') : '') !!}</span>
                                    </div>
                                    <div class="form-group {!! ($errors->has('invoice_date')) ? 'has-error' : '' !!}">
                                        {!! Form::label('invoice_date', 'Invoice date') !!}
                                        {!! Form::text('invoice_date', null, array('class' => 'form-control datepicker', 'placeholder' => 'Eg: 03/19/2015', 'autocomplete' => 'off')) !!}
                                        {!! ($errors->has('invoice_date') ? $errors->first('invoice_date') : '') !!}
                                    </div> 

                                    <div class="form-group {!! ($errors->has('invoice_state')) ? 'has-error' : '' !!}">
                                        {!! Form::label('invoice_state', 'Invoice state', ['class' => 'control-label']) !!}
                                        {!!  Form::select('invoice_state',  [ 'create'=>'Create', 'processing'=>'Processing', 'complete'=>'Complete', 'legal action'=>'Legal action', 'cancel'=>'Cancel'], null  ,['class' => 'form-control', 'placeholder' => 'state', 'required'])  !!}
                                        <span class="help-block">{!! ($errors->has('invoice_state') ? $errors->first('invoice_state') : '') !!}</span>
                                    </div> 
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group {!! ($errors->has('account_state')) ? 'has-error' : '' !!}">
                                        {!! Form::label('account_state', 'Account state', ['class' => 'control-label']) !!}
                                        {!!  Form::select('account_state',  [ 'p'=>'p', 't'=>'t'], null  ,['class' => 'form-control', 'placeholder' => 'state', 'required'])  !!}
                                        <span class="help-block">{!! ($errors->has('account_state') ? $errors->first('account_state') : '') !!}</span>
                                    </div>

                                    <div class="form-group {!! ($errors->has('user_id')) ? 'has-error' : '' !!}">
                                        {!! Form::label('user_id', 'Follow up', ['class' => 'control-label']) !!}
                                        {!!  Form::select('user_id',  $users, null  ,['class' => 'form-control', 'placeholder' => 'state', 'required'])  !!}
                                        <span class="help-block">{!! ($errors->has('user_id') ? $errors->first('user_id') : '') !!}</span>
                                    </div>   
                                </div>
                            </div> 
                        </div>
                    </div>  

                    <div class="box box-info">
                        <div class="box-header">
                            <h3 class="box-title"> Accounts details  </h3>
                        </div> 
                        <div class="box-body"> 
                            <div class="row"> 
                                <div class="col-md-6">
                                    <div class="form-group {!! ($errors->has('original_debt')) ? 'has-error' : '' !!}">
                                        {!! Form::label('original_debt', 'Original debt') !!}
                                        {!! Form::text('original_debt', null, array('class' => 'form-control', 'placeholder' => 'Eg: 259.00', 'autocomplete' => 'off')) !!}
                                        {!! ($errors->has('original_debt') ? $errors->first('invoice_date') : '') !!}
                                    </div>  

                                    <div class="form-group {!! ($errors->has('current_balance')) ? 'has-error' : '' !!}">
                                        {!! Form::label('current_balance', 'Current balance') !!}
                                        {!! Form::text('current_balance', null, array('class' => 'form-control', 'placeholder' => 'Eg: 25.00', 'autocomplete' => 'off')) !!}
                                        {!! ($errors->has('current_balance') ? $errors->first('current_balance') : '') !!}
                                    </div>  
                                    <div class="form-group {!! ($errors->has('non_recoverable_cost_date')) ? 'has-error' : '' !!}">
                                        {!! Form::label('non_recoverable_cost_date', 'Non recoverable costs to date') !!}
                                        {!! Form::text('non_recoverable_cost_date', null, array('class' => 'form-control datepicker', 'placeholder' => 'Eg: 03/19/2015', 'autocomplete' => 'off')) !!}
                                        {!! ($errors->has('non_recoverable_cost_date') ? $errors->first('non_recoverable_cost_date') : '') !!}
                                    </div> 
                                    <div class="form-group {!! ($errors->has('debt_recovered_date')) ? 'has-error' : '' !!}">
                                        {!! Form::label('debt_recovered_date', 'Debt recovered to date') !!}
                                        {!! Form::text('debt_recovered_date', null, array('class' => 'form-control datepicker', 'placeholder' => 'Eg: 03/19/2015', 'autocomplete' => 'off')) !!}
                                        {!! ($errors->has('debt_recovered_date') ? $errors->first('debt_recovered_date') : '') !!}
                                    </div> 
                                    <div class="form-group {!! ($errors->has('costs_recovered_date')) ? 'has-error' : '' !!}">
                                        {!! Form::label('costs_recovered_date', 'Costs recovered to date') !!}
                                        {!! Form::text('costs_recovered_date', null, array('class' => 'form-control datepicker', 'placeholder' => 'Eg: 03/19/2015', 'autocomplete' => 'off')) !!}
                                        {!! ($errors->has('costs_recovered_date') ? $errors->first('costs_recovered_date') : '') !!}
                                    </div> 
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group {!! ($errors->has('last_payment')) ? 'has-error' : '' !!}">
                                        {!! Form::label('last_payment', 'Last payment') !!}
                                        {!! Form::text('last_payment', null, array('class' => 'form-control', 'placeholder' => 'Eg: 201.00', 'autocomplete' => 'off')) !!}
                                        {!! ($errors->has('last_payment') ? $errors->first('last_payment') : '') !!}
                                    </div> 
                                    <div class="form-group {!! ($errors->has('last_paid')) ? 'has-error' : '' !!}">
                                        {!! Form::label('last_paid', 'Last payment date') !!}
                                        {!! Form::text('last_paid', null, array('class' => 'form-control datepicker', 'placeholder' => 'Eg: 03/19/2015', 'autocomplete' => 'off')) !!}
                                        {!! ($errors->has('last_paid') ? $errors->first('last_paid') : '') !!}
                                    </div>  
                                    <div class="form-group {!! ($errors->has('solicitor_cost_date')) ? 'has-error' : '' !!}">
                                        {!! Form::label('solicitor_cost_date', 'Solicitor costs to date') !!}
                                        {!! Form::text('solicitor_cost_date', null, array('class' => 'form-control datepicker', 'placeholder' => 'Eg: 03/19/2015', 'autocomplete' => 'off')) !!}
                                        {!! ($errors->has('solicitor_cost_date') ? $errors->first('solicitor_cost_date') : '') !!}
                                    </div> 
                                    <div class="form-group {!! ($errors->has('recoverable_cost_date')) ? 'has-error' : '' !!}">
                                        {!! Form::label('recoverable_cost_date', 'Recoverable costs to date') !!}
                                        {!! Form::text('recoverable_cost_date', null, array('class' => 'form-control datepicker', 'placeholder' => 'Eg: 03/19/2015', 'autocomplete' => 'off')) !!}
                                        {!! ($errors->has('recoverable_cost_date') ? $errors->first('recoverable_cost_date') : '') !!}
                                    </div> 


                                </div>
                            </div>
                        </div>
                    </div> 

                </div>
                <div class="box-footer clearfix"> 
                    <div class=" pull-right">
                        {!! Form::submit('Create', array('class' => 'btn btn-success')) !!} &nbsp;&nbsp;
                        <a href="{!!URL::route('client.debtor', [$client->id])!!}" class="btn btn-default">Cancel</a>
                        {!!Form::close()!!} 
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>





@stop
@section('include-js')
@parent

@stop
@section('document-ready-js')
@parent




@stop
