@extends('layouts.master')
@section('title')
@parent
Debitor
@stop

@section('content')
<div class="box">
    <div class="box-header">
          <ol class="breadcrumb">
             <li><a href="{!! URL::route('client.index') !!}">Client</a></li> 
                                <li><a href="{!! URL::route('client.debtor', [$client->id]) !!}">Debtor invoice</a></li>
                                <li>Create debtor</li>
        </ol>
    </div><!-- /.box-header -->
    <div class="box-body">
        {!! Form::open(array('route' => array('client.debtor.store', $client->id), 'autocomplete' => 'off')) !!}   
        
        
        

         <div class="form-group {!! ($errors->has('email')) ? 'has-error' : '' !!}">
            {!! Form::label('email', 'Email') !!}
            {!! Form::text('email', null, array('class' => 'form-control', 'placeholder' => 'Eg: example@example.com', 'autocomplete' => 'off')) !!}
            {!! ($errors->has('email') ? $errors->first('email') : '') !!}
        </div>
        
        
        <div class="form-group {!! ($errors->has('name_type')) ? 'has-error' : '' !!}">
            <div class="row">
                <div class="col-lg-2">
                    <div class="radio radio-success">
                        
                        {!!  Form::radio('name_type', 'company', true, ['class' => 'field', 'id' =>'company']) !!}
                        <label for="company">
                             Company
                        </label>
                    </div>
                   


                </div>
                <div class="col-lg-2">
                    <div class="radio ">
                       
                         {!!  Form::radio('name_type', 'person', ['class' => 'field', 'id' =>'person']) !!}
                        <label for="company">
                             person
                        </label>
                    </div>
                   


                </div>
                
            </div>
        </div>
        
       <div class="form-group personClass {!! ($errors->has('last_name')) ? 'has-error' : '' !!}">
            {!! Form::label('last_name', 'Last Name ') !!}
            {!! Form::text('last_name', null, array('class' => 'form-control last_name', 'placeholder' => 'Eg: Emery')) !!}
            {!! ($errors->has('last_name') ? $errors->first('last_name') : '') !!}
        </div> 
        <div class="form-group personClass {!! ($errors->has('first_name')) ? 'has-error' : '' !!}">
            {!! Form::label('first_name', 'First Name ') !!}
            {!! Form::text('first_name', null, array('class' => 'form-control first_name', 'placeholder' => 'Eg: Emery')) !!}
            {!! ($errors->has('first_name') ? $errors->first('first_name') : '') !!}
        </div> 
        <div class="form-group nameClass {!! ($errors->has('name')) ? 'has-error' : '' !!}">
            {!! Form::label('name', 'Debtor Name ') !!}
            {!! Form::text('name', null, array('class' => 'form-control name', 'placeholder' => 'Eg: Emery')) !!}
            {!! ($errors->has('name') ? $errors->first('name') : '') !!}
        </div> 
          <div class="form-group  {!! ($errors->has('debtor_code')) ? 'has-error' : '' !!}">
            {!! Form::label('debtor_code', 'Debtor code') !!}
            {!! Form::text('debtor_code', null, array('class' => 'form-control debtor_code', 'placeholder' => 'Eg: LLLLLFF')) !!}
            {!! ($errors->has('debtor_code') ? $errors->first('debtor_code') : '') !!}
        </div>
        <div class="form-group {!! ($errors->has('mailing_address')) ? 'has-error' : '' !!}">
            {!! Form::label('mailing_address', 'Mailing address') !!}
            {!! Form::text('mailing_address', null, array('class' => 'form-control', 'placeholder' => 'Eg: aus')) !!}
            {!! ($errors->has('mailing_address') ? $errors->first('mailing_address') : '') !!}
        </div>   
         <div class="form-group {!! ($errors->has('mailing_suburb')) ? 'has-error' : '' !!}">
            {!! Form::label('mailing_suburb', 'Mailing suburb') !!}
            {!! Form::text('mailing_suburb', null, array('class' => 'form-control', 'placeholder' => 'Eg: aus')) !!}
            {!! ($errors->has('mailing_suburb') ? $errors->first('mailing_suburb') : '') !!}
        </div>
         <div class="form-group {!! ($errors->has('mailing_state')) ? 'has-error' : '' !!}">
            {!! Form::label('mailing_state', 'Mailing state') !!}
            {!!  Form::select('mailing_state',  ['' => '', 'NSW'=>'NSW', 'TAS'=>'TAS', 'QLD'=>'QLD', 'WA'=>'WA', 'SA'=>'SA', 'VIC'=>'VIC', 'ACT'=>'ACT', 'NT'=>'NT'], null  ,['class' => 'form-control', 'placeholder' => 'state', 'id'=>'state'])  !!}
            <input id="new-state" type="text" />
            <button type="button" id="btn-add-state">Set new state value</button>
            {!! ($errors->has('mailing_state') ? $errors->first('mailing_state') : '') !!}
        </div> 
        <div class="form-group {!! ($errors->has('mailing_postcode')) ? 'has-error' : '' !!}">
            {!! Form::label('mailing_postcode', 'Mailing postcode ') !!}
            {!! Form::text('mailing_postcode', null, array('class' => 'form-control', 'placeholder' => 'Eg: aus')) !!}
            {!! ($errors->has('mailing_postcode ') ? $errors->first('mailing_postcode ') : '') !!}
        </div> 
        <div class="form-group {!! ($errors->has('contact_number ')) ? 'has-error' : '' !!}">
            {!! Form::label('contact_number', 'Contact Number ') !!}
            {!! Form::text('contact_number', null, array('class' => 'form-control', 'placeholder' => 'Eg: 011222444')) !!}
            {!! ($errors->has('contact_number ') ? $errors->first('contact_number ') : '') !!}
        </div>
    </div>
    <div class="box-footer clearfix"> 
        <div class=" pull-right">
            {!! Form::submit('Create', array('class' => 'btn btn-success')) !!} &nbsp;&nbsp;
            <a href="{!!URL::route('debtor.index')!!}" class="btn btn-default">Cancel</a>
            {!!Form::close()!!} 
        </div>
    </div>
</div>

@stop
@section('include-js')
@parent

@stop 


    @section('document-ready-js')
            @parent
            $('.personClass').hide();
            $("input[name='name_type']").click(function(){
    nameType();
    
    }); 
    
    function nameType()
    {
    if($('input:radio[name=name_type]:checked').val() == "company"){
        $('.personClass').hide();
        $('.nameClass').show();
        //$('#select-table > .roomNumber').attr('enabled',false);
        }
        else
        {
          $('.personClass').show();
        $('.nameClass').hide();  
        }
    }

     nameType(); 
     
     var DebtorCodeString= '';
function DebtorCode()
     { 
     DebtorCodeString = '';
        if($('input:radio[name=name_type]:checked').val() == "company"){ 
          
          var name = $('.name').val().replace(/ /g,''); 
            console.log(name);
          if(name.length > 5)
       {
          DebtorCodeString = name.substring(0, 5);
        } 
         else
        {
        DebtorCodeString = name.substring(0, name.length); 
        
        } 
        }
        else
        {
       var firstName = $('.first_name').val().replace(/ /g,''); 
       var lastName = $('.last_name').val().replace(/ /g,''); 
       if(lastName.length > 5)
       {
          DebtorCodeString = lastName.substring(0, 5);
        } 
        else
        {
        DebtorCodeString = lastName.substring(0, lastName.length); 
        
        } 
        
        if(firstName.length > 2)
       {
          DebtorCodeString = DebtorCodeString +firstName.substring(0, 2);
        } 
        else
        {
        DebtorCodeString = DebtorCodeString + firstName.substring(0, firstName.length);
        }
        
     }  
     $('.debtor_code').val(DebtorCodeString);
     console.log(DebtorCodeString);
 } 
 $('.first_name').change(function () { 
     DebtorCode();
 }); 
 $('.last_name').change(function () { 
     DebtorCode();
 }); 
 $('.name').change(function () { 
     DebtorCode();
 });  


 $("#btn-add-state").on("click", function(){
    var newStateVal = $("#new-state").val();
    // Set the value, creating a new option if necessary
    if ($("#state").find("option[value='" + newStateVal + "']").length) {
      $("#state").val(newStateVal).trigger("change");
    } else { 
      // Create the DOM option that is pre-selected by default
      var newState = new Option(newStateVal, newStateVal, true, true);
      // Append it to the select
      $("#state").append(newState).trigger('change');
    } 
  }); 

            @stop


