@extends('layouts.master')
@section('title')
@parent
Payments
@stop

@section('content')
<ol class="breadcrumb">
    <li><a href="{!! URL::route('client.index') !!}">Client</a></li> 
    <li><a href="{!! URL::route('client.detail', [$client->id]) !!}">{!! $client->name !!}</a></li> 
    <li><a href="{!! URL::route('client.debtor.invoice', [$client->id]) !!}">Debtor invoice</a></li>
    <li><a href="{!! URL::route('client.debtor.invoice.show', [$client->id, $invoice->id]) !!}">{!! $invoice->invoice_code !!}</a></li>


</ol>

<div class="nav-tabs-custom">
    @include('clients/nav')
    <div class="tab-content">

        <!-- /.tab-pane -->

        <div class="tab-pane active" > 
            @if( ! count($dues)) 

            <div class="panel panel-default">
                <div class="panel-heading">
                    <div class="row"> 
                        <div class="col-md-12">
                            <div class="panel-heading pull-left">
                                <h3 class="panel-title"> Payments</h3>
                            </div>

                            <div class=" pull-right"> 
                            </div>
                        </div>
                    </div>
                </div><!-- /.box-header -->
                <div class="panel-body"> 


                    <div class="row">
                        <div class="col-md-12">
                            <div class="row" > 
                                <div class="col-md-2">
                                    <label class="control-label" > Number of Dues</label>
                                </div> 
                                <div class="col-md-3">
                                    <input type="text" class="form-control" id="no-of-due" >
                                </div> 
                                <div class="col-md-2">
                                    <div class="btn btn-warning" id="add-due-btn" >Create Due</div>
                                </div>  
                                <div class="col-md-1 ">
                                    <h4 class="text-info" >Or</h4>
                                </div> 
                                <div class=" col-md-3 ">
                                    <div class="btn btn-warning" id="invoice-pay-pop" >Invoice pay</div>
                                </div>
                            </div> 


                            {!! Form::open(array('route' => array('client.debtor.invoice.due.store',  $invoice->client_id, $invoice->id), 'autocomplete' => 'off')) !!}
                            <div class="row">
                                <div class="col-md-12 add-dues-class">

                                </div>
                            </div> 



                        </div>
                    </div>
                </div> 
                <div class="panel-footer"> 
                    <div class="row submit-button-dive"> 
                        <div class="col-md-10 "> 
                            <div class=" pull-right"> 
                                <input type="hidden" name="dueSaveType" value="dueCreate" >
                                {!! Form::submit('Create due', array('class' => 'btn btn-success')) !!} &nbsp;&nbsp;
                                <button class="btn btn-default" id="due-create-cencel">Cancel</button>
                                {!!Form::close()!!}  
                            </div>
                        </div>
                    </div>
                </div>
            </div> 
            @else 

            <div class="panel panel-default">
                <div class="panel-heading">
                    <div class="row"> 
                        <div class="col-md-12">
                            <div class="panel-heading pull-left">
                                <h3 class="panel-title"> Dues</h3>
                            </div>

                            <div class=" pull-right"> 
                            </div>
                        </div>
                    </div>
                </div><!-- /.box-header -->
                <div class="panel-body"> 
                    <table class="table table-bordered">
                        <tr>
                            <th style="width: 10px">#</th>
                            <th>Due date</th>
                            <th  class="text-right" >Amount</th> 
                            <th>State</th>
                            <th >Action</th>
                        </tr> 

                        @foreach($dues as $due)

                        <tr>
                            <td></td>
                            <td>{!! $due->due_date !!}</td>
                            <td class="text-right" >{!! $due->amount !!}</td> 
                            <td>{!! $due->due_state !!}</td>
                            <td> 
                                <div class="row"> 
                                    <div class="col-md-6" >
                                        <div class="payment-due-pop" data-due-id="{!! $due->id !!}" data-original-amount="{!! $due->amount !!}" data-current-amount="{!! $due->balance !!}" ><i class="fa  fa-money" rel="tooltip" title="Payment"></i>  </div>
                                    </div>
                                    <div class="col-md-6" >
                                        <div class="payment-due-detail-pop" data-due-id="{!! $due->id !!}" ><i class="fa  fa-bars" rel="tooltip" title="Payment"></i>  
                                            <div class="" style="display: none" >
                                                <table class="table table-bordered" id=due-payment-{!! $due->id !!} >
                                                                                          <tr>
                                                                                              <th style="width: 10px">#</th>
                                                                                                  <th>payment date</th>
                                                                                                  <th  class="text-right" >Amount</th> 
                                                                                                  <th>Payment mode</th> 
                                                                                                  <th>Payment type</th>

                                                                                              </tr> 

                                                                                              @foreach($invoice->payments()->where('due_id' , '=', $due->id)->get() as $payment)

                                                                                              <tr>
                                                                                                  <td></td>
                                                                                                  <td>{!! $payment->payment_date !!}</td>
                                                                                                  <td class="text-right" >{!! $payment->amount !!}</td> 
                                                                                                  <td>{!! $payment->payment_type !!}</td> 
                                                                                                  <td>{!! $payment->paid_place !!}</td>



                                                                                              </tr>
                                                                                              @endforeach
                                                                                          </table>
                                                                                      </div>
                                                </div>
                                            </div>
                                        </div>
                                    </td>


                                </tr>
                                @endforeach
                            </table>
                        </div> 
                    </div>

                    @endif 

                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <div class="row"> 
                                <div class="col-md-12">
                                    <div class="panel-heading pull-left">
                                        <h3 class="panel-title"> Invoice payment history</h3>
                                    </div>

                                    <div class=" pull-right"> 
                                    </div>
                                </div>
                            </div>
                        </div><!-- /.box-header -->
                        <div class="panel-body"> 
                            <table class="table table-bordered">
                                <tr>
                                    <th style="width: 10px">#</th>
                                    <th>payment date</th>
                                    <th  class="text-right" >Amount</th> 
                                    <th>Payment mode</th>
                                    <th >Payment type</th>
                                </tr> 

                                @foreach($invoice->payments()->where('due_id' , '=', 0)->get() as $payment)

                                <tr>
                                    <td></td>
                                    <td>{!! $payment->payment_date !!}</td>
                                    <td class="text-right" >{!! $payment->amount !!}</td> 
                                    <td>{!! $payment->payment_type !!}</td>
                                    <td>{!! $payment->paid_place !!}</td>


                                </tr>
                                @endforeach
                            </table>
                        </div> 
                    </div>


                </div>
            </div>
        </div>  

        <div class="modal fade payment-due-pop-model" role="dialog" aria-labelledby="gridSystemModalLabel" aria-hidden="true">
            <div class="modal-dialog ">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title" id="gridSystemModalLabel">Payment</h4>
                    </div>
                    <div class="modal-body">
                        <div class="container-fluid">

                            <div class="row">
                                <div class="col-md-12"> 

                                    {!! Form::open(array('route' => array('client.debtor.invoice.due.store',  $invoice->client_id, $invoice->id), 'autocomplete' => 'off')) !!}
                                    <table class="table table-bordered detail-table">
                                        <tr class="detail-header">


                                        </tr>
                                        <tr>
                                            <td >Invoice code :</td>
                                            <td > 
                                                <div class="pull-right" >{!! $invoice->invoice_code !!}</div> 


                                            </td>
                                        </tr> 

                                        <tr>
                                            <td > Original due amount : </td>
                                            <td  ><div class="pull-right original-amount " >{!! $invoice->original_debt  !!}</div></td>
                                        </tr> 
                                        <tr>
                                            <td > Current due amount  : </td>
                                            <td  ><div class="pull-right current-amount" >{!! $invoice->current_balance !!}</div></td>
                                        </tr> 

                                        <tr>
                                            <td> Due payment amount  : </td>
                                            <td > 
                                                <input class="form-control text-right" id="amount" name="amount">
                                            </td> 
                                        </tr> 

                                        <tr>
                                            <td>  Payment Mode </td>
                                            <td>
                                                {!!  Form::select('payment_type',  [ 'cash'=>'Cash', 'cheque'=>'Cheque', 'EFT'=>'EFT', 'Debit card'=> 'Debit card', 'Credit card'=>'Credit card'], 'cash'  ,['class' => 'form-control payment', 'placeholder' => 'state', 'required'])  !!}
                                            </td>
                                        </tr>
                                        <tr>
                                            <td> Payment Date: </td> 
                                            <td>
                                                {!! Form::text('payment_date', date("Y-m-d") , array('class' => 'form-control datepicker text-right', 'placeholder' => 'Eg: 03/19/2015', 'autocomplete' => 'off')) !!}
                                            </td>
                                        </tr> 
                                        <tr>
                                            <td>Payment Type</td> 
                                            <td>  {!!  Form::select('paid_place',  [ 'Paid To CTC'=>'Paid To CTC ', 'Paid Direct'=>'Paid Direct'], 'Paid To CTC'  ,['class' => 'form-control state', 'placeholder' => 'state', 'required'])  !!}</td>
                                        </tr> 
                                    </table>



                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer"> 
                        <input type="hidden" name="dueSaveType" value="duePayment" > 
                        <input type="hidden" id="due-id" name="due_id"  >
                        <div class="pull-right"> {!! Form::submit('Pay', array('class' => 'btn pay-due-btn btn-success')) !!} &nbsp;&nbsp; 
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                        {!!Form::close()!!}
                    </div>
                </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div>


        <div class="modal fade payment-invoice-pop-model" role="dialog" aria-labelledby="gridSystemModalLabel" aria-hidden="true">
            <div class="modal-dialog ">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title" id="gridSystemModalLabel">Payment</h4>
                    </div>
                    <div class="modal-body">
                        <div class="container-fluid">

                            <div class="row">
                                <div class="col-md-12"> 

                                    {!! Form::open(array('route' => array('client.debtor.invoice.due.store',  $invoice->client_id, $invoice->id), 'autocomplete' => 'off')) !!}
                                    <table class="table table-bordered detail-table">
                                        <tr class="detail-header">


                                        </tr>
                                        <tr>
                                            <td >Invoice code :</td>
                                            <td > 
                                                <div class="pull-right" >{!! $invoice->invoice_code !!}</div> 


                                            </td>
                                        </tr> 

                                        <tr>
                                            <td > Original due amount : </td>
                                            <td  ><div class="pull-right original-amount " >{!! $invoice->original_debt  !!}</div></td>
                                        </tr> 
                                        <tr>
                                            <td > Current due amount  : </td>
                                            <td  ><div class="pull-right current-amount" >{!! $invoice->current_balance !!}</div></td>
                                        </tr> 

                                        <tr>
                                            <td> Due payment amount  : </td>
                                            <td > 
                                                <input class="form-control text-right" value=" {!! $invoice->current_balance !!} " id="amount" name="amount">
                                            </td> 
                                        </tr> 

                                        <tr>
                                            <td>  Payment Mode </td>
                                            <td>
                                                {!!  Form::select('payment_type',  [ 'cash'=>'Cash', 'cheque'=>'Cheque', 'EFT'=>'EFT', 'Debit card'=> 'Debit card', 'Credit card'=>'Credit card'], 'cash'  ,['class' => 'form-control payment', 'placeholder' => 'state', 'required'])  !!}
                                            </td>
                                        </tr>
                                        <tr>
                                            <td> Payment Date: </td> 
                                            <td>
                                                {!! Form::text('payment_date', date("Y-m-d") , array('class' => 'form-control datepicker text-right', 'placeholder' => 'Eg: 03/19/2015', 'autocomplete' => 'off')) !!}
                                            </td>
                                        </tr> 
                                        <tr>
                                            <td>Payment Type</td> 
                                            <td>  {!!  Form::select('paid_place',  [ 'Paid To CTC'=>'Paid To CTC ', 'Paid Direct'=>'Paid Direct'], 'Paid To CTC'  ,['class' => 'form-control state', 'placeholder' => 'state', 'required'])  !!}</td>
                                        </tr> 
                                    </table>



                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer"> 
                        <input type="hidden" name="dueSaveType" value="invoicePayment" > 

                        <div class="pull-right"> {!! Form::submit('Pay', array('class' => 'btn pay-due-btn btn-success')) !!} &nbsp;&nbsp; 
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div> 
                        {!!Form::close()!!}
                    </div>
                </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div>
        <div class="modal fade payment-due-detail-pop-model" role="dialog" aria-labelledby="gridSystemModalLabel" aria-hidden="true">
            <div class="modal-dialog ">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title" id="gridSystemModalLabel">Payment</h4>
                    </div>
                    <div class="modal-body">
                        <div class="container-fluid">

                            <div class="row">
                                <div class="col-md-12 " id='detail-due-display'>



                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer"> 
                        <input type="hidden" name="dueSaveType" value="invoicePayment" > 

                        <div class="pull-right">  
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>

                        </div>
                    </div><!-- /.modal-content -->
                </div><!-- /.modal-dialog -->
            </div>
            @stop
            @section('include-js')
            @parent

            @stop 
          
                @section('document-ready-js')
                        @parent


                        $('#add-due-btn').click(function ()
                {

                    var tt = 1;
                    var dueNumber = $('#no-of-due').val();
                    var currentBalance = (parseFloat("{!! $invoice->current_balance !!}")).toFixed(2);

                    var dueAmount = (currentBalance / dueNumber).toFixed(2);

                    $(".add-dues-class").empty();
                    var conditionHtml = '';
                    for (i = 0; i < dueNumber; i++) {
                        conditionHtml = conditionHtml + '<div class="row condition-top-calss">'
                                + '<div class="col-md-2"><label class="control-label  " >Due date ' + tt + '</label></div>'
                                + '<div class="col-md-3" ><input type="text"  class="form-control date-picket-due"   name="due_date_' + tt + '"> </div>'
                                + '<div class="col-md-2"><label class="control-label" >Amount ' + tt + '</label></div>'
                                + '<div class="col-md-3" ><input type="text" class="form-control text-right" value="' + dueAmount + '"  name="amount_' + tt + '"></div>'

                                + '</div>';
                        tt = tt + 1;
                    }
                    conditionHtml = conditionHtml + '<div class="row condition-top-calss">'
                            + '<div class="col-md-2"></div>'
                            + '<div class="col-md-3" > </div>'
                            + '<div class="col-md-2"><label class="control-label" >Current balance </label></div>'
                            + '<div class="col-md-3 text-right" > ' + currentBalance + '</div>'

                            + '</div>';
                    $(".add-dues-class").append(conditionHtml);

                    $('.date-picket-due').datepicker({
                        format: 'yyyy-mm-dd',
                        scrollInput: false,
                    }).on('changeDate', function (ev) {
                        $('.datepicker-dropdown').hide();
                    }).data('datepicker');

                    $('.submit-button-dive').show();


                });

                $('.submit-button-dive').hide();

                $('.payment-due-pop').click(function ()
                {

                    $('.payment-due-pop-model').modal('show');

                    $('.original-amount').text($(this).attr('data-original-amount'));
                    $('.current-amount').text($(this).attr('data-current-amount'));
                    $('#amount').val($(this).attr('data-current-amount'));
                    $('#due-id').val($(this).attr('data-due-id'))





                });

                $('#invoice-pay-pop').click(function ()
                {

                    $('.payment-invoice-pop-model').modal('show');

                });

                $('#due-create-cencel').click(function ()
                {

                    $(".add-dues-class").empty();

                });


                $('.payment-due-detail-pop').click(function ()
                {

                    $("#detail-due-display").empty();

                    $('.payment-due-detail-pop-model').modal('show');
                    var id = $(this).attr('data-due-id');
                    console.log($("#due-payment-" + id).clone());
                    $("#due-payment-" + id).clone().appendTo("#detail-due-display");

                });


                @stop

           