@extends('layouts.master')
@section('title')
@parent
Debitor  invoice edit
@stop

@section('content')
<ol class="breadcrumb">
    <li><a href="{!! URL::route('client.index') !!}">Client</a></li>  
    <li><a href="{!! URL::route('client.detail', [$client->id]) !!}">{!! $client->name !!}</a></li> 
    <li><a href="{!! URL::route('client.debtor.invoice', [$client->id]) !!}">Debtor invoice</a></li>
    <li>Edit invoice</li> 
    <li>{!! $invoice->invoice_code !!}</li>
</ol>
<div class="nav-tabs-custom">
    @include('clients/nav')
    <div class="tab-content">

        <!-- /.tab-pane -->

        <div class="tab-pane active" >  

            <div class="panel panel-default">
                <div class="panel-heading">
                    <div class="row"> 
                        <div class="col-md-12">
                            <div class="panel-heading pull-left">
                                <h3 class="panel-title"> Invoice general  </h3>
                            </div>

                            <div class="pull-right">

                            </div> 
                        </div>
                    </div>
                </div>
                <div class="panel-body">


                    <div class="row"> 
                        <div class="col-md-6">

                            {!! Form::model($invoice, ['method' => 'PATCH', 'route' => ['client.debtor.invoice.update',$client->id,$invoice->id ?? null]]) !!}
                            <!--                                    <div class="form-group {!! ($errors->has('debtor_id')) ? 'has-error' : '' !!}">
                                                                    {!! Form::label('debtor_id', 'Debtor', ['class' => 'control-label']) !!}
                                                                    {!!  Form::select('debtor_id',  $debtors, $invoice->client_id, ['class' => 'form-control', 'placeholder' => 'state', 'required'])  !!}
                                                                    <span class="help-block">{!! ($errors->has('debtor_id') ? $errors->first('debtor_id') : '') !!}</span>
                                                                </div>
                            -->
                             <div class="form-group {!! ($errors->has('debtor_invoice_code')) ? 'has-error' : '' !!}">
                                {!! Form::label('debtor_invoice_code', 'Invoice Code') !!}
                                {!! Form::text('debtor_invoice_code', null, array('class' => 'form-control', 'placeholder' => 'Inv20000', 'autocomplete' => 'off')) !!}
                                {!! ($errors->has('debtor_invoice_code') ? $errors->first('debtor_invoice_code') : '') !!}
                            </div>
                            <div class="form-group {!! ($errors->has('invoice_date')) ? 'has-error' : '' !!}">
                                {!! Form::label('invoice_date', 'Invoice date') !!}
                                {!! Form::text('invoice_date', null, array('class' => 'form-control datepicker', 'placeholder' => 'Eg: 03/19/2015', 'autocomplete' => 'off')) !!}
                                {!! ($errors->has('invoice_date') ? $errors->first('invoice_date') : '') !!}
                            </div>

                            <div class="form-group {!! ($errors->has('invoice_state')) ? 'has-error' : '' !!}">
                                {!! Form::label('invoice_state', 'Invoice Status', ['class' => 'control-label']) !!}
                                {!!  Form::select('invoice_state',  [ 'create'=>'Create', 'processing'=>'Processing', 'complete'=>'Complete', 'legal action'=>'Legal action', 'cancel'=>'Cancel'], null  ,['class' => 'form-control', 'placeholder' => 'state', 'required'])  !!}
                                <span class="help-block">{!! ($errors->has('invoice_state') ? $errors->first('invoice_state') : '') !!}</span>
                            </div>

                            <div class="form-group {!! ($errors->has('invoice_status_code_id')) ? 'has-error' : '' !!}">
                                {!! Form::label('invoice_status_code_id', 'Invoice Status Code', ['class' => 'control-label']) !!}
                              <input type="hidden"  class="invoice-state-select" id="invoice-state-select-id" name="invoice_status_code_id">
                                <span class="help-block">{!! ($errors->has('invoice_status_code_id') ? $errors->first('invoice_status_code_id') : '') !!}</span>
                            </div>
                            <div class="form-group {!! ($errors->has('reference1')) ? 'has-error' : '' !!}">
                                {!! Form::label('reference1', 'Reference1') !!}
                                {!! Form::text('reference1', null, array('class' => 'form-control', 'placeholder' => '', 'autocomplete' => 'off')) !!}
                                {!! ($errors->has('reference1') ? $errors->first('reference1') : '') !!}
                            </div>

                            <div class="form-group {!! ($errors->has('reference3')) ? 'has-error' : '' !!}">
                                {!! Form::label('reference3', 'Reference3') !!}
                                {!! Form::text('reference3', null, array('class' => 'form-control', 'placeholder' => '', 'autocomplete' => 'off')) !!}
                                {!! ($errors->has('reference3') ? $errors->first('reference3') : '') !!}
                            </div>

                            <div class="form-group {!! ($errors->has('reference5')) ? 'has-error' : '' !!}">
                                {!! Form::label('reference5', 'Reference5') !!}
                                {!! Form::text('reference5', null, array('class' => 'form-control', 'placeholder' => '', 'autocomplete' => 'off')) !!}
                                {!! ($errors->has('reference5') ? $errors->first('reference5') : '') !!}
                            </div>

                        </div>
                        <div class="col-md-6">
                            <div class="form-group {!! ($errors->has('account_state')) ? 'has-error' : '' !!}">
                                {!! Form::label('account_state', 'Account State', ['class' => 'control-label']) !!}
                                {!!  Form::select('account_state',  [ 'p'=>'p', 't'=>'t'], null  ,['class' => 'form-control', 'placeholder' => 'state', 'required'])  !!}
                                <span class="help-block">{!! ($errors->has('account_state') ? $errors->first('account_state') : '') !!}</span>
                            </div>

                            <div class="form-group {!! ($errors->has('solicitor_id')) ? 'has-error' : '' !!}">
                                {!! Form::label('solicitor_id', 'Solicitor', ['class' => 'control-label']) !!}
                                <div class="row">
                                    <div class="col-md-12">
                                        <input type="hidden"   class="solicitor-select" id="solicitor-select-id" name="solicitor_id">
                                    </div>

                                </div>


                                <span class="help-block">{!! ($errors->has('debtor_id') ? $errors->first('debtor_id') : '') !!}</span>
                            </div>

                            <div class="form-group {!! ($errors->has('user_id')) ? 'has-error' : '' !!}">
                                {!! Form::label('user_id', 'Follow up', ['class' => 'control-label']) !!}
                                {!!  Form::select('user_id',  $users, null  ,['class' => 'form-control', 'placeholder' => 'state', 'required'])  !!}
                                <span class="help-block">{!! ($errors->has('user_id') ? $errors->first('user_id') : '') !!}</span>
                            </div>
                             <div class="form-group {!! ($errors->has('debt_type_id')) ? 'has-error' : '' !!}">
                                {!! Form::label('debt_type_id', 'Debt Type', ['class' => 'control-label']) !!}
                              <input type="hidden"  class="debt-type-select" id="debt-type-select-id" name="debt_type_id">
                                <span class="help-block">{!! ($errors->has('debt_type_id') ? $errors->first('debt_type_id') : '') !!}</span>
                            </div>
                            <div class="form-group {!! ($errors->has('reference2')) ? 'has-error' : '' !!}">
                                {!! Form::label('reference2', 'Reference2') !!}
                                {!! Form::text('reference2', null, array('class' => 'form-control', 'placeholder' => '', 'autocomplete' => 'off')) !!}
                                {!! ($errors->has('reference2') ? $errors->first('reference2') : '') !!}
                            </div>
                             <div class="form-group {!! ($errors->has('reference4')) ? 'has-error' : '' !!}">
                                {!! Form::label('reference4', 'Reference4') !!}
                                {!! Form::text('reference4', null, array('class' => 'form-control', 'placeholder' => '', 'autocomplete' => 'off')) !!}
                                {!! ($errors->has('reference4') ? $errors->first('reference4') : '') !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="panel panel-default">
                <div class="panel-heading">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="panel-heading pull-left">
                                <h3 class="panel-title"> Accounts details  </h3>
                            </div>

                            <div class="pull-right">

                            </div>
                        </div>
                    </div>
                </div>
                <div class="panel-body">

                    <div class="row">
                        <div class="col-md-6">

                            <div class="form-group {!! ($errors->has('solicitor_cost_date')) ? 'has-error' : '' !!}">
                                {!! Form::label('solicitor_cost_date', 'Solicitor costs to date') !!}
                                {!! Form::text('solicitor_cost_date', null, array('class' => 'form-control', 'placeholder' => 'Eg: 25.00', 'autocomplete' => 'off')) !!}
                                {!! ($errors->has('solicitor_cost_date') ? $errors->first('solicitor_cost_date') : '') !!}
                            </div>
                            <div class="form-group {!! ($errors->has('recoverable_cost_date')) ? 'has-error' : '' !!}">
                                {!! Form::label('recoverable_cost_date', 'Recoverable costs to date') !!}
                                {!! Form::text('recoverable_cost_date', null, array('class' => 'form-control', 'placeholder' => 'Eg: 25.00', 'autocomplete' => 'off')) !!}
                                {!! ($errors->has('recoverable_cost_date') ? $errors->first('recoverable_cost_date') : '') !!}
                            </div>


                            <div class="form-group {!! ($errors->has('non_recoverable_cost_date')) ? 'has-error' : '' !!}">
                                {!! Form::label('non_recoverable_cost_date', 'Non recoverable costs to date') !!}
                                {!! Form::text('non_recoverable_cost_date', null, array('class' => 'form-control', 'placeholder' => 'Eg: 25.00', 'autocomplete' => 'off')) !!}
                                {!! ($errors->has('non_recoverable_cost_date') ? $errors->first('non_recoverable_cost_date') : '') !!}
                            </div>
                            <div class="form-group {!! ($errors->has('debt_recovered_date')) ? 'has-error' : '' !!}">
                                {!! Form::label('debt_recovered_date', 'Debt recovered to date') !!}
                                {!! Form::text('debt_recovered_date', null, array('class' => 'form-control', 'placeholder' => 'Eg: 25.00', 'autocomplete' => 'off')) !!}
                                {!! ($errors->has('debt_recovered_date') ? $errors->first('debt_recovered_date') : '') !!}
                            </div>
                            <div class="form-group {!! ($errors->has('costs_recovered_date')) ? 'has-error' : '' !!}">
                                {!! Form::label('costs_recovered_date', 'Costs recovered to date') !!}
                                {!! Form::text('costs_recovered_date', null, array('class' => 'form-control', 'placeholder' => 'Eg: 25.00', 'autocomplete' => 'off')) !!}
                                {!! ($errors->has('costs_recovered_date') ? $errors->first('costs_recovered_date') : '') !!}
                            </div>

                        </div>
                        <div class="col-md-6">
                            <div class="form-group {!! ($errors->has('original_debt')) ? 'has-error' : '' !!}">
                                {!! Form::label('original_debt', 'Original Debt') !!}
                                {!! Form::text('original_debt', null, array('class' => 'form-control text-right', 'placeholder' => 'Eg: 259.00', 'autocomplete' => 'off')) !!}
                                {!! ($errors->has('original_debt') ? $errors->first('invoice_date') : '') !!}
                            </div>

                            <div class="form-group {!! ($errors->has('current_balance')) ? 'has-error' : '' !!}">
                                {!! Form::label('current_balance', 'Current balance') !!}
                                {!! Form::text('current_balance', null, array('class' => 'form-control text-right', 'placeholder' => 'Eg: 25.00', 'autocomplete' => 'off')) !!}
                                {!! ($errors->has('current_balance') ? $errors->first('current_balance') : '') !!}
                            </div>
                            <div class="form-group {!! ($errors->has('last_payment')) ? 'has-error' : '' !!}">
                                {!! Form::label('last_payment', 'Last payment') !!}
                                {!! Form::text('last_payment', null, array('class' => 'form-control text-right', 'placeholder' => 'Eg: 201.00', 'autocomplete' => 'off')) !!}
                                {!! ($errors->has('last_payment') ? $errors->first('last_payment') : '') !!}
                            </div>
                            <div class="form-group {!! ($errors->has('last_paid')) ? 'has-error' : '' !!}">
                                {!! Form::label('last_paid', 'Last payment date') !!}
                                {!! Form::text('last_paid', null, array('class' => 'form-control datepicker', 'placeholder' => 'Eg: 03/19/2015', 'autocomplete' => 'off')) !!}
                                {!! ($errors->has('last_paid') ? $errors->first('last_paid') : '') !!}
                            </div>

                            <div class="form-group {!! ($errors->has('charge_type')) ? 'has-error' : '' !!}">
                                <div class="checkbox">
                                    <br>
                                    <label>
                                        <input type="checkbox" value="1" name='charge_type' >  No charge
                                    </label>
                                </div>
                            </div>




                        </div>
                    </div>
                </div>
            </div>
            @if($invoice->invoice_state =='legal action') 

            <div class="panel panel-default">
                <div class="panel-heading">
                    <div class="row"> 
                        <div class="col-md-12">
                            <div class="panel-heading pull-left">
                                <h3 class="panel-title"> Legal arrangement </h3>
                            </div>

                            <div class="pull-right">

                            </div> 
                        </div>
                    </div>
                </div>
                <div class="panel-body">

                    <div class="row"> 
                        <div class="col-md-12">

                            <div class="form-group {!! ($errors->has('plaint_filed')) ? 'has-error' : '' !!}">
                                {!! Form::label('plaint_filed', 'Plaint filed') !!}


                                {!! Form::textarea('plaint_filed', null, array('class' => 'form-control', 'placeholder' => '')) !!}
                                {!! ($errors->has('plaint_filed') ? $errors->first('plaint_filed') : '') !!}
                            </div>
                        </div>
                        <div class="col-md-6">

                            <div class="form-group {!! ($errors->has('plaint_served')) ? 'has-error' : '' !!}">
                                {!! Form::label('plaint_served', 'Plaint served') !!}
                                {!! Form::text('plaint_served', null, array('class' => 'form-control', 'placeholder' => 'Eg: Emery')) !!}
                                {!! ($errors->has('plaint_served') ? $errors->first('plaint_served') : '') !!}
                            </div> 
                            <div class="form-group {!! ($errors->has('court')) ? 'has-error' : '' !!}">
                                {!! Form::label('court', 'Court') !!}
                                {!! Form::text('court', null, array('class' => 'form-control', 'placeholder' => 'Eg: aus')) !!}
                                {!! ($errors->has('court') ? $errors->first('court') : '') !!}
                            </div>
                        </div> 
                        <div class="col-md-6">


                            <div class="form-group {!! ($errors->has('plaint_number,')) ? 'has-error' : '' !!}">
                                {!! Form::label('plaint_number', 'Plaint number,') !!}
                                {!! Form::text('plaint_number', null, array('class' => 'form-control', 'placeholder' => 'Eg: aus')) !!}
                                {!! ($errors->has('plaint_number') ? $errors->first('plaint_number') : '') !!}
                            </div>
                            <div class="form-group {!! ($errors->has('judgement_date')) ? 'has-error' : '' !!}">
                                {!! Form::label('judgement_date ', 'Judgement date ') !!}
                                {!! Form::text('judgement_date', null, array('class' => 'form-control datepicker', 'placeholder' => 'Eg: aus')) !!}
                                {!! ($errors->has('judgement_date') ? $errors->first('judgement_date') : '') !!}
                            </div> 
                        </div>
                        <div class="col-md-12">
                            <div class="form-group {!! ($errors->has('arrangement ')) ? 'has-error' : '' !!}">
                                {!! Form::label('arrangement ', 'Arrangement') !!}
                                {!! Form::textarea('arrangement', null, array('class' => 'form-control', 'placeholder' => '')) !!}
                                {!! ($errors->has('arrangement ') ? $errors->first('arrangement ') : '') !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div> 
            @endif
            <div class="panel-footer"> 

                {!! Form::submit('Update', array('class' => 'btn btn-info')) !!} &nbsp;&nbsp;
                <a href="{!!URL::route('client.debtor.invoice', [$client->id])!!}" class="btn btn-default">Cancel</a>
                {!!Form::close()!!} 

            </div> 
        </div>

    </div>
</div>





@stop
@section('include-js')
@parent

@stop

@section('document-ready-js')
@parent



var getUserUrl = '{!! route("user.index") !!}';
$('.user-select').select2({
ajax: {
url: getUserUrl,
dataType: 'json',
quietMillis: 100,
results: function (data) {
var results = [];
$.each(data, function (index, item) {
results.push({
id: item.id,
text: item.first_name + ' ' + item.last_name,
});
});
return {
results: results
};
},
cache: true
},
minimumInputLength: 1,
width: '100%',
});



var getSolicitorrUrl = '{!! route("solicitor.index") !!}';
$('.solicitor-select').select2({
width: '100%',
minimumInputLength: 0,
ajax: {
url: getSolicitorrUrl,
dataType: 'json',
quietMillis: 100,
data: function (term) {
return {
term: term
};
},
results: function (data) {


var results = [];

$.each(data, function (index, item) {

results.push({
id: item.id,
text: item.name,
});
});

return {
results: results
};
}
}
});


if ("{!! $invoice->solicitor_id !!}" != 'no')
{
if ({!! json_encode($invoice->solicitor) !!} !== null) {
$('body .solicitor-select .select2-chosen').text("{!! $invoice->solicitor->name ?? ''!!}");
$('body  #solicitor-select-id').val("{!! $invoice->solicitor_id !!}");
}
}


var getInvoiceStateUrl = '{!! route("invoiceStatusCode.index") !!}';
$('.invoice-state-select').select2({
width: '100%',

ajax: {
url: getInvoiceStateUrl,
dataType: 'json',
quietMillis: 100,
data: function (term) {
return {
term: term
};
},
results: function (data) {


var results = [];

$.each(data, function (index, item) {

results.push({
id: item.id,
text: item.code+ ' ' + item.description,
});
});

return {
results: results
};
}
},
minimumInputLength: 0,
}); 


if ("{!! $invoice->invoice_status_code_id !!}" != 'no')
{
$('body .invoice-state-select .select2-chosen').text("{!! $invoice->invoiceStatusCode->code ?? '' !!}");
$('body  #invoice-state-select-id').val("{!! $invoice->invoice_status_code_id !!}"); 
}


var getDebtTypeUrl = '{!! route("debtType.index") !!}';
$('.debt-type-select').select2({
width: '100%',

ajax: {
url: getDebtTypeUrl,
dataType: 'json',
quietMillis: 100,
data: function (term) {
return {
term: term
};
},
results: function (data) {


var results = [];

$.each(data, function (index, item) {

results.push({
id: item.id,
text: item.code+ ' ' + item.description,
});
});

return {
results: results || []
};
}
},
minimumInputLength: 0,
});

if ("{!! $invoice->debt_type_id !!}" != 'no')
{
$('body .debt-type-select .select2-chosen').text("{!! $invoice->debtType->code ?? '' !!}");
$('body  #debt-type-select-id').val("{!! $invoice->debt_type_id !!}"); 
}

@stop


