@extends('layouts.master')
@section('title')
@parent
Follow 
@stop

@section('content')
<ol class="breadcrumb">
    <li><a href="{!! URL::route('client.index') !!}">Client</a></li> 
    <li><a href="{!! URL::route('client.detail', [$client->id]) !!}">{!! $client->name !!}</a></li> 
    <li><a href="{!! URL::route('client.debtor.invoice', [$client->id]) !!}">Debtor invoice</a></li>
    <li><a href="{!! URL::route('client.debtor.invoice.show', [$client->id, $invoice->id]) !!}">{!! $invoice->invoice_code !!}</a></li>


</ol>

<div class="nav-tabs-custom">
    @include('clients/nav')
    <div class="tab-content">

        <!-- /.tab-pane -->

        <div class="tab-pane active" >
            <div class="box">
                <div class="box-header">

                </div><!-- /.box-header -->
                <div class="box-body"> 

                    <div class="box box-info">
                        <div class="box-header">

                        </div> 
                        <div class="box-body"> 

                        </div>
                    </div>

                    {!! Form::model($follow, ['method' => 'PATCH', 'route' => ['client.invoice.follow.update', $client->id, $invoice->id, $follow->id]]) !!}

                    <div class="row"> 

                        <div class="col-md-12"> 



                            <div class="row detail-row ">
                                <div class="col-md-3  label-detail">Action letter :</div>
                                <div class="col-md-9 value-detail"> 
                                    <div class="form-group {!! ($errors->has('debtor_id')) ? 'has-error' : '' !!}">
                                        {!! Form::label('collection_action_code_id', 'Action Code', ['class' => 'control-label']) !!}
                                        <div class="row">
                                            <div class="col-md-12">
                                                <input type="hidden"  class="collection-action-select" id="collection-action-select-id" name="collection_action_code_id"> 
                                            </div> 

                                        </div>


                                        <span class="help-block">{!! ($errors->has('collection_action_code_id') ? $errors->first('collection_action_code_id') : '') !!}</span>
                                    </div> 
                                </div> 
                            </div> 


                            <div class="row detail-row">
                                <div class="col-md-3  label-detail">Latest comment :</div>
                                <div class="col-md-9 value-detail"> 
                                    <div class="form-group {!! ($errors->has('latest_comment')) ? 'has-error' : '' !!}">

                                        {!! Form::text('latest_comment', null, array('class' => 'form-control', 'placeholder' => 'Eg: good', 'autocomplete' => 'off')) !!}

                                        {!! ($errors->has('latest_comment') ? $errors->first('latest_comment') : '') !!}


                                    </div> 
                                </div>
                            </div> 

                            <div class="row detail-row">
                                <div class="col-md-3  label-detail">Previous comment :</div>
                                <div class="col-md-9 value-detail"> 
                                    <div class="form-group {!! ($errors->has('previous_comment')) ? 'has-error' : '' !!}">

                                        {!! Form::text('previous_comment', null, array('class' => 'form-control', 'placeholder' => 'Eg: good', 'autocomplete' => 'off')) !!}

                                        {!! ($errors->has('previous_comment') ? $errors->first('previous_comment') : '') !!}


                                    </div> 
                                </div>
                            </div> 
                            <div class="row detail-row">
                                <div class="col-md-3  label-detail">Date :</div>
                                <div class="col-md-9 value-detail"> 
                                    <div class="form-group {!! ($errors->has('date')) ? 'has-error' : '' !!}">

                                        {!! Form::text('date', null, array('class' => 'form-control datepicker', 'placeholder' => 'Eg: 03/19/2015', 'autocomplete' => 'off')) !!}
                                        {!! ($errors->has('date') ? $errors->first('date') : '') !!}
                                    </div>
                                </div>
                            </div>
                            <div class="row detail-row">
                                <div class="col-md-3  label-detail">Next follow date:</div>
                                <div class="col-md-9 value-detail"> 
                                    <div class="form-group {!! ($errors->has('next_follow_date')) ? 'has-error' : '' !!}">

                                        {!! Form::text('next_follow_date', null, array('class' => 'form-control datepicker', 'placeholder' => 'Eg: 03/19/2015', 'autocomplete' => 'off')) !!}
                                        {!! ($errors->has('next_follow_date') ? $errors->first('next_follow_date') : '') !!}
                                    </div>
                                </div>
                            </div>

                        </div>

                    </div>




                </div>
                <div class="box-footer clearfix"> 
                    <div class=" pull-right">
                        {!! Form::submit('Update', array('class' => 'btn btn-info')) !!} &nbsp;&nbsp;
                        <a href="{!!URL::route('client.debtor.invoice.follow', [$client->id, $invoice->id])!!}" class="btn btn-default">Cancel</a>
                        {!!Form::close()!!} 
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@stop
<script>
    @section('document-ready-js')
            @parent
            var getCollectionActionCodeUrl = '{!! route("collectionActionCode.index") !!}';
    $('.collection-action-select').select2({
    width: '100%',
            ajax: {
            url: getCollectionActionCodeUrl,
                    dataType: 'json',
                    quietMillis: 100,
                    data: function (term) {
                        return {
                            term: term
                        };
                    },
                    results: function (data) {

                        console.log(data);
                        var results = [];

                        $.each(data, function (index, item) {

                            results.push({
                                id: item.id,
                                text: item.code + ' ' + item.description,
                            });
                        });

                        return {
                            results: results
                        };
                    }
            },
            minimumInputLength: 0,
            }); 
            
            if ('{!! $follow->collectionActionCode_id !!}' != 'no' )
{
$('body .collection-action-select .select2-chosen').text("{!! $follow->collectionActionCode->code or '' !!}");
$('body  #collection-action-select-id').val("{!! $follow->collectionActionCode->id !!}");
}
            @stop
</script>
