@extends('layouts.master')
@section('title')
@parent
Follow
@stop

@section('content')
<ol class="breadcrumb">
    <li><a href="{!! URL::route('client.index') !!}">Client</a></li> 
    <li><a href="{!! URL::route('client.detail', [$client->id]) !!}">{!! $client->name !!}</a></li> 
    <li><a href="{!! URL::route('client.debtor.invoice', [$client->id]) !!}">Debtor invoice</a></li>
    <li><a href="{!! URL::route('client.debtor.invoice.show', [$client->id, $invoice->id]) !!}">{!! $invoice->invoice_code !!}</a></li>


</ol>

<div class="nav-tabs-custom">
 @include('clients/nav')
    <div class="tab-content">

        <!-- /.tab-pane -->

        <div class="tab-pane active" > 
            
           
            <div class="box">
                <div class="col-md-12">
                <div class="panel-heading pull-left">
                    <h3 class="panel-title">Client</h3>
                </div>

                <div class="pull-right">
                   
                    <a href="{!! route('client.debtor.invoice.follow.create', [$client->id, $invoice->id]) !!}" class="btn btn-primary"><span><i class="fa    fa-plus" rel="tooltip" ></i> Add follow </span> </a>
                   
                </div> 
            </div>
                <div class="box-body"> 
                    <table class="table table-bordered">
                        <tr>
                            <th style="width: 10px">#</th> 
                            <th style="width: 100px" >Date </th>
                            <th>Action send</th>
                            <th>Latest comment </th>
                             <th>Previous comment </th>
                            <th>Next follow date</th> 
                            
                            <th>Action</th>


                        </tr> 

                        @foreach($follows as $follow)
                        @if($follow->status=='todo')
                        <tr style='background: #ffb7b7;'> 
                         @else 
                           <tr> 
                          @endif
                         
                            <td></td> 
                              <td>{!! $follow->date !!}</td> 
{{--                                <td> @if(count($follow->collectionActionCode))--}}
                    <td>@if(is_countable($follow->collectionActionCode) && count($follow->collectionActionCode) > 0)

    {!! $follow->collectionActionCode->code !!}
                                    @endif
                                </td>
                              <td>{!! $follow->latest_comment !!}</td> 
                               <td>{!! $follow->previous_comment !!}</td> 
                            <td>{!! $follow->next_follow_date !!}</td> 
                             
                            <td> 
                                
                                    <a href="{!! route('client.debtor.invoice.follow.edit', [$client->id, $invoice->id, $follow->id ]) !!}"><i class="fa  fa-edit" rel="tooltip" title="Edit"></i>  </a>&nbsp;&nbsp;
                                 <a href="{!! route('client.invoice.follow.delete', [$client->id, $invoice->id, $follow->id]) !!}"><i class="fa  fa-archive" rel="tooltip" title="Delete"></i>  </a>
                            </td>

                        </tr> 
                       
                        @endforeach
                    </table> 
                    {!! $follows->render() !!}
                </div>
            </div>
        </div>
    </div>
</div>


@stop
@section('include-js')
@parent

@stop 

    @section('document-ready-js')
            @parent


            @stop

