@extends('layouts.master')
@section('title')
@parent
Payments
@stop

@section('content')
<ol class="breadcrumb">
    <li><a href="{!! URL::route('client.index') !!}">Client</a></li> 
    <li><a href="{!! URL::route('client.detail', [$client->id]) !!}">{!! $client->name !!}</a></li> 
    <li><a href="{!! URL::route('client.debtor.invoice', [$client->id]) !!}">Debtor invoice</a></li>
    <li><a href="{!! URL::route('client.debtor.invoice.show', [$client->id, $invoice->id]) !!}">{!! $invoice->invoice_code !!}</a></li>


</ol>

<div class="nav-tabs-custom">
 @include('clients/nav')
    <div class="tab-content">

        <!-- /.tab-pane -->

        <div class="tab-pane active" > 
            
            <div class="panel panel-default">
                        <div class="panel-heading">
                            <div class="row"> 
                                <div class="col-md-12">
                                    <div class="panel-heading pull-left">
                                        <h3 class="panel-title"> Payments</h3>
                                    </div>

                                    <div class=" pull-right"> 
                                      </div>
                                </div>
                            </div>
                        </div><!-- /.box-header -->
                        <div class="panel-body"> 
            
            
                    {!! Form::open(array('route' => array('client.debtor.invoice.payment',  $invoice->client_id, $invoice->id), 'autocomplete' => 'off')) !!}

                    <table class="table table-bordered detail-table">
                        <tr class="detail-header">


                        </tr>
                        <tr>
                            <td class="detail-content-label">Invoice code :</td>
                            <td class="detail-content-value"> 
                                <div class="pull-right" id="client-name">{!! $invoice->invoice_code !!}</div> 


                            </td>
                        </tr> 
                        <tr>
                            <td class="detail-content-label"> Client Name : </td>
                            <td class="detail-content-value"><div class="pull-right" id="client-name"> {!! ($invoice->client)? $invoice->client->name : '' !!} </div></td>
                        </tr>  
                        <tr>
                            <td class="detail-content-label"> Debtor name  : </td>
                            <td class="detail-content-value"><div class="pull-right" id="debtor-name">{!! ($invoice->debtor)? $invoice->debtor->name : '' !!}</div></td>
                        </tr> 
                        <tr>
                            <td class="detail-content-label"> Original debt : </td>
                            <td class="detail-content-value" ><div class="pull-right" id="original-debt">{!! $invoice->original_debt  !!}</div></td>
                        </tr> 
                        <tr>
                            <td class="detail-content-label"> Current_balance  : </td>
                            <td class="detail-content-value" ><div class="pull-right" id="current-balance">{!! $invoice->current_balance !!}</div></td>
                        </tr> 
                        <tr>
                            <td class="detail-content-label"> Pay amount  : </td>
                            <td class="detail-content-value"> 
                                <div class="form-group {!! ($errors->has('amount')) ? 'has-error' : '' !!}">

                                    {!! Form::text('amount', null, array('class' => 'form-control text-right amount-class', 'placeholder' => '20.00', 'autocomplete' => 'off')) !!}
                                    {!! ($errors->has('amount') ? $errors->first('amount') : '') !!}
                                </div>
                            </td> 
                        </tr> 
                        <tr>
                            <td class="detail-content-label"> Payment state : </td>
                            <td class="detail-content-value">  
                                <div class="form-group {!! ($errors->has('payment_state')) ? 'has-error' : '' !!}">

                                    {!!  Form::select('payment_state',  [ 'due'=>'Due', 'pay'=>'Pay'], 'due'  ,['class' => 'form-control state', 'placeholder' => 'state', 'required'])  !!}
                                    <span class="help-block">{!! ($errors->has('payment_state') ? $errors->first('payment_state') : '') !!}</span>
                                </div>  

                            </td>
                        </tr>  
                         <tr>
                            <td class="detail-content-label"> Payment place : </td>
                            <td class="detail-content-value">  
                                <div class="form-group {!! ($errors->has('paid_place')) ? 'has-error' : '' !!}">

                                    {!!  Form::select('paid_place',  [ 'Paid To CTC'=>'Paid To CTC ', 'Paid Direct'=>'Paid Direct'], 'Paid To CTC'  ,['class' => 'form-control state', 'placeholder' => 'state', 'required'])  !!}
                                    <span class="help-block">{!! ($errors->has('paid_place') ? $errors->first('paid_place') : '') !!}</span>
                                </div>  

                            </td>
                        </tr>
                        <tr class=" ">
                            <td class="detail-content-label"> Payment date  : </td>
                            <td class="detail-content-value"> 
                                <div class="form-group {!! ($errors->has('payment_date')) ? 'has-error' : '' !!}">

                                    {!! Form::text('payment_date', null, array('class' => 'form-control datepicker', 'placeholder' => 'Eg: 03/19/2015', 'autocomplete' => 'off')) !!}
                                    {!! ($errors->has('payment_date') ? $errors->first('payment_date') : '') !!}
                                </div>

                            </td>
                        </tr> 
                        <tr  class="pay-div" style=" display: none;">
                            <td class="detail-content-label"> Payment type  : </td>
                            <td class="detail-content-value">  
                                <div class="form-group {!! ($errors->has('payment_type')) ? 'has-error' : '' !!}">

                                    {!!  Form::select('payment_type',  [ 'cash'=>'Cash', 'cheque'=>'Cheque', 'EFT'=>'EFT', 'Debit card'=> 'Debit card', 'Credit card'=>'Credit card'], 'cash'  ,['class' => 'form-control payment', 'placeholder' => 'state', 'required'])  !!}
                                    <span class="help-block">{!! ($errors->has('payment_type') ? $errors->first('payment_type') : '') !!}</span>
                                </div>  

                            </td>
                        </tr> 
                        
                         <tr class="cheque-div" style=" display: none;">
                            <td class="detail-content-label"> Paid date  : </td>
                            <td class="detail-content-value"> 
                                <div class="form-group {!! ($errors->has('paid_date')) ? 'has-error' : '' !!}">

                                    {!! Form::text('paid_date', null, array('class' => 'form-control datepicker', 'placeholder' => 'Eg: 03/19/2015', 'autocomplete' => 'off')) !!}
                                    {!! ($errors->has('paid_date') ? $errors->first('paid_date') : '') !!}
                                </div>

                            </td>
                        </tr>

                        <tr class="cheque-div" style=" display: none;">
                            <td class="detail-content-label"> Bank  : </td>
                            <td class="detail-content-value"> 
                                <div class="form-group {!! ($errors->has('bank')) ? 'has-error' : '' !!}">

                                    {!! Form::text('bank', null, array('class' => 'form-control', 'placeholder' => 'Commacial Bank', 'autocomplete' => 'off')) !!}

                                    {!! ($errors->has('bank') ? $errors->first('last_payment') : '') !!}


                                </div> 
                            </td>
                        </tr>   
                        
                        
                        <tr class="cheque-div" style=" display: none;">
                            <td class="detail-content-label"> Branch  : </td>
                            <td class="detail-content-value"> 
                                <div class="form-group {!! ($errors->has('branch')) ? 'has-error' : '' !!}">

                                    {!! Form::text('branch', null, array('class' => 'form-control', 'placeholder' => 'Eg: Sydney', 'autocomplete' => 'off')) !!}

                                    {!! ($errors->has('branch') ? $errors->first('branch') : '') !!}


                                </div>

                            </td>
                        </tr>
                        <tr class="cheque-div" style=" display: none;">
                            <td class="detail-content-label"> Drawer  : </td>
                            <td class="detail-content-value"> 

                                <div class="form-group {!! ($errors->has('drawer')) ? 'has-error' : '' !!}">

                                    {!! Form::text('drawer', null, array('class' => 'form-control', 'placeholder' => 'Eg: Watchen', 'autocomplete' => 'off')) !!}

                                    {!! ($errors->has('drawer') ? $errors->first('branch') : '') !!}


                                </div>

                            </td>
                        </tr> 
                        <tr class="cheque-div" style=" display: none;">
                            <td class="detail-content-label"> Cheque no : </td>
                            <td class="detail-content-value"> 
                                <div class="form-group {!! ($errors->has('cheque_no')) ? 'has-error' : '' !!}">

                                    {!! Form::text('cheque_no', null, array('class' => 'form-control', 'placeholder' => 'Eg: tyyyu-iolk-2569', 'autocomplete' => 'off')) !!}

                                    {!! ($errors->has('cheque_no') ? $errors->first('cheque_no') : '') !!}


                                </div> 
                            </td>

                        </tr> 


<!--                                 <tr>
   <td class="detail-content-label"> Payment type  : </td>
   <td class="detail-content-value"> 
       
   </td>
</tr>-->


                        <tr>
                            <td colspan="2" class="detail-content-value"> <div class="pull-right"> {!! Form::submit('Due', array('class' => 'btn pay-due-btn btn-success')) !!} &nbsp;&nbsp; 
                                 <a href="{!! URL::route('client.debtor.invoice', [$client->id]) !!}" class="btn btn-default">Back</a>
                                </div></td>
                        </tr> 
                    </table> 



                    {!!Form::close()!!} 
                </div>
            </div>
            <div class="box">
                <div class="box-header">
                    <h3 class="box-title">Payment Details </h3> 
                    <div class="btn-group pull-right">

                    </div>
                </div><!-- /.box-header -->
                <div class="box-body"> 
                    <table class="table table-bordered">
                        <tr>
                            <th style="width: 10px">#</th> 
                            <th>Invoice code </th> 
                            <th> Client name </th> 
                            <th> Debtor name </th>

                            <th>Payment state </th>
                            <th>Amount</th> 
                            <th>Due date</th>
                            <th>Action</th>


                        </tr> 

                        @foreach($payments as $payment)

                        <tr>
                            <td></td> 
                            <td>{!! $payment->debtorInvoice->invoice_code !!}</td> 
                            <td>{!! $payment->client->name !!}</td> 
                            <td>{!! $payment->debtor->name !!}</td>
                            <td>{!!$payment->payment_state !!}</td>
                            <td>{!! $payment->amount !!}</td>  
                            <td>{!! $payment->payment_date !!}</td> 
                            <td> 
                                @if($payment->payment_state =='due')
                                <a href="{!! route('client.invoice.payment.edit', [$client->id, $payment->debtorInvoice->id, $payment->id ]) !!}"><i class="fa  fa-edit" rel="tooltip" title="Edit"></i>  </a>&nbsp;&nbsp;
                            <a href="{!! route('client.invoice.payment.email', [$client->id, $payment->debtorInvoice->id, $payment->id ]) !!}"><i class="fa  fa-envelope-o" rel="tooltip" title="Edit"></i>  </a>&nbsp;&nbsp;
                                @else
                                    <a href="{!! route('client.invoice.payment.edit', [$client->id, $payment->debtorInvoice->id, $payment->id ]) !!}"><i class="fa  fa-edit" rel="tooltip" title="Edit"></i>  </a>&nbsp;&nbsp;
                                @endif
                            </td>

                        </tr>
                        @endforeach
                    </table> 
                    {!! $payments->render() !!}
                </div>
            </div>
        </div>
    </div>
</div>


@stop
@section('include-js')
@parent

@stop 
<script>
    @section('document-ready-js')
            @parent

//            $('.cheque-div').hide(); 
//             $('.pay-div').hide();
    $(".payment").change(function () {
        console.log($(this).val());
        if ($(this).val() == 'cheque')
        {
            $('.cheque-div').show();
        }
        else {
            $('.pay-div').show();
            $('.cheque-div').hide();
        }
    });  
    
     $(".state").change(function () {
        if ($(this).val() == 'due')
        {
             $('.pay-div').hide();
            $('.due-div').show();
            $('.pay-due-btn').val('Due');
        }
        else {
            $(".pay-div").show();
            $('.due-div').hide();
             $('.pay-due-btn').val('Pay');
        }
    });
    
    
var pval= $('#current-balance').text();
    $('.amount-class').change(function () { 
         $('#current-balance').text(pval);
        var amount = $(this).val();
        var currentBalance = $('#current-balance').text();
        console.log(currentBalance-amount);
        if ((currentBalance -amount) < 0)
        {
           
           alert('pay amount must be less than current balance');
           $(this).val('');
           return false;
        }
        var currentBalanceNew = currentBalance - amount;
        $('#current-balance').text(currentBalanceNew);
    });
            @stop

</script>