@extends('layouts.master')

@section('title')

    @parent

    Client detail

@stop



@section('content')

    <div class="row">

        <div class="col-sm-12">

            <h4 class="pull-left page-title"> </h4>

            <ol class="breadcrumb pull-right">

                <li><a href="{!! route('home.index') !!}">Dashboard</a></li>

                <li><a href="{!! URL::route('client.index') !!}">Client</a></li>

                <li class="active" >{!! $client->name !!} </li>

                <li><a href="{!! URL::route('client.debtor.invoice', [$client->id]) !!}">Debtor invoice</a></li>

                <li class="active" >{!! $invoice->invoice_code !!}</li>

            </ol>

        </div>

    </div

    <div class="row">

        @if($invoice->invoice_status_code_id != 18)

            <div class="col-md-9">

                @else

                    <div class="col-md-12">

                        @endif



                        <div class="nav-tabs-custom">

                            <div class="pull-right">



                            </div>

                            @include('clients/nav')

                            <div class="tab-content">

                                <div class="tab-pane active">

                                    <div class="panel panel-default">

                                        <div class="panel-heading">

                                            <div class="row">

                                                <div class="col-md-12">

                                                    <div class="panel-heading pull-left">

                                                        <h3 class="panel-title"> General Details</h3>

                                                    </div>



                                                    <div class=" pull-right">

                                                        @if($invoice->invoice_status_code_id != 18)



                                                        @endif

                                                        <a href="{!!URL::route('client.debtor.invoice.edit', [$client->id,$invoice->id])!!}" class="btn btn-info">Edit</a>



                                                        <a href="{!!URL::route('client.debtor.invoice.payment', [$client->id,$invoice->id])!!}" class="btn btn-primary">Payment</a>

                                                        <a href="{!!URL::route('client.debtor.invoice.follow', [$client->id,$invoice->id])!!}" class="btn btn-danger">Follow Up</a>





                                                    </div>

                                                </div>

                                            </div>

                                        </div><!-- /.box-header -->

                                        <div class="panel-body">

                                            <table class="table table-bordered detail-table">



                                                <tr>

                                                    <td class="detail-content-label">Invoice code :</td>

                                                    <td class="detail-content-value">{!! $invoice->invoice_code !!}</td>

                                                    <td class="detail-content-label"> Client  : </td>

                                                    <td class="detail-content-value">{!! ($invoice->client)? $invoice->client->name : '' !!}</td>

                                                </tr>

                                                <tr>

                                                    <td class="detail-content-label">Debtor :</td>

                                                    <td class="detail-content-value" >{!! ($invoice->debtor)? $invoice->debtor->name : '' !!}</td>

                                                    <td class="detail-content-label"> Invoice date : </td>

                                                    <td class="detail-content-value" >{!! date("d/m/Y", strtotime($invoice->invoice_date))   !!}</td>

                                                </tr>

                                                <tr>

                                                    <td class="detail-content-label">Invoice state:</td>

                                                    <td class="detail-content-value" >

                                                        @if(optional($invoice->invoiceStatusCode)->count())

                                                            {!! $invoice->invoiceStatusCode->description !!}

                                                        @else

                                                            {!! $invoice->status_code !!}

                                                        @endif





                                                    </td>

                                                    <td class="detail-content-label"> Account state  : </td>

                                                    <td class="detail-content-value" >{!! $invoice->account_state !!}</td>

                                                </tr>

                                                <tr>

                                                    <td class="detail-content-label">Follow up :</td>

                                                    <td class="detail-content-value" >{!! ($invoice->user)? $invoice->user->first_name.' '.$invoice->user->last_name : ''  !!}</td>

                                                    <td class="detail-content-label"></td>

                                                    <td class="detail-content-value" ></td>

                                                </tr>

                                                <tr class="" >

                                                    <td class="detail-content-label  ">Create Time :</td>

                                                    <td class="detail-content-value" >  {!!  $invoice->created_at->format('d/m/Y H:i:s') !!}  </td>

                                                    <td class="detail-content-label">Modified Time  </td>

                                                    <td class="detail-content-value">{!!  $invoice->updated_at->format('d/m/Y H:i:s') !!}</td>

                                                </tr>





                                            </table>





                                        </div>

                                    </div>

                                    <div class="panel panel-default">

                                        <div class="panel-heading">

                                            <div class="row">

                                                <div class="col-md-12">

                                                    <div class="panel-heading pull-left">

                                                        <h3 class="panel-title"> Account detail Details</h3>

                                                    </div>



                                                    <div class=" pull-right">



                                                    </div>

                                                </div>

                                            </div>

                                        </div><!-- /.box-header -->

                                        <div class="panel-body">

                                            <table class="table table-bordered detail-table">



                                                <tr>

                                                    <td class="detail-content-label">Original debt :</td>

                                                    <td class="detail-content-value">{!! $invoice->original_debt !!}</td>

                                                    <td class="detail-content-label"> Current balance : </td>

                                                    <td class="detail-content-value">{!! $invoice->current_balance !!}</td>

                                                </tr>

                                                <tr>

                                                    <td class="detail-content-label">Total paid :</td>

                                                    <td class="detail-content-value" >{!! $invoice->total_paid !!}</td>

                                                    <td class="detail-content-label"> Last payment: </td>

                                                    <td class="detail-content-value" >{!! $invoice->last_payment !!}</td>

                                                </tr>

                                                <tr>

                                                    <td class="detail-content-label">Last paid </td>

                                                    <td class="detail-content-value" >{!! $invoice->last_paid !!}</td>

                                                    <td class="detail-content-label"> Solicitor costs to date : </td>

                                                    <td class="detail-content-value" >{!! $invoice->solicitor_cost_date !!}</td>

                                                </tr>

                                                <tr>

                                                    <td class="detail-content-label">Recoverable costs to date </td>

                                                    <td class="detail-content-value" >{!! $invoice->recoverable_cost_date !!}</td>

                                                    <td class="detail-content-label"> Non recoverable costs date: </td>

                                                    <td class="detail-content-value" >{!! $invoice->non_recoverable_cost_date !!}</td>

                                                </tr>

                                                <tr>

                                                    <td class="detail-content-label">Debt recovered to date </td>

                                                    <td class="detail-content-value" >{!! $invoice->debt_recovered_date !!}</td>

                                                    <td class="detail-content-label"> costs recovered to date : </td>

                                                    <td class="detail-content-value" >{!! $invoice->costs_recovered_date !!}</td>

                                                </tr>

                                            </table>

                                        </div>

                                    </div>

                                    @if($invoice->invoice_state =='legal action')

                                        <div class="panel panel-default">

                                            <div class="panel-heading">

                                                <div class="row">

                                                    <div class="col-md-12">

                                                        <div class="panel-heading pull-left">

                                                            <h3 class="panel-title"> Legal arrangemen</h3>

                                                        </div>



                                                        <div class=" pull-right">



                                                        </div>

                                                    </div>

                                                </div>

                                            </div><!-- /.box-header -->

                                            <div class="panel-body">

                                                <table class="table table-bordered detail-table">

                                                    <tr>

                                                        <td class="detail-content-label">Plaint filed :</td>

                                                        <td class="detail-content-value" colspan="3" >{!! nl2br( $invoice->plaint_filed) !!}</td>

                                                    </tr>

                                                    <tr>

                                                        <td class="detail-content-label">judgement date </td>

                                                        <td class="detail-content-value" >{!! $invoice->judgement_date !!}</td>

                                                        <td class="detail-content-label"> Plaint served : </td>

                                                        <td class="detail-content-value">{!! $invoice->plaint_served !!}</td>

                                                    </tr>

                                                    <tr>

                                                        <td class="detail-content-label">court :</td>

                                                        <td class="detail-content-value" >{!! $invoice->court !!}</td>

                                                        <td class="detail-content-label"> Plaint number: </td>

                                                        <td class="detail-content-value" >{!! $invoice->plaint_number !!}</td>

                                                    </tr>



                                                    <tr>



                                                        <td class="detail-content-label"> arrangement : </td>

                                                        <td class="detail-content-value" colspan="3" >{!! nl2br($invoice->arrangement) !!}</td>

                                                    </tr>

                                                </table>

                                            </div>





                                        </div>



                                    @endif



                                    @include('clients/invoices/debtor/menu/footerMenu')



                                </div>



                            </div>

                        </div><!-- /.tab-content -->

                    </div>

                    @if($invoice->invoice_status_code_id != 18)

                        <div class="col-md-3 ">

                            <div class="panel panel-color panel-primary p-0  m-t-20">

                                <div class="panel-heading">

                                    <h3 class="panel-title">Client Detail</h3>

                                </div>

                                <div class="panel-body p-0">



                                    <a href="#" class="list-group-item no-border" ><i class="fa fa-envelope-o"></i> Mail  </a>

                                    <a href="{!! URL::route('client.debtor.invoice.pdf', [$client->id, $invoice->id])!!}" class="list-group-item no-border" ><i class="fa fa-envelope-o"></i> Invoice Pdf  </a>

                                    <a href="#" class="list-group-item no-border" ><i class="fa  fa-building-o"></i> Email template</a>

                                    <a href="#" class="list-group-item no-border" ><i class="fa fa-users"></i> Contact</a>

                                    @if(isset($solicitor->email))

                                        <a href="#"  class="list-group-item no-border" id="solicitor-email-pop-button"><i class="fa fa-filter"></i> Legal </a>

                                    @endif

                                    <a href="#" class="list-group-item no-border" id="email-pop-button"><i class="fa fa-envelope-o"></i> Send FDL  </a>

                                    <a href="#" class="list-group-item no-border" id="email-pop-button-fdl-model"><i class="fa fa-print"></i> FDL print

                                    </a>

                                    @if($invoice->fdl_state == 'FDL send' )

                                        <br>

                                        <br>

                                        <p class="bg-primary">FDL already  send</p>

                                    @else

                                        <a href="#" class="list-group-item no-border" id="email-pop-button-update1"><i class="fa fa-save"></i> FDL Update  </a>

                                    @endif





                                </div><!-- /.box-body -->

                            </div>

                        </div>

                    @endif

            </div>

            <div class="modal fade " id='email-pop-button-pdl-print' role="dialog" aria-hidden="true">

                <div class="modal-dialog modal-lg">

                    <div class="modal-content">

                        <div class="modal-header">

                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>

                            <h4 class="modal-title" id="gridSystemModalLabel">Send email</h4>

                        </div>



                        <div class="modal-body">

                            <div class="container-fluid">

                                <iframe name="ifrm" src="{!! URL::route('client.debtor.invoice.show', [$client->id,$invoice->id]).'?action=fdlPdf' !!}" height="1150" width="100%" ></iframe>



                            </div>

                        </div>

                        <div class="modal-footer">

                            <button   class="btn btn-default" onclick="window.frames['ifrm'].print();" ><i class="fa fa-print"></i> Fdl Print</button>

                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>



                        </div>

                    </div><!-- /.modal-content -->

                </div><!-- /.modal-dialog -->

            </div>

            <div class="modal fade " id='email-pop-button-a2-print' role="dialog" aria-hidden="true">

                <div class="modal-dialog modal-lg">

                    <div class="modal-content">

                        <div class="modal-header">

                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>

                            <h4 class="modal-title" id="gridSystemModalLabel">Send email</h4>

                        </div>



                        <div class="modal-body">

                            <div class="container-fluid">

                                <iframe name="ifrm" src="{!! URL::route('client.debtor.invoice.show', [$client->id,$invoice->id]).'?action=a2' !!}" height="1150" width="100%" ></iframe>



                            </div>

                        </div>

                        <div class="modal-footer">

                            <button   class="btn btn-default" onclick="window.frames['ifrm'].print();" ><i class="fa fa-print"></i> Fdl Print</button>

                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>



                        </div>

                    </div><!-- /.modal-content -->

                </div><!-- /.modal-dialog -->

            </div>



            <div class="modal fade " id='email-pop-button-pdl-update1' role="dialog" aria-hidden="true">

                <div class="modal-dialog modal-lg">

                    <div class="modal-content">

                        <div class="modal-header">

                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>

                            <h4 class="modal-title" id="gridSystemModalLabel">FDL Update</h4>

                        </div>



                        <div class="modal-body">

                            {!! Form::open(array('route' => array('client.debtor.invoice.follow',  $invoice->client_id, $invoice->id), 'autocomplete' => 'off')) !!}



                            <div class="row">



                                <div class="col-md-12">





                                    <div class="row detail-row ">

                                        <div class="col-md-3  label-detail">Action letter :</div>

                                        <div class="col-md-9 value-detail">

                                            <div class="form-group {!! ($errors->has('debtor_id')) ? 'has-error' : '' !!}">

                                                {!! Form::label('collection_action_code_id', 'Action Code', ['class' => 'control-label']) !!}

                                                <div class="row">

                                                    <div class="col-md-12">

                                                        <input type="hidden"   class="collection-action-select" id="collection-action-select-id" name="collection_action_code_id">

                                                        <input type="hidden"  value='debtorInvoice'  name="debtorInvoice">

                                                    </div>



                                                </div>





                                                <span class="help-block">{!! ($errors->has('collection_action_code_id') ? $errors->first('collection_action_code_id') : '') !!}</span>

                                            </div>

                                        </div>

                                    </div>





                                    <div class="row detail-row">

                                        <div class="col-md-3  label-detail">Latest comment :</div>

                                        <div class="col-md-9 value-detail">

                                            <div class="form-group {!! ($errors->has('latest_comment')) ? 'has-error' : '' !!}">



                                                {!! Form::text('latest_comment', null, array('class' => 'form-control', 'placeholder' => 'Eg: good', 'autocomplete' => 'off')) !!}



                                                {!! ($errors->has('latest_comment') ? $errors->first('latest_comment') : '') !!}





                                            </div>

                                        </div>

                                    </div>



                                    <div class="row detail-row">

                                        <div class="col-md-3  label-detail">Previous comment :</div>

                                        <div class="col-md-9 value-detail">

                                            <div class="form-group {!! ($errors->has('previous_comment')) ? 'has-error' : '' !!}">



                                                {!! Form::text('previous_comment', null, array('class' => 'form-control', 'placeholder' => 'Eg: good', 'autocomplete' => 'off')) !!}



                                                {!! ($errors->has('previous_comment') ? $errors->first('previous_comment') : '') !!}





                                            </div>

                                        </div>

                                    </div>

                                    <div class="row detail-row">

                                        <div class="col-md-3  label-detail">Date :</div>

                                        <div class="col-md-9 value-detail">

                                            <div class="form-group {!! ($errors->has('date')) ? 'has-error' : '' !!}">



                                                {!! Form::text('date', null, array('class' => 'form-control datepicker', 'id'=>'date-id', 'placeholder' => 'Eg: 03/19/2015', 'autocomplete' => 'off')) !!}

                                                {!! ($errors->has('date') ? $errors->first('date') : '') !!}

                                            </div>

                                        </div>

                                    </div>

                                    <div class="row detail-row">

                                        <div class="col-md-3  label-detail">Next follow date:</div>

                                        <div class="col-md-9 value-detail">

                                            <div class="form-group {!! ($errors->has('next_follow_date')) ? 'has-error' : '' !!}">



                                                {!! Form::text('next_follow_date', null, array('class' => 'form-control datepicker', 'id'=>'next-follow-date-id', 'placeholder' => 'Eg: 03/19/2015', 'autocomplete' => 'off')) !!}

                                                {!! ($errors->has('next_follow_date') ? $errors->first('next_follow_date') : '') !!}

                                            </div>

                                        </div>

                                    </div>



                                    <div class="row">

                                        <div class="col-md-3  label-detail">Next Follow Time </div>

                                        <div class="col-md-4">

                                            <div class="form-group {!! ($errors->has('start_time')) ? 'has-error' : '' !!}">

                                                {!! Form::label('start_time', 'Start Time') !!}

                                                {!! Form::select('start_time', ['00:00' => '12:00 AM', '00:15' => '12:15 AM','00:30' => '12:30 AM','00:45' => '12:45 AM'

                                                ,'01:00' => '01:00 AM','01:15' => '01:15 AM','01:30' => '01:30 AM','01:45' => '01:45 AM'

                                                ,'02:00' => '02:00 AM','02:15' => '02:15 AM','02:30' => '02:30 AM','02:45' => '02:45 AM'

                                                ,'03:00' => '03:00 AM','03:15' => '03:15 AM','03:30' => '03:30 AM','03:45' => '03:45 AM'

                                                ,'04:00' => '04:00 AM','04:15' => '04:15 AM','04:30' => '04:30 AM','04:45' => '04:45 AM'

                                                ,'05:00' => '05:00 AM','05:15' => '05:15 AM','05:30' => '05:30 AM','05:45' => '05:45 AM'

                                                ,'06:00' => '06:00 AM','06:15' => '06:15 AM','06:30' => '06:30 AM','06:45' => '06:45 AM'

                                                ,'07:00' => '07:00 AM','07:15' => '07:15 AM','07:30' => '07:30 AM','07:45' => '07:45 AM'

                                                ,'08:00' => '08:00 AM','08:15' => '08:15 AM','08:30' => '08:30 AM','08:45' => '08:45 AM'

                                                ,'09:00' => '09:00 AM','09:15' => '09:15 AM','09:30' => '09:30 AM','09:45' => '09:45 AM'

                                                ,'10:00' => '10:00 AM','10:15' => '10:15 AM','10:30' => '10:30 AM','10:45' => '10:45 AM'

                                                ,'11:00' => '11:00 AM','11:15' => '11:15 AM','11:30' => '11:30 AM','11:45' => '11:45 AM'

                                                ,'12:00' => '12:00 PM','12:15' => '12:15 PM','12:30' => '12:30 PM','12:45' => '12:45 PM'

                                                ,'13:00' => '01:00 PM','13:15' => '01:15 PM','13:30' => '01:30 PM','13:45' => '01:45 PM'

                                                ,'14:00' => '02:00 PM','14:15' => '02:15 PM','14:30' => '02:30 PM','14:45' => '02:45 PM'

                                                ,'15:00' => '03:00 PM','15:15' => '03:15 PM','15:30' => '03:30 PM','15:45' => '03:45 PM'

                                                ,'16:00' => '04:00 PM','16:15' => '04:15 PM','16:30' => '04:30 PM','16:45' => '04:45 PM'

                                                ,'17:00' => '05:00 PM','17:15' => '05:15 PM','17:30' => '05:30 PM','17:45' => '05:45 PM'

                                                ,'18:00' => '06:00 PM','18:15' => '06:15 PM','18:30' => '06:30 PM','18:45' => '06:45 PM'

                                                ,'19:00' => '07:00 PM','19:15' => '07:15 PM','19:30' => '07:30 PM','19:45' => '07:45 PM'

                                                ,'20:00' => '08:00 PM','20:15' => '08:15 PM','20:30' => '08:30 PM','20:45' => '08:45 PM'

                                                ,'21:00' => '09:00 PM','21:15' => '09:15 PM','21:30' => '09:30 PM','21:45' => '09:45 PM'

                                                ,'22:00' => '10:00 PM','22:15' => '10:15 PM','22:30' => '10:30 PM','22:45' => '10:45 PM'

                                                ,'23:00' => '11:00 PM','23:15' => '11:15 PM','23:30' => '11:30 PM','23:45' => '11:45 PM'], null, array('class' => 'form-control start_time', 'placeholder' => '12:00 AM')) !!}

                                                {!! ($errors->has('start_time') ? $errors->first('start_time') : '') !!}

                                            </div>



                                        </div>

                                        <div class="col-md-5">

                                            <div class="form-group {!! ($errors->has('end_time')) ? 'has-error' : '' !!}">

                                                {!! Form::label('end_time', 'End Time') !!}

                                                {!! Form::select('end_time', ['00:00' => '12:00 AM', '00:15' => '12:15 AM','00:30' => '12:30 AM','00:45' => '12:45 AM'

                                                ,'01:00' => '01:00 AM','01:15' => '01:15 AM','01:30' => '01:30 AM','01:45' => '01:45 AM'

                                                ,'02:00' => '02:00 AM','02:15' => '02:15 AM','02:30' => '02:30 AM','02:45' => '02:45 AM'

                                                ,'03:00' => '03:00 AM','03:15' => '03:15 AM','03:30' => '03:30 AM','03:45' => '03:45 AM'

                                                ,'04:00' => '04:00 AM','04:15' => '04:15 AM','04:30' => '04:30 AM','04:45' => '04:45 AM'

                                                ,'05:00' => '05:00 AM','05:15' => '05:15 AM','05:30' => '05:30 AM','05:45' => '05:45 AM'

                                                ,'06:00' => '06:00 AM','06:15' => '06:15 AM','06:30' => '06:30 AM','06:45' => '06:45 AM'

                                                ,'07:00' => '07:00 AM','07:15' => '07:15 AM','07:30' => '07:30 AM','07:45' => '07:45 AM'

                                                ,'08:00' => '08:00 AM','08:15' => '08:15 AM','08:30' => '08:30 AM','08:45' => '08:45 AM'

                                                ,'09:00' => '09:00 AM','09:15' => '09:15 AM','09:30' => '09:30 AM','09:45' => '09:45 AM'

                                                ,'10:00' => '10:00 AM','10:15' => '10:15 AM','10:30' => '10:30 AM','10:45' => '10:45 AM'

                                                ,'11:00' => '11:00 AM','11:15' => '11:15 AM','11:30' => '11:30 AM','11:45' => '11:45 AM'

                                                ,'12:00' => '12:00 PM','12:15' => '12:15 PM','12:30' => '12:30 PM','12:45' => '12:45 PM'

                                                ,'13:00' => '01:00 PM','13:15' => '01:15 PM','13:30' => '01:30 PM','13:45' => '01:45 PM'

                                                ,'14:00' => '02:00 PM','14:15' => '02:15 PM','14:30' => '02:30 PM','14:45' => '02:45 PM'

                                                ,'15:00' => '03:00 PM','15:15' => '03:15 PM','15:30' => '03:30 PM','15:45' => '03:45 PM'

                                                ,'16:00' => '04:00 PM','16:15' => '04:15 PM','16:30' => '04:30 PM','16:45' => '04:45 PM'

                                                ,'17:00' => '05:00 PM','17:15' => '05:15 PM','17:30' => '05:30 PM','17:45' => '05:45 PM'

                                                ,'18:00' => '06:00 PM','18:15' => '06:15 PM','18:30' => '06:30 PM','18:45' => '06:45 PM'

                                                ,'19:00' => '07:00 PM','19:15' => '07:15 PM','19:30' => '07:30 PM','19:45' => '07:45 PM'

                                                ,'20:00' => '08:00 PM','20:15' => '08:15 PM','20:30' => '08:30 PM','20:45' => '08:45 PM'

                                                ,'21:00' => '09:00 PM','21:15' => '09:15 PM','21:30' => '09:30 PM','21:45' => '09:45 PM'

                                                ,'22:00' => '10:00 PM','22:15' => '10:15 PM','22:30' => '10:30 PM','22:45' => '10:45 PM'

                                                ,'23:00' => '11:00 PM','23:15' => '11:15 PM','23:30' => '11:30 PM','23:45' => '11:45 PM'], null, array('class' => 'form-control end_time', 'placeholder' => '12:00 AM')) !!}

                                                {!! ($errors->has('end_time') ? $errors->first('end_time') : '') !!}

                                            </div>

                                        </div>

                                    </div>



                                </div>



                            </div>

                        </div>

                        <div class="modal-footer">

                            {!! Form::submit('Update', array('class' => 'btn btn-info')) !!} &nbsp;&nbsp;



                            {!!Form::close()!!}



                        </div>

                    </div><!-- /.modal-content -->

                </div><!-- /.modal-dialog -->

            </div>





            @include('clients/include/pop/debtorInvoice/sendFDLEmail')

            @if(isset($solicitor->email))

                @include('clients/include/pop/debtorInvoice/sendSolicitorEmail')

            @endif

            @stop

            @section('include-js')

                @parent



            @stop



            @section('document-ready-js')

                @parent



                @include('clients/include/pop/debtorInvoice/sendSolicitorEmailJs')

                @include('clients/include/pop/debtorInvoice/sendFDLEmailJs')



                $('#email-content-data').textcomplete([

                {// tech companies

                words: ['apple', 'google', 'facebook', 'github'],

                match: /\b(\w{2,})$/,

                search: function (term, callback) {



                alert(1);

                callback($.map(this.words, function (word) {

                return word.indexOf(term) === 0 ? word : null;

                }));





                },

                index: 1,

                replace: function (word) {

                return word + ' ';

                }

                }





                ]);

                $('#solicitor-email-content-data').textcomplete([

                {// tech companies

                words: ['apple', 'google', 'facebook', 'github'],

                match: /\b(\w{2,})$/,

                search: function (term, callback) {



                alert(1);

                callback($.map(this.words, function (word) {

                return word.indexOf(term) === 0 ? word : null;

                }));





                },

                index: 1,

                replace: function (word) {

                return word + ' ';

                }

                }





                ]);





                $("body").on("click", "#email-pop-button-fdl-model", function () {





                $('#email-pop-button-pdl-print').modal('show');



                });



                $("body").on("click", "#email-pop-button-update1", function () {



                $('body .collection-action-select .select2-chosen').text("FDL");

                $('body  #collection-action-select-id').val(16)

                $('#email-pop-button-pdl-update1').modal('show');



                });



                $("body").on("click", "#email-pop-button-a2-model", function () {





                $('#email-pop-button-a2-print').modal('show');



                });





                var getCollectionActionCodeUrl = '{!! route("collectionActionCode.index") !!}';

                $('.collection-action-select').select2({

                width: '100%',

                ajax: {

                url: getCollectionActionCodeUrl,

                dataType: 'json',

                quietMillis: 100,

                data: function (term) {

                return {

                term: term

                };

                },

                results: function (data) {



                console.log(data);

                var results = [];



                $.each(data, function (index, item) {



                results.push({

                id: item.id,

                text: item.code + ' ' + item.description,

                });

                });



                return {

                results: results

                };

                }

                },

                minimumInputLength: 0,

                });





                $("#date-id").change(function () {

                var dmy = $("#date-id").val().split("/");        // "24/06/2011" should be pulled from $("#DatePicker").val() instead

                var date = new Date(

                parseInt(dmy[2], 10),

                parseInt(dmy[1], 10) - 1,

                parseInt(dmy[0], 10)

                );

                // var date = new Date($("#date-id").val()),

                days = parseInt(14);



                if (!isNaN(date.getTime())) {

                date.setDate(date.getDate() + days);



                $("#next-follow-date-id").val(date.toInputFormat());

                } else {

                alert("Invalid Date");

                }

                });



                Date.prototype.toInputFormat = function () {

                var yyyy = this.getFullYear().toString();

                var mm = (this.getMonth() + 1).toString(); // getMonth() is zero-based

                var dd = this.getDate().toString();

                return  (dd[1] ? dd : "0" + dd[0]) + "/" + (mm[1] ? mm : "0" + mm[0]) + "/" + yyyy ; // padding

                }

                ;



                $('.start_time').change(function () {



                var t1 = "00:15";

                var mins = 0;

                var hrs = 0;



                t1 = t1.split(':');

                var t2 = $(this).val().split(':');

                mins = Number(t1[1]) + Number(t2[1]);

                minhrs = Math.floor(parseInt(mins / 60));

                hrs = Number(t1[0]) + Number(t2[0]) + minhrs;

                mins = mins % 60;



                t1 = hrs.padDigit() + ':' + mins.padDigit();







                $('.end_time').val( t1);

                });



                Number.prototype.padDigit = function () {



                return (this < 10) ? '0' + this : this;

                }





                $('body .collection-action-select .select2-chosen').text("FDL");

                $('body  #collection-action-select-id').val(16);





                $("body").on("click", ".sfn-btn-class", function () {





                $('body .collection-action-select .select2-chosen').text("SFN");

                $('body  #collection-action-select-id').val(46);

                $('#email-pop-button-pdl-update1').modal('show');



                });

                $("body").on("click", ".a2-btn-class", function () {





                $('body .collection-action-select .select2-chosen').text("A2");

                $('body  #collection-action-select-id').val(1);

                $('#email-pop-button-pdl-update1').modal('show');



                });



@stop

