@extends('layouts.master')
@section('title')
@parent
Client mail
@stop

@section('content') 
<div class="row"> 
    <div class="col-md-9">
        <ol class="breadcrumb">
            <li><a href="{!! URL::route('client.index') !!}">Client</a></li>  
            <li><a href="{!! URL::route('client.detail', [$client->id]) !!}">{!! $client->name !!}</a></li> 
            <li>Email Detail</li>

        </ol>
        <div class="nav-tabs-custom">
            @include('clients/nav')
            <div class="tab-content">
                <div class="tab-pane active"> 


                    <div class="box">
                        <div class="box-header">
                            <h3 class="box-title"> </h3> 
                            <div class="btn-group pull-right">



                            </div>
                        </div><!-- /.box-header -->
                        <div class="box-body">
                            <div class="table-responsive mailbox-messages">
                                <table class="table table-hover table-striped">

                                    <tr>
                                        <th style="width: 10px">#</th> 
                                        <th>Name</th>
                                        <th>Type</th>
                                        <th>Subject</th> 
                                        <td>Time</td>

                                    </tr> 

                                    @foreach($mails as $mail)

                                    <tr>
                                        <td class="mailbox-star"></td> 
                                        <td class="mailbox-name email-detail-view-pop-button"   data-field="{!! $mail->field  !!}" data-subject="{!! $mail->mail->subject !!}" > 
                                            <div class="data-content"  >{!! nl2br(  $mail->mail->content ) !!}</div> 
                                          @foreach($mail->mail->)
                                            
                                            @if()
                                            
                                            @endif
                                            
                                            @foreachend
                                            
                                            <a href="#"> {!! $client->name !!} </a></td>
                                        <td class="mailbox-name">{!! $mail->field !!}</td>  
                                        <td class="mailbox-subject">{!! $mail->mail->subject !!}</td>  
                                        <td class="mailbox-date">{!! $mail->mail->created_at->diffForHumans() !!}</td>

                                    </tr>
                                    @endforeach
                                </table> 
                            </div>
                        </div><!-- /.box-body -->
                        <div class="box-footer clearfix">
                            {!! $mails->render() !!}  
                            @include('clients/menu/footerMenu')
                        </div>
                    </div>

                </div>
            </div>
        </div>




    </div> 

    <div class="col-md-3 "> 
        @include('clients/menu/sideMenu')
    </div>
</div>  





@include('clients/include/pop/clientEmail')
@include('clients/include/pop/emailView')

@stop
@section('include-js')
@parent

@stop

<script>
    @section('document-ready-js')
            @parent

            @include('clients/include/pop/clientEmailJs')


            $('.email-detail-view-pop-button').on()

    $("body").on("click", ".email-detail-view-pop-button", function () {

        $('#email-subject-pop').text($(this).attr('data-subject'));

        $('#email-field-pop').text($(this).attr('data-field'));
        $('#email-content-pop').html($(this).children('.data-content').html());

        $('#email-detail-pop').modal('show');
    });


    $('.data-content').hide();


    @stop

</script>


