@extends('layouts.master')
@section('title')
@parent
Client detail
@stop

@section('content')
<div class="row">
    <div class="col-sm-12">
        <h4 class="pull-left page-title"> </h4>
        <ol class="breadcrumb pull-right">
            <li><a href="{!! route('home.index') !!}">Dashboard</a></li>
            <li><a href="{!! URL::route('client.index') !!}">Client</a></li>
            <li class="active" >{!! $client->name !!} </li>
            <li class="active" >Details</li>

        </ol>
    </div>
</div>
<div class="row">
    <div class="col-md-9">

        <div class="nav-tabs-custom">
            @include('clients/nav')
            <div class="tab-content">
                <div class="tab-pane active">

                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="panel-heading pull-left">
                                        <h3 class="panel-title"> Client information </h3>
                                    </div>

                                    <div class=" pull-right">
                                         <a href="{!! route('client.paymentAdjustment.index', [$client->id]) !!}" class="btn btn-inverse"><span><i class="fa  fa-edit" rel="tooltip" title="Edit"></i> Payment Adjustment </span>
                                        </a>
                                        <a class="btn btn-danger" href="{!! route('client.import', [$client->id]) !!}" id="select-import-btn" >Import</a>
                                        <a href="{!! route('client.edit', [$client->id]) !!}" class="btn btn-primary"><span><i class="fa  fa-edit" rel="tooltip" title="Edit"></i> Edit </span> </a>
                                        <a href="{!! URL::route('client.index') !!}" class="btn btn-default">Back</a>
                                    </div>
                                </div>
                            </div>
                        </div><!-- /.box-header -->
                        <div class="panel-body">


                            <table class="table table-bordered detail-table">
                                <thead>
                                    <tr>
                                        <th class="detail-content-label  " style="width: 150px" ></th>
                                        <th class="detail-content-label  " ></th>
                                        <th class="detail-content-label  " style="width: 150px" ></th>
                                        <th class="detail-content-label  " ></th>

                                    </tr>
                                </thead>
                                <tr class="" >
                                    <td class="detail-content-label  ">Name </td>
                                    <td class="detail-content-value" >  {!! ucfirst( strtolower( $client->name)) !!}  </td>
                                    <td class="detail-content-label"> Registered name  </td>
                                    <td class="detail-content-value">{!! $client->registered_name." ".$client->registered_name2 !!}</td>
                                </tr>

                                <tr>
                                    <td class="detail-content-label">Address </td>
                                    <td class="detail-content-value" >
                                      <address class="ng-scope">
                                        {!! ucfirst( strtolower( $client->address1)) !!}
                                        @if(!(is_null($client->address2)))
                                        <br>
                                        {!! ucfirst( strtolower( $client->address2)) !!}
                                        @endif
                                        @if(!(is_null($client->address3)))
                                        <br>
                                        {!! ucfirst( strtolower( $client->address3)) !!}
                                        @endif

                                    </address>

                                    </td>
                                     <td class="detail-content-label"> Telephone number


                                     </td>
                                    <td class="detail-content-value" >{!!$client->tel_number !!}



                                    </td>
                                </tr>


                                <tr>
                                    <td class="detail-content-label">Post code </td>
                                    <td class="detail-content-value" >{!! $client->post_code !!}</td>
                                    <td class="detail-content-label"> Fax number  </td>
                                    <td class="detail-content-value" >{!!$client->fax_number !!}</td>
                                </tr>
                                <tr>

                                    <td class="detail-content-label"> ABN </td>
                                    <td class="detail-content-value" >{!! $client->registered_office !!}</td>
                                   <td class="detail-content-label">  Mobile Number </td>
                                    <td class="detail-content-value" > {!!$client->mobile_number !!} </td>
                                </tr>
                                <tr>

                                    <td class="detail-content-label"> Client Code </td>
                                    <td class="detail-content-value" >{!!  $client->client_code !!} </td>
                                     <td class="detail-content-label">contact person</td>
                                    <td class="detail-content-value" >{!! $client->contact_person !!}</td>
                                </tr>
                                 <tr class="" >
                                    <td class="detail-content-label  ">Create Time :</td>
                                    <td class="detail-content-value" >  {!!  $client->created_at->format('d/m/Y H:i:s') !!}  </td>
                                    <td class="detail-content-label">Modified Time  </td>
                                    <td class="detail-content-value">{!!  $client->updated_at->format('d/m/Y H:i:s') !!}</td>
                                </tr>

                            </table>


                        </div>
                    </div>
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="panel-heading pull-left">
                                        <h3 class="panel-title"> Solicitor  Add </h3>
                                    </div>

                                    <div class="pull-right">

                                    </div>
                                </div>
                            </div>
                        </div><!-- /.box-header -->
                        <div class="panel-body">
                            <table class="table table-bordered detail-table">
                                <tr class="detail-header">


                                </tr>
                                <tr>
                                    <td class="detail-content-label"> Commission  Rate  </td>
                                    <td class="detail-content-value">{!! $client->commission !!}%</td>
                                     <td class="detail-content-label"> Credit limit  </td>
                                    <td class="detail-content-value" >{!! $client->credit_limit !!}</td>
                                </tr>
                                <tr>
                                    <td class="detail-content-label">Final demand rate </td>
                                    <td class="detail-content-value" >{!! $client->final_demand_rate !!}</td>
                                    <td class="detail-content-label"> Personal call rate  </td>
                                    <td class="detail-content-value" >{!! $client->personal_call_rate !!}</td>
                                </tr>
                                <tr>
                                    <td class="detail-content-label">Red letter rate </td>
                                    <td class="detail-content-value" >{!! $client->red_letter_rate !!}</td>
                                      <td class="detail-content-label">  </td>
                                    <td class="detail-content-value" ></td>

                                </tr>


                            </table>


                            <div class="box-footer clearfix">

                            </div>

                        </div>


                    </div>


                    @include('clients/menu/footerMenu')

                </div>

            </div>
        </div><!-- /.tab-content -->
    </div>
    <div class="col-md-3 ">
        @include('clients/menu/sideMenu')
    </div>
</div>
@include('clients/include/pop/clientEmail')




@stop
@section('include-js')
@parent

@stop


@section('document-ready-js')
@parent

@include('clients/include/pop/clientEmailJs')

$('#email-content-data').textcomplete([
{// tech companies
words: ['apple', 'google', 'facebook', 'github'],
match: /\b(\w{2,})$/,
search: function (term, callback) {

alert(1);
callback($.map(this.words, function (word) {
return word.indexOf(term) === 0 ? word : null;
}));


},
index: 1,
replace: function (word) {
return word + ' ';
}
}
]);



@stop


