@extends('layouts.master')
@section('title')
@parent
Debtors
@stop

@section('content')
<div class="row">
    <div class="col-sm-12">
        <h4 class="pull-left page-title"> </h4>
        <ol class="breadcrumb pull-right">
            <li><a href="{!! route('home.index') !!}">Dashboard</a></li>
            <li><a href="{!! URL::route('client.index') !!}">Client</a></li> 
            <li class="active" >{!! $client->name !!}</li> 
            <li class="active" >Payment Adjustment</li> 
        </ol>
    </div>
</div> 

<div class="nav-tabs-custom">
    @include('clients/nav')
    <div class="tab-content">
        <div class="tab-pane active" >
            <div class="panel panel-default">
                <div class="panel-heading">
                    <div class="row"> 
                        <div class="col-md-12">
                            <div class="panel-heading pull-left">
                                <h3 class="panel-title"> Payment Adjustment</h3>
                            </div>

                            <div class=" pull-right"> 

                            </div>
                        </div>
                    </div>
                </div><!-- /.box-header -->
                <div class="panel-body table-rep-plugin"> 
                    
                    
                      {!! Form::open(array('route' => array('client.paymentAdjustment.store',  $client->id), 'autocomplete' => 'off')) !!}
                     <table class="table table-bordered detail-table">
                     <tr>
                        <td class="detail-content-label"> Client Name : </td>
                        <td class="detail-content-value"><div class="pull-right" id="client-name">{!!  $client->name !!}</div></td>
                    </tr>  
                    <tr class="cheque-div" >
                            <td class="detail-content-label"> Description  : </td>
                            <td class="detail-content-value"> 
                                <div class="form-group {!! ($errors->has('description')) ? 'has-error' : '' !!}">
                                    
                                    {!! Form::textarea('description', null, array('class' => 'form-control', 'size' => '30x5')) !!}

                                    {!! ($errors->has('description') ? $errors->first('description') : '') !!}


                                </div> 
                            </td>
                        </tr>   
                   



                    
                    <tr class=" ">
                        <td class="detail-content-label"> Adjustment Date  : </td>
                        <td class="detail-content-value"> 
                            <div class="form-group {!! ($errors->has('adjustment_date')) ? 'has-error' : '' !!}">
                                
                                {!! Form::text('adjustment_date', null, array('class' => 'form-control datepicker', 'placeholder' => 'Eg: 03/19/2015', 'autocomplete' => 'off')) !!}
                                {!! ($errors->has('adjustment_date') ? $errors->first('adjustment_date') : '') !!}
                            </div>

                        </td>
                    </tr> 
                    <tr  class="pay-div" >
                        <td class="detail-content-label"> Adjustment  Type  : </td>
                        <td class="detail-content-value">  
                            <h5 class="text-danger" > 
                               1) if you select Debit Balance Adjustment(+), <br>  that will plus with opening balance.
                               <br><br><br>
                               2) if you select Debit Balance Adjustment (-), <br>  that will minus from opening balance.
                            </h5>
                            <div class="form-group {!! ($errors->has('adjustment_type')) ? 'has-error' : '' !!}">

                                {!!  Form::select('adjustment_type',  [ 'Debit Balance Add'=>'Debit Balance Adjustment(+)', 'Trust Balance Add'=>'Debit Balance Adjustment (-)'], 'Trust Balance Add' ,['class' => 'form-control payment', 'placeholder' => 'state', 'required'])  !!}
                                <span class="help-block">{!! ($errors->has('adjustment_type') ? $errors->first('adjustment_type') : '') !!}</span>
                            </div>  

                        </td>
                    </tr> 
                     <tr>
                        <td class="detail-content-label"> Pay amount  : </td>
                        <td class="detail-content-value"> 
                            <div class="form-group {!! ($errors->has('amount')) ? 'has-error' : '' !!}">

                                {!! Form::text('amount', null  , array('class' => 'form-control text-right amount-class', 'placeholder' => '20.00', 'autocomplete' => 'off')) !!}
                                {!! ($errors->has('amount') ? $errors->first('amount') : '') !!}
                            </div>
                        </td> 
                    </tr> 

                     
                          <tr>
                        <td colspan="2" class="detail-content-value"> <div class="pull-right"> {!! Form::submit('Add Payment Adjustment', array('class' => 'btn pay-due-btn btn-success')) !!} &nbsp;&nbsp; 

                            </div></td>
                    </tr> 
                </table>
                    {!!Form::close()!!}   
                    <br><br>
                    <div class="table-responsive" data-pattern="">
                        <table id="tech-companies-1" class="table  table-bordered ">
                            <thead>
                                <tr>
                                    <th style="width: 10px">#</th> 
                                    <th data-priority="6" >Adjustment Date</th>
                                    <th data-priority="1" >Description</th>
                                    <th data-priority="1" >Type</th> 
                                    <th data-priority="1" >Amount</th>
                                   
                                </tr> 
                            </thead> 
                            <tbody>
                                @foreach($paymentAdjustments as $paymentAdjustment)

                                <tr>
                                    <td></td>
                                    <td>{!! $paymentAdjustment->adjustment_date !!}</td>  
                                    <td>
                                        {!! $paymentAdjustment->adjustment_type !!}
                                    </td>
                                    <td>{!! $paymentAdjustment->description !!}</td> 
                                    <td> {!! $paymentAdjustment->amount !!}</td> 

                                   
                                   

                                </tr>
                                @endforeach 
                            </tbody>
                        </table> 
                    </div>
                </div><!-- /.box-body -->
               
            </div>
        </div>
    </div>
</div>
@stop
@section('include-js')
@parent

@stop


    @section('document-ready-js')
            @parent

          


    @stop




