@extends('layouts.master')
@section('title')
@parent
Client detail
@stop

@section('content') 
<div class="row">
    <div class="col-sm-12">
        <h4 class="pull-left page-title"> </h4>
        <ol class="breadcrumb pull-right">
            <li><a href="{!! route('home.index') !!}">Dashboard</a></li>
            <li><a href="{!! URL::route('client.index') !!}">Client</a></li> 
            <li class="active" >{!! $client->name !!} </li>
            <li class="active" >Details</li> 

        </ol>
    </div>
</div>  
<div class="row"> 
    <div class="col-md-9"> 

        <div class="nav-tabs-custom">
            @include('clients/nav')
            <div class="tab-content">
                <div class="tab-pane active"> 

                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <div class="row"> 
                                <div class="col-md-12">
                                    <div class="panel-heading pull-left">
                                        <h3 class="panel-title"> Client information </h3>
                                    </div>

                                    <div class=" pull-right"> 
                                        <a href="{!! route('client.edit', [$client->id]) !!}" class="btn btn-primary"><span><i class="fa  fa-edit" rel="tooltip" title="Edit"></i> Edit </span> </a>
                                        <a href="{!! URL::route('client.index') !!}" class="btn btn-default">Back</a>
                                    </div>
                                </div>
                            </div>
                        </div><!-- /.box-header -->
                        <div class="panel-body">


                            <address class="ng-scope">
                                            <strong>Twitter, Inc.</strong><br>
                                            795 Folsom Ave, Suite 600<br>
                                            San Francisco, CA 94107<br>
                                            <abbr title="Phone">P:</abbr> (123) 456-7890
                                        </address>

                            <table class="table table-bordered detail-table">

                                <tr>
                                    <td class="detail-content-label">Name :</td>
                                    <td class="detail-content-value">{!! $client->name !!}</td>
                                    <td class="detail-content-label"> Registered name : </td>
                                    <td class="detail-content-value">{!! $client->registered_name !!}</td>
                                </tr>
                                <tr>
                                    <td class="detail-content-label">Registered name 2 :</td>
                                    <td class="detail-content-value" >{!! $client->registered_name2 !!}</td>
                                    <td class="detail-content-label"> Billing address: </td>
                                    <td class="detail-content-value" >{!! $client->address1 !!}</td>
                                </tr>  
                                <tr>
                                    <td class="detail-content-label">Billing suburb:</td>
                                    <td class="detail-content-value" >{!! $client->address2 !!}</td>
                                    <td class="detail-content-label"> Billing state  : </td>
                                    <td class="detail-content-value" >{!! $client->address3 !!}</td>
                                </tr>  
                                <tr>
                                    <td class="detail-content-label">Post code :</td>
                                    <td class="detail-content-value" >{!! $client->post_code !!}</td>
                                    <td class="detail-content-label"> Telephone number : </td>
                                    <td class="detail-content-value" >{!!$client->tel_number !!}</td>
                                </tr> 
                                <tr>

                                    <td class="detail-content-label"> Registered office </td>
                                    <td class="detail-content-value" >{!! $client->registered_office !!}</td> 
                                    <td class="detail-content-label"></td>
                                    <td class="detail-content-value" ></td>
                                </tr>

                            </table>


                        </div>
                    </div> 
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <div class="row"> 
                                <div class="col-md-12">
                                    <div class="panel-heading pull-left">
                                        <h3 class="panel-title"> Solicitor  Add </h3>
                                    </div>

                                    <div class="pull-right">

                                    </div> 
                                </div>
                            </div>
                        </div><!-- /.box-header -->
                        <div class="panel-body"> 
                            <table class="table table-bordered detail-table">
                                <tr class="detail-header">


                                </tr>
                                <tr>
                                    <td class="detail-content-label">Minimum fees :</td>
                                    <td class="detail-content-value">{!! $client->minimum_fees !!}</td>
                                    <td class="detail-content-label"> Maximum fees : </td>
                                    <td class="detail-content-value">{!! $client->maximum_fees !!}</td>
                                </tr>
                                <tr>
                                    <td class="detail-content-label">Final demand rate :</td>
                                    <td class="detail-content-value" >{!! $client->final_demand_rate !!}</td>
                                    <td class="detail-content-label"> Personal call rate : </td>
                                    <td class="detail-content-value" >{!! $client->personal_call_rate !!}</td>
                                </tr>  
                                <tr>
                                    <td class="detail-content-label">Red letter rate </td>
                                    <td class="detail-content-value" >{!! $client->red_letter_rate !!}</td>
                                    <td class="detail-content-label"> Credit limit : </td>
                                    <td class="detail-content-value" >{!! $client->credit_limit !!}</td>
                                </tr>  


                            </table>


                            <div class="box-footer clearfix"> 

                            </div>

                        </div> 


                    </div>  


                    @include('clients/menu/footerMenu')

                </div> 

            </div>
        </div><!-- /.tab-content -->
    </div> 
    <div class="col-md-3 "> 
        @include('clients/menu/sideMenu')
    </div>
</div>
@include('clients/include/pop/clientEmail')




@stop
@section('include-js')
@parent

@stop  


    @section('document-ready-js')
            @parent

            @include('clients/include/pop/clientEmailJs')

            $('#email-content-data').textcomplete([
        {// tech companies 
            words: ['apple', 'google', 'facebook', 'github'],
            match: /\b(\w{2,})$/,
            search: function (term, callback) {

                alert(1);
                callback($.map(this.words, function (word) {
                    return word.indexOf(term) === 0 ? word : null;
                }));


            },
            index: 1,
            replace: function (word) {
                return word + ' ';
            }
        }
    ]);



    @stop


