@extends('layouts.master')
@section('title')
@parent
Config
@stop

@section('content')
<div class="box">
    <div class="box-header">
        <h3 class="box-title">Config Create</h3>
    </div><!-- /.box-header -->
    <div class="box-body">
        {!! Form::open(array('route' => array('config.store'), 'autocomplete' => 'off')) !!}

        <div class="form-group {!! ($errors->has('name')) ? 'has-error' : '' !!}">
            {!! Form::label('name', 'Name') !!}
            {!! Form::text('name', null, array('class' => 'form-control', 'placeholder' => 'Eg: pagenation', 'autocomplete' => 'off')) !!}
            {!! ($errors->has('name') ? $errors->first('name') : '') !!}
        </div>
        
        <div class="form-group {!! ($errors->has('value')) ? 'has-error' : '' !!}">
            {!! Form::label('value', 'Value') !!}
            {!! Form::text('value', null, array('class' => 'form-control', 'placeholder' => 'Eg: 10 or exampl@gmail.com', 'autocomplete' => 'off')) !!}
            {!! ($errors->has('value') ? $errors->first('value') : '') !!}
        </div>
        
       
       <div class="form-group {!! ($errors->has('state')) ? 'has-error' : '' !!}">
           {!! Form::label('state', 'State', ['class' => 'control-label']) !!}
           {!!  Form::select('state',  [ 'disable'=>'Disable', 'enable'=>'Enable'], null  ,['class' => 'form-control', 'placeholder' => 'state', 'required'])  !!}
            <span class="help-block">{!! ($errors->has('state') ? $errors->first('state') : '') !!}</span>
       </div>
    </div>
    <div class="box-footer clearfix"> 
        <div class=" pull-right">
            {!! Form::submit('Create', array('class' => 'btn btn-success')) !!} &nbsp;&nbsp;
            <a href="{!!URL::route('config.index')!!}" class="btn btn-default">Cancel</a>
            {!!Form::close()!!} 
        </div>
    </div>
</div>

@stop
@section('include-js')
@parent

@stop

