@extends('layouts.master')
@section('title')
@parent
configuration
@stop

@section('content')
<div class="box">
    <div class="box-header">
        <h3 class="box-title">configuration</h3> 
        <div class="btn-group pull-right">
            {!! link_to_route('config.create' , 'Add config', [], ['class' => 'btn btn-success btn-create']) !!}
        </div>
    </div><!-- /.box-header -->
    <div class="box-body">
        <table class="table table-bordered">
            <tr>
                <th style="width: 10px">#</th>
                <th>Name</th> 
                  <th>Value</th>
                <th>State</th>

                <th >Action</th>
            </tr> 

            @foreach($configs as $config)

            <tr>
                <td></td>
                <td>{!!$config->name !!}</td>
                <td>{!!$config->value !!}</td>
                <td>{!! $config->state !!}</td> 
               
                <td>

                    <a href="{!! route('config.edit', [$config->id]) !!}"><i class="fa  fa-edit" rel="tooltip" title="Edit"></i>  </a>&nbsp;&nbsp;
                    <a href="{!! route('config.delete', [$config->id]) !!}"><i class="fa  fa-archive" rel="tooltip" title="Delete"></i>  </a>


                </td>
            </tr>
            @endforeach
        </table>
    </div><!-- /.box-body -->
    <div class="box-footer clearfix">
        {!! $configs->render() !!}
    </div>
</div>

@stop
@section('include-js')
@parent

@stop

