@extends('layouts.master')
@section('title')
@parent
Debtor detail
@stop

@section('content') 
<div class="row"> 
    <div class="col-md-9">


        <div class="box ">
            <div class="box-header">
                <ol class="breadcrumb">
                    <li><a href="{!! URL::route('debtor.index') !!}">Debtor</a></li>  

                    <li>Details</li> 
                    <li>{!! $debtor->name !!}</li>
                </ol> 
            </div> 
            <div class="box-body">  


                <table class="table table-bordered detail-table">
                    <tr class="detail-header">
                        <th class="" colspan="4" > Debtor information </th>

                    </tr>
                    <tr>
                        <td class="detail-content-label">Name :</td>
                        <td class="detail-content-value">{!! $debtor->name !!}</td>
                        <td class="detail-content-label"> Debtor code : </td>
                        <td class="detail-content-value">{!! $debtor->debtor_code !!}</td>
                    </tr>
                    <tr>

                        <td class="detail-content-label"> Email: </td>
                        <td class="detail-content-value" >{!! $debtor->email !!}</td> 
                        <td class="detail-content-label"> Mailing address: </td>
                        <td class="detail-content-value" >{!! $debtor->mailing_address !!}</td> 

                    </tr>  
                    <tr>
                        <td class="detail-content-label">Mailing suburb :</td>
                        <td class="detail-content-value" >{!! $debtor->mailing_suburb !!}</td>
                        <td class="detail-content-label">Mailing postcode:</td>
                        <td class="detail-content-value" >{!! $debtor->mailing_postcode !!}</td>

                    </tr>  


                </table>


            </div>
        </div> 



        <div class="btn-group btn-group-justified" role="group" aria-label="...">
            <div class="btn-group" role="group">
                <button type="button" class="btn btn-default">Office notes</button>
            </div>
            <div class="btn-group" role="group">
                <button type="button" class="btn btn-default">Communication</button>
            </div>
            <div class="btn-group" role="group">
                <a href="{!! URL::route('debtor.mail', [$debtor->id]) !!}" class="btn btn-default">Email</a>
            </div> 
            <div class="btn-group" role="group">
                <button type="button" class="btn btn-default">Sms detail</button>
            </div> 
            <div class="btn-group" role="group">
                <button type="button" class="btn btn-default">Reports</button>
            </div> 
            <div class="btn-group" role="group">
                <button type="button" class="btn btn-default">Letter</button>
            </div>

        </div>  


    </div> 

    <div class="col-md-3 "> 
        <div class="box box-solid">
            <div class="box-header with-border right-side-nav-header">
                <h3 class="box-title">Debtor Detail</h3>
            </div>
            <div class="box-body no-padding">
                <ul class="nav nav-pills nav-stacked">
                    <li ><a href="#" data-toggle="modal" data-target=".email-pop" ><i class="fa fa-envelope-o"></i> Mail  </a></li>
                    <li><a href="#"><i class="fa  fa-building-o"></i> Email template</a></li>
                    <li><a href="#"><i class="fa fa-users"></i> Contact</a> </li>
                    <li><a href="#"><i class="fa fa-filter"></i> Legal </a></li>

                </ul>
            </div><!-- /.box-body -->
        </div>
    </div>
</div>

<div class="modal fade email-pop" role="dialog" aria-labelledby="gridSystemModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="gridSystemModalLabel">Send email</h4>
            </div>
            <div class="modal-body">
                <div class="container-fluid">

                    <div class="row">
                        <div class="col-md-12">



                            {!! Form::open(array('route' => array('debtor.mail.store', $debtor->id), 'autocomplete' => 'off')) !!}



                            <div class="form-group {!! ($errors->has('to')) ? 'has-error' : '' !!}"> 
                                <div class="row">
                                    <div class="col-md-1">
                                        {!! Form::label('to', 'To') !!} 
                                    </div> 
                                    <div class="col-md-8 to-email">
                                        <input type="hidden" class="email-select" id="email-select-id" value="{!! $debtor->email.'&&debtor&&'.$debtor->id !!}" name="to">
                                        <span class="help-block">{!! ($errors->has('to') ? $errors->first('to') : '') !!}</span>
                                    </div> 
                                    <div class="col-md-3">
                                        <div class="radio">
                                            <label>
                                                <input type="radio"  name="to-mail" id="user" value="user" >
                                                User
                                            </label>
                                            <label>
                                                <input type="radio" name="to-mail" id="client" value="client" >
                                                Client
                                            </label> 
                                            <label>
                                                <input type="radio" name="to-mail" id="debtor" value="debtor" checked>
                                                Debtor
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div> 
                            <div class="form-group {!! ($errors->has('cc')) ? 'has-error' : '' !!}"> 
                                <div class="row">
                                    <div class="col-md-1">
                                        {!! Form::label('cc', 'Cc') !!} 
                                    </div> 
                                    <div class="col-md-8">
                                        <input type="hidden" class="email-select" name="cc">
                                        <span class="help-block">{!! ($errors->has('cc') ? $errors->first('cc') : '') !!}</span>
                                    </div> 
                                    <div class="col-md-3">

                                    </div>
                                </div>
                            </div> 
                            <div class="form-group {!! ($errors->has('bcc')) ? 'has-error' : '' !!}"> 
                                <div class="row">
                                    <div class="col-md-1">
                                        {!! Form::label('bcc', 'Bcc') !!} 
                                    </div> 
                                    <div class="col-md-8">
                                        <input type="hidden" class="email-select" name="bcc">
                                        <span class="help-block">{!! ($errors->has('bcc') ? $errors->first('bcc') : '') !!}</span>
                                    </div> 
                                    <div class="col-md-3">

                                    </div>
                                </div>
                            </div>
                            <div class="form-group {!! ($errors->has('subject')) ? 'has-error' : '' !!}"> 
                                <div class="row">
                                    <div class="col-md-1">
                                        {!! Form::label('subject', 'Subject') !!} 
                                    </div> 
                                    <div class="col-md-11">
                                        {!! Form::text('subject', null, array('class' => 'form-control subject', 'placeholder' => 'Eg: payment', 'autocomplete' => 'off')) !!}
                                        {!! ($errors->has('subject') ? $errors->first('subject') : '') !!}
                                    </div>
                                </div>
                            </div>
                            <div class="form-group {!! ($errors->has('content')) ? 'has-error' : '' !!}"> 
                                <div class="row">
                                    <div class="col-md-1">
                                        {!! Form::label('content', 'Content') !!} 
                                    </div> 
                                    <div class="col-md-11">
                                        <textarea class="textarea" name="content" placeholder="Place some text here" style="width: 100%; height: 200px; font-size: 14px; line-height: 18px; border: 1px solid #dddddd; padding: 10px;"></textarea>
                                        {!! ($errors->has('content') ? $errors->first('content') : '') !!}
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer"> 
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary"><i class="fa fa-envelope-o"></i> Send</button>
               
                {!!Form::close()!!} 
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>





@stop
@section('include-js')
@parent

@stop 


<script>
    @section('document-ready-js')
            @parent

            var url = '{!! route("mail.send") !!}';
    var model = 'debtor';
    $('input:radio[name="to-mail"]').change(
            function () {

                if ($(this).is(':checked')) {

                    model = $(this).val();
                }



            });


    $('.email-select').select2({
        width: '100%',
        minimumInputLength: 1,
        tags: true,
        ajax: {
            url: url,
            dataType: 'json',
            quietMillis: 100,
            data: function (term) {

                return {
                    term: term,
                    model: model
                };
            },
            results: function (data) {


                var results = [];
                $.each(data, function (index, item) {

                    if (model == 'user')
                    {
                        results.push({
                            id: item.email + '&&' + model + '&&' + item.id,
                            text: '"' + item.last_name + '" ' + item.email,
                        });
                    }
                    else
                    {
                        results.push({
                            id: item.email + '&&' + model + '&&' + item.id,
                            text: '"' + item.name + '" ' + item.email,
                        });
                    }
                });
                return {
                    results: results
                };
            },
        },
        initSelection: function (element, callback) { 
            console.log('3');
               callback({id: value="{!! $debtor->email.'&&debtor&&'.$debtor->id !!}", text: value="{!! ''.$debtor->name.' '.$debtor->email !!}"});
            } 
    }); 
    
   
    



    @stop

</script>

