@extends('layouts.master')
@section('title')
@parent
Debitor
@stop

@section('content') 
<div class="row">
    <div class="col-sm-12">
        <h4 class="pull-left page-title"> </h4>
        <ol class="breadcrumb pull-right">
            <li><a href="{!! route('home.index') !!}">Dashboard</a></li>
            <li><a href="{!! route('debtor.index') !!}">Debtor</a></li>
            <li class="active">Debtor Add</li>
        </ol>
    </div>
</div> 
<div class="panel panel-default">
    <div class="panel-heading">
        <div class="row"> 
            <div class="col-md-12">
                <div class="panel-heading pull-left">
                    <h3 class="panel-title"> Debtor  Add </h3>
                </div>

                <div class="pull-right">

                </div> 
            </div>
        </div>
    </div><!-- /.box-header -->
    <div class="panel-body">

        {!! Form::open(array('route' => array('debtor.store'), 'autocomplete' => 'off')) !!}   




        <div class="form-group {!! ($errors->has('email')) ? 'has-error' : '' !!}">
            {!! Form::label('email', 'Email') !!}
            {!! Form::text('email', null, array('class' => 'form-control', 'placeholder' => 'Eg: example@example.com', 'autocomplete' => 'off')) !!}
            {!! ($errors->has('email') ? $errors->first('email') : '') !!}
        </div>


        <div class="form-group {!! ($errors->has('name')) ? 'has-error' : '' !!}">
            <div class="row">
                <div class="col-lg-2">

                    <div class="radio">
                        <label>
                            <input type="radio" name="name_type" id="company" value="company" checked>
                            Company
                        </label>
                    </div>


                </div>
                <div class="col-lg-2">
                    <div class="radio">
                        <label>
                            <input type="radio" name="name_type" id="person" value="person">
                            Person
                        </label>
                    </div>
                </div>
            </div>
        </div>
        <div class="form-group personClass {!! ($errors->has('last_name')) ? 'has-error' : '' !!}">
            {!! Form::label('last_name', 'Last Name ') !!}
            {!! Form::text('last_name', null, array('class' => 'form-control', 'placeholder' => 'Eg: Emery')) !!}
            {!! ($errors->has('last_name') ? $errors->first('last_name') : '') !!}
        </div> 
        <div class="form-group personClass {!! ($errors->has('first_name')) ? 'has-error' : '' !!}">
            {!! Form::label('first_name', 'First Name ') !!}
            {!! Form::text('first_name', null, array('class' => 'form-control', 'placeholder' => 'Eg: Emery')) !!}
            {!! ($errors->has('first_name') ? $errors->first('first_name') : '') !!}
        </div> 
        <div class="form-group nameClass {!! ($errors->has('name')) ? 'has-error' : '' !!}">
            {!! Form::label('name', 'Debtor Name ') !!}
            {!! Form::text('name', null, array('class' => 'form-control', 'placeholder' => 'Eg: Emery')) !!}
            {!! ($errors->has('name') ? $errors->first('name') : '') !!}
        </div>  

        <div class="form-group {!! ($errors->has('mailing_address')) ? 'has-error' : '' !!}">
            {!! Form::label('mailing_address', 'Mailing address') !!}
            {!! Form::text('mailing_address', null, array('class' => 'form-control', 'placeholder' => 'Eg: aus')) !!}
            {!! ($errors->has('mailing_address') ? $errors->first('mailing_address') : '') !!}
        </div>   
        <div class="form-group {!! ($errors->has('mailing_suburb')) ? 'has-error' : '' !!}">
            {!! Form::label('mailing_suburb', 'Mailing suburb') !!}
            {!! Form::text('mailing_suburb', null, array('class' => 'form-control', 'placeholder' => 'Eg: aus')) !!}
            {!! ($errors->has('mailing_suburb') ? $errors->first('mailing_suburb') : '') !!}
        </div>
        <div class="form-group {!! ($errors->has('mailing_state')) ? 'has-error' : '' !!}">
            {!! Form::label('mailing_state', 'Mailing state') !!}
            {!! Form::text('mailing_state', null, array('class' => 'form-control', 'placeholder' => 'Eg: aus')) !!}
            {!! ($errors->has('mailing_state') ? $errors->first('mailing_state') : '') !!}
        </div> 
        <div class="form-group {!! ($errors->has('mailing_postcode ')) ? 'has-error' : '' !!}">
            {!! Form::label('mailing_postcode ', 'Mailing postcode ') !!}
            {!! Form::text('mailing_postcode ', null, array('class' => 'form-control', 'placeholder' => 'Eg: aus')) !!}
            {!! ($errors->has('mailing_postcode ') ? $errors->first('mailing_postcode ') : '') !!}
        </div>
    </div>
    <div class="panel-footer"> 

        {!! Form::submit('Create', array('class' => 'btn btn-success')) !!} &nbsp;&nbsp;
        <a href="{!!URL::route('debtor.index')!!}" class="btn btn-default">Cancel</a>
        {!!Form::close()!!} 

    </div>
</div>

@stop
@section('include-js')
@parent

@stop 

<script>
    @section('document-ready-js')
            @parent
            $('.personClass').hide();
    $("input[name='name_type']").click(function () {

        if ($('input:radio[name=name_type]:checked').val() == "company") {
            $('.personClass').hide();
            $('.nameClass').show();
            //$('#select-table > .roomNumber').attr('enabled',false);
        }
        else
        {
            $('.personClass').show();
            $('.nameClass').hide();
        }
    });


    @stop
</script>


