@extends('layouts.master')
@section('title')
@parent
Debtors
@stop

@section('content') 
<div class="row">
    <div class="col-sm-12">
        <h4 class="pull-left page-title"> </h4>
        <ol class="breadcrumb pull-right">
            <li><a href="{!! route('home.index') !!}">Dashboard</a></li>
            <li class="active">Debtor</li>
        </ol>
    </div>
</div> 

<div class="panel panel-default">
    <div class="panel-heading">
        <div class="row"> 
            <div class="col-md-12">
                <div class="panel-heading pull-left">
                    <h3 class="panel-title">Debtor</h3>
                </div>

                <div class="pull-right"> 
                    <a class="btn btn-danger" href="{!! route('debtor.import') !!}" id="select-import-btn" >Import</a> 
                    <button class="btn btn-inverse" id="select-export-btn" > Export</button>
                    <a href="{!! route('debtor.create') !!}" class="btn btn-primary"><span><i class="fa    fa-plus" rel="tooltip" ></i> Add debtor </span> </a>

                </div> 
            </div>
        </div>
    </div><!-- /.box-header -->
    <div class="panel-body table-rep-plugin"> 
        <div class="table-responsive" data-pattern="priority-columns">
            <table id="tech-companies-1" class="table  table-bordered ">


                <thead>
                    <tr>
                        <th style="width: 10px"> 
                            @if(count($orderBy))

                            @if($orderBy['dataId']== 'id')

                            <a href="{!! route('debtor.index').'?orderBy='.$orderBy['orderBy'].'&&dataId=id' !!}" >   <div style="cursor:pointer"  class=" fa {!! $orderBy['icon'] !!}" ></div>  </a>

                            @else 
                            <a href="{!! route('debtor.index').'?orderBy=asc&&dataId=id' !!}" >   <div style="cursor:pointer"  class="fa fa-arrows-v" ></div>  </a>


                            @endif

                            @else 
                            <a href="{!! route('debtor.index').'?orderBy=asc&&dataId=id' !!}" >   <div style="cursor:pointer"  class="fa fa-arrows-v" ></div>  </a>

                            @endif

                        </th> 
                        <th data-priority="1" >
                            @if(count($orderBy))

                            @if($orderBy['dataId']== 'email')

                            <a href="{!! route('debtor.index').'?orderBy='.$orderBy['orderBy'].'&&dataId=email' !!}" >   <div style="cursor:pointer"  class=" fa {!! $orderBy['icon'] !!}" ></div>  </a>

                            @else 
                            <a href="{!! route('debtor.index').'?orderBy=asc&&dataId=email' !!}" >   <div style="cursor:pointer"  class="fa fa-arrows-v" ></div>  </a>


                            @endif

                            @else 
                            <a href="{!! route('debtor.index').'?orderBy=asc&&dataId=email' !!}" >   <div style="cursor:pointer"  class="fa fa-arrows-v" ></div>  </a>

                            @endif
                            Email
                        </th>
                        <th data-priority="1" >Name</th>
                        <th data-priority="1" >
                            @if(count($orderBy))

                            @if($orderBy['dataId']== 'debtor_code')

                            <a href="{!! route('debtor.index').'?orderBy='.$orderBy['orderBy'].'&&dataId=debtor_code' !!}" >   <div style="cursor:pointer"  class=" fa {!! $orderBy['icon'] !!}" ></div>  </a>

                            @else 
                            <a href="{!! route('debtor.index').'?orderBy=asc&&dataId=debtor_code' !!}" >   <div style="cursor:pointer"  class="fa fa-arrows-v" ></div>  </a>


                            @endif

                            @else 
                            <a href="{!! route('debtor.index').'?orderBy=asc&&dataId=debtor_code' !!}" >   <div style="cursor:pointer"  class="fa fa-arrows-v" ></div>  </a>

                            @endif
                            Debtor code
                        </th>
                        <th data-priority="6" >Mailing address</th>
                        <th data-priority="6" >Mailing suburb</th>
                        <th data-priority="1" >Action</th>
                    </tr> 
                </thead>
                @foreach($debtors as $debtor)
                <tbody>
                    @if(in_array( $debtor->email, $importEmail))
                    <tr class="alert alert-info" >
                        @else
                    <tr  >
                        @endif
                        <td>
                             <div class="checkbox checkbox-primary">
                                <input id="checkbox2" class="check-in" data-id="{!! $debtor->id !!}"  data-name="{!! $debtor->debtor_code !!}" name="check" type="checkbox" >
                                <label >

                                </label>
                            </div>

                            
                        </td>
                        <td>{!! $debtor->email !!}</td>  
                        <td>
                            {!! $debtor->name !!}
                        </td>
                        <td>{!! $debtor->debtor_code !!}</td>
                        <td>
                            {!! $debtor->mailing_address !!}
                        </td> 
                        <td>
                            {!! $debtor->mailing_suburb !!}
                        </td>
                        <td> 
                            <a href="{!! route('debtor.show', [$debtor->id]) !!}"><i class="fa  fa-bars" rel="tooltip" title="Detail"></i>  </a>&nbsp;&nbsp;
                            <a href="{!! route('debtor.invoice', [$debtor->id]) !!}"><i class="fa  fa-building-o" rel="tooltip" title="Invoice"></i>  </a>&nbsp;&nbsp;
                            <a href="{!! route('debtor.edit', [$debtor->id]) !!}"><i class="fa  fa-edit" rel="tooltip" title="Edit"></i>  </a>&nbsp;&nbsp; 
                           
                            <a href="{!! route('debtor.delete', [$debtor->id]) !!}"><i class="fa  fa-archive" rel="tooltip" title="Delete"></i>  </a>
                            @if(count($debtor->debtorInvoice2)) 
                           
                            <a href="{!! route('client.debtor.invoice.payment', [$debtor->debtorInvoice2[0]->client_id, $debtor->debtorInvoice2[0]->id]) !!}"><i class="fa  fa-money" rel="tooltip" title="Payment"></i>  </a>&nbsp;&nbsp;
                           
                            @endif
                        </td>
                    </tr> 
                </tbody>
                @endforeach
            </table>
        </div>
    </div><!-- /.box-body -->
    <div class="panel-footer">
        {!! $debtors->render() !!}
    </div>
</div> 

<div class="modal fade bs-example-modal-lg" id="export-pop" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title" id="myLargeModalLabel">Export Debtor</h4>
            </div>
            <div class="modal-body"> 
                {!! Form::open(array('route' => array('debtor.export'), 'autocomplete' => 'off')) !!}  
                <div class="row"> 
                    <div class="col-md-12"> 
                        <p>Export for</p>
                        <div class="radio radio-info radio-inline">
                            <input type="radio" id="inlineRadio1" value="excel" name="exportFor" checked>
                            <label for="inlineRadio1"> Excel </label>
                        </div> 
                        <div class="radio radio-inline">
                            <input type="radio" id="inlineRadio2" value="csv" name="exportFor">
                            <label for="inlineRadio2"> Csv </label>
                        </div> 
                    </div>
                </div>

                <br><br>
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <div class="row"> 
                            <div class="col-md-12">
                                <div class="panel-heading pull-left">
                                    <h3 class="panel-title">Select Field</h3>
                                </div>

                                <div class="pull-right">

                                </div> 
                            </div>
                        </div>
                    </div><!-- /.box-header -->
                    <div class="panel-body"> 
                        <div class="row">
                            @foreach($fields as $key => $field)
                            <div class="col-md-3">
                                <div class="checkbox checkbox-success" rel="tooltip" title="Check all" >
                                    <input id="checkAll" value='{!! $field->db_name !!}' name="field_{!! $key !!}" type="checkbox"  checked>
                                    <label > {!! $field->name !!}
                                    </label>
                                </div>   
                            </div> 
                            @endforeach
                        </div>
                    </div>
                </div> 
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <div class="row"> 
                            <div class="col-md-12">
                                <div class="panel-heading pull-left">
                                    <h3 class="panel-title">Select Field</h3>
                                </div>

                                <div class="pull-right">

                                </div> 
                            </div>
                        </div>
                    </div>
                    <div class="panel-body"> 
                        <div class="row"> 
                            <div class="col-md-12">
                                <p>Select type</p>
                                <div class="radio radio-info radio-inline">
                                    <input type="radio" id="check" value="check" name="select_type" checked>
                                    <label for="check"> Check data</label>
                                </div> 
                                <div class="radio radio-inline">
                                    <input type="radio" id="inlineRadio2" value="all" name="select_type">
                                    <label for="all"> All data</label>
                                </div> 
                            </div>
                        </div> 
                        <div class="row data-add"> 
                        </div> 
                    </div>

                </div>
                {!! Form::submit('Export', array('class' => 'btn btn-success export-close-btn')) !!} &nbsp;&nbsp;

                {!!Form::close()!!} 

            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>

@stop
@section('include-js')
@parent

@stop


    @section('document-ready-js')
            @parent 
            
 $(".panel-default .pagination li a").each(function( index ) { 
 
 var orderBy = getUrlParameter('orderBy');
var dataId = getUrlParameter('dataId'); 
var page = getUrlParameter('page');

if(orderBy != undefined)
{ 
var newUrl = $( this ).attr('href');
if(page == undefined )
{
 
   newUrl = newUrl + '&&orderBy='+orderBy+'&&dataId='+dataId;
   
    $( this ).attr('href', newUrl);
} else 

{
newUrl = newUrl + 'orderBy='+orderBy+'&&dataId='+dataId; 
 $( this ).attr('href', newUrl);
}



}

});
            $('#checkAll').change(function () {
    if ($(this).is(":checked")) {
    $('.check-in').prop('checked', true);
    }
    else
    {
    $('.check-in').prop('checked', false);
    }

    });
            $("body").on("click", "#select-export-btn", function () {
    $(".data-add").empty();
            $(".table-rep-plugin .check-in").each(function () {
    if ($(this).is(":checked")) {

    console.log($(this).attr('data-id'));
            var dataHtml = '<div class="col-md-3">'
            + '<div class="checkbox checkbox-success" rel="tooltip" title="Check all" >'
            + '<input id="checkAll" value=' + $(this).attr('data-id') + ' name="export_' + $(this).attr('data-id') + '" type="checkbox"  checked>'
            + '<label >' + $(this).attr('data-name')
            + '</label>'
            + '</div>';
            $(".data-add").append(dataHtml);
    }
    });
            $('#export-pop').modal('show');
    });
            $("#export-pop input[name='select_type']").click(function () {

    if ($('input:radio[name=select_type]:checked').val() == "check") {

    //$('#select-table > .roomNumber').attr('enabled',false); 
    check();
    }
    else
    {
    all();
    }
    });
            function all()
            {
            $(".data-add").empty();
                    $.ajax({
                    url: '{!! route('debtor.index') !!}',
                            data: {
                            data_all: 'json'
                            },
                            type: 'GET',
                            dataType: 'json',
                            success: function (data) {

                            $.each(data, function (index, item) {

                            console.log(item.registered_name);
                                    var dataHtml = '<div class="col-md-3">'
                                    + '<div class="checkbox checkbox-success" rel="tooltip" title="Check all" >'
                                    + '<input id="checkAll" value=' + item.id + ' name="export_' + item.id + '" type="checkbox"  checked>'
                                    + '<label  >' + item.debtor_code
                                    + '</label>'
                                    + '</div>';
                                    $(".data-add").append(dataHtml);
                            });
                            },
                    });
            }

    function check()
    {

    $(".data-add").empty();
            $(".table-rep-plugin .check-in").each(function () {
    if ($(this).is(":checked")) {

    console.log($(this).attr('data-id'));
            var dataHtml = '<div class="col-md-3">'
            + '<div class="checkbox checkbox-success" rel="tooltip" title="Check all" >'
            + '<input id="checkAll" value=' + $(this).attr('data-id') + ' name="export_' + $(this).attr('data-id') + '" type="checkbox"  checked>'
            + '<label >' + $(this).attr('data-name')
            + '</label>'
            + '</div>';
            $(".data-add").append(dataHtml);
    }
    });
    }
    $("body").on("click", ".export-close-btn", function () {
    $('#export-pop').modal('toggle');
    });

     function getUrlParameter(sParam) {
    var sPageURL = decodeURIComponent(window.location.search.substring(1)),
        sURLVariables = sPageURL.split('&'),
        sParameterName,
        i;

    for (i = 0; i < sURLVariables.length; i++) {
        sParameterName = sURLVariables[i].split('=');

        if (sParameterName[0] === sParam) {
            return sParameterName[1] === undefined ? true : sParameterName[1];
        }
    }
}
    
            @stop


