@extends('layouts.master')
@section('title')
@parent
Payments
@stop

@section('content')
<div class="box">
    <div class="box-header">
        <h3 class="box-title">Payments </h3> 
        <div class="btn-group pull-right">
            {!! link_to_route('client.debtor.invoice.payment.create' , 'Add payment', [$invoice->client_id, $invoice->id], ['class' => 'btn btn-success btn-create']) !!}
        </div>
    </div><!-- /.box-header -->
    <div class="box-body">  
         <div class="nav-tabs-custom">
            @include('clients/nav')
            <div class="tab-content">

                <!-- /.tab-pane -->

                <div class="tab-pane active" >
        
        <table class="table table-bordered">
            <tr>
                <th style="width: 10px">#</th>
                <th>Payment type </th>
                <th>Amount</th>
               
                <th >Action</th>
            </tr> 

            @foreach($payments as $payment)

            <tr>
                <td></td>
                <td>{!!$payment->payment_type !!}</td>
                <td>{!! $payment->amount !!}</td>
                
                <td>
                    {!! link_to_route('client.debtor.invoice.payment.edit', 'Edit', [$payment->id], ['role' => 'menuitem', 'class'=>'btn btn-info']) !!}


                </td>
            </tr>
            @endforeach
        </table>  
                </div>
            </div>
         </div>
    </div><!-- /.box-body -->
    <div class="box-footer clearfix">
        {!! $payments->render() !!}
    </div>
</div>

@stop
@section('include-js')
@parent

@stop

