@extends('layouts.master')
@section('title')
    @parent
    Debtor detail
@stop
@section('content')
    <div class="row">
        <div class="col-sm-12">
            <h4 class="pull-left page-title"> </h4>
            <ol class="breadcrumb pull-right">
                <li><a href="{!! route('home.index') !!}">Dashboard</a></li>
                <li><a href="{!! route('debtor.index') !!}">Debtor</a></li>
                <li class="active">Debtor {!! $debtor->name !!} View</li>
            </ol>
        </div>
    </div>
    <div class="row">
        @if(isset($debtor->debtorInvoice2[0]) && $debtor->debtorInvoice2[0]->invoice_status_code_id != 18)
            <div class="col-md-9 ">
                @endif
                <div class="panel panel-primary">
                    <div class="panel-heading">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="panel-heading pull-left">
                                    <h3 class="panel-title"> Debtor  Detail </h3>
                                </div>

                                <div class="pull-right">

                                </div>
                            </div>
                        </div>
                    </div><!-- /.box-header -->
                    <div class="panel-body">
                        <div class="pull-right">
                            @if(count($debtor->debtorInvoice2) > 0)



                                <a class="btn btn-info" href="{!! route('debtor.edit', [$debtor->id]) !!}"> Edit </a>&nbsp;&nbsp;

                                <a class="btn btn-inverse"  href="{!! route('client.debtor.invoice.show', [$debtor->clientDetail()->id, $debtor->debtorInvoice2[0]->id]) !!}"> Debtor Invoice </a>

                                <a class="btn btn-primary" href="{!! route('client.debtor.invoice.payment', [$debtor->debtorInvoice2[0]->client_id, $debtor->debtorInvoice2[0]->id]) !!}"> Payment </a>&nbsp;&nbsp;

                            @endif

                        </div>
                        <div >
                            &nbsp;&nbsp;
                        </div>
                        <br> <br>
                        <table class="table table-bordered detail-table">
                            <tr class="detail-header">
                                <th class="" colspan="4" > Debtor information </th>
                            </tr>
                            <tr>
                                <td class="detail-content-label">Name :</td>
                                <td class="detail-content-value">{!! $debtor->name !!}</td>
                                <td class="detail-content-label">Mailing suburb :</td>
                                <td class="detail-content-value" >{!! $debtor->mailing_suburb !!}</td>
                            </tr>
                            <tr>

                                <td class="detail-content-label"> Debtor code : </td>
                                <td class="detail-content-value">{!! $debtor->debtor_code !!}</td>


                                <td class="detail-content-label"> Mailing address: </td>
                                <td class="detail-content-value" >{!! $debtor->mailing_address !!}</td>
                            </tr>
                            <tr>
                                <td class="detail-content-label"> Email:

                                </td>
                                <td class="detail-content-value" >{!! $debtor->email !!}

                                </td>


                                <td class="detail-content-label">Mailing postcode:</td>
                                <td class="detail-content-value" >{!! $debtor->mailing_postcode !!}</td>

                            </tr>
                            <tr>
                                <td class="detail-content-label">

                                    Contact Number
                                </td>
                                <td class="detail-content-value" >

                                    {!! $debtor->contact_number !!}
                                </td>


                                <td class="detail-content-label"></td>
                                <td class="detail-content-value" ></td>

                            </tr>
                            @php
                                $clientDetail = $debtor->clientDetail();
                            @endphp

                            @if(!is_null($clientDetail))
                                <tr>
                                    <td class="detail-content-label"> <a href="{!! route('client.debtor.show', [$debtor->clientDetail()->id, $debtor->id]) !!}">Client Code: </a> </td>
                                    <td class="detail-content-value" >{!! $debtor->clientDetail()->client_code !!}</td>


                                    <td class="detail-content-label">Client Name:</td>
                                    <td class="detail-content-value" >{!! $debtor->clientDetail()->name !!}</td>

                                </tr>
                            @endif
                        </table>
                    </div>
                    @if(count($debtor->debtorInvoice2) > 0)
                        <div class="panel panel-default">
                            <div class="panel-heading">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="panel-heading pull-left">
                                            <h3 class="panel-title"> Debtor Invoice Detail </h3>
                                        </div>

                                        <div class=" pull-right">

                                        </div>
                                    </div>
                                </div>
                            </div><!-- /.box-header -->
                            <div class="panel-body">
                                <table class="table table-bordered detail-table">

                                    <tr>
                                        <td class="detail-content-label">Original Debt :</td>
                                        <td class="detail-content-value">{!! $debtor->debtorInvoice2[0]->original_debt !!}</td>
                                        <td class="detail-content-label">Paid/Recovery( paid till date) :</td>
                                        <td class="detail-content-value" ></td>
                                    </tr>
                                    <tr>

                                        <td class="detail-content-label"> Current debt : </td>
                                        <td class="detail-content-value">{!! $debtor->debtorInvoice2[0]->current_balance !!}</td>


                                        <td class="detail-content-label"> <a href="{!! route('client.debtor.invoice.show', [$debtor->clientDetail()->id, $debtor->debtorInvoice2[0]->id]) !!}"> Invoice Number </a></td>
                                        <td class="detail-content-value" >{!! $debtor->debtorInvoice2[0]->invoice_code !!}</td>

                                    </tr>
                                    <tr>

                                        <td class="detail-content-label"> Reference 1: </td>
                                        <td class="detail-content-value">{!! $debtor->debtorInvoice2[0]->reference1 !!}</td>


                                        <td class="detail-content-label">Last Action(Letter) code </td>
                                        <td class="detail-content-value" >{!! $debtor->debtorInvoice2[0]->last_action !!}</td>

                                    </tr>
                                    <tr>

                                        <td class="detail-content-label"> Reference 2   </td>
                                        <td class="detail-content-value">{!! $debtor->debtorInvoice2[0]->reference2 !!}</td>


                                        <td class="detail-content-label"> 1st Prev. Action(Letter) Code </td>
                                        <td class="detail-content-value" >{!! $debtor->debtorInvoice2[0]->action_1st_letter_code !!}</td>

                                    </tr>
                                    <tr>

                                        <td class="detail-content-label"> Reference 3 </td>
                                        <td class="detail-content-value">{!! $debtor->debtorInvoice2[0]->reference3 !!}</td>


                                        <td class="detail-content-label"> 2nd Prev. Action(Letter) Code</td>
                                        <td class="detail-content-value" >{!! $debtor->debtorInvoice2[0]->action_2nd_letter_code !!}</td>

                                    </tr>
                                    <tr>

                                        <td class="detail-content-label"> Reference 4</td>
                                        <td class="detail-content-value">{!! $debtor->debtorInvoice2[0]->reference4 !!}</td>


                                        <td class="detail-content-label">3rd Prev. Action(Letter) Code </td>
                                        <td class="detail-content-value" >{!! $debtor->debtorInvoice2[0]->action_3rd_letter_code  !!}</td>

                                    </tr>
                                    <tr>

                                        <td class="detail-content-label"> Reference 5</td>
                                        <td class="detail-content-value">{!! $debtor->debtorInvoice2[0]->reference5 !!}</td>


                                        <td class="detail-content-label">  </td>
                                        <td class="detail-content-value" ></td>

                                    </tr>
                                    <tr>

                                        <td class="detail-content-label"> Debt Type</td>
                                        <td class="detail-content-value" >
                                            @if($debtor->debtorInvoice2[0]->debt_type_id  != 0)
                                                {!! $debtor->debtorInvoice2[0]->debtType->code !!}
                                            @else
                                                {!! $debtor->debtorInvoice2[0]->details_debt_code !!}
                                            @endif

                                        </td>


                                        <td class="detail-content-label"> Status Code </td>
                                        <td class="detail-content-value" >
                                            @if($debtor->debtorInvoice2[0]->invoice_status_code_id  != 0)
                                                {!! $debtor->debtorInvoice2[0]->invoiceStatusCode->code !!}
                                            @else
                                                {!! $debtor->debtorInvoice2[0]->status_code !!}
                                            @endif

                                        </td>

                                    </tr>





                                </table>


                            </div>
                        </div>
                    @endif
                    @include('debtors/menu/footerMenu')
                </div>
            </div>
            @if(isset($debtor->debtorInvoice2[0]) && $debtor->debtorInvoice2[0]->invoice_status_code_id != 18)
                <div class="col-md-3 ">
                    <div class="panel panel-color panel-primary p-0  m-t-20">
                        <div class="panel-heading">
                            <h3 class="panel-title">Panel Primary</h3>
                        </div>
                        <div class="panel-body p-0">
                            <div class="list-group mail-list">
                                <a href="#" data-toggle="modal" class="list-group-item no-border" data-target=".email-pop" ><i class="fa fa-envelope-o"></i> Mail  </a>
                                <a href="#" class="list-group-item no-border" ><i class="fa  fa-building-o"></i> Email template</a>
                                <a href="#" class="list-group-item no-border" ><i class="fa fa-users"></i> Contact</a>
                                <a href="#"  class="list-group-item no-border" ><i class="fa fa-filter"></i> Legal </a>
                                <a href="{!! route('calendar.call.debtor.create', [$debtor->id]) !!}" class="list-group-item no-border" ><i class="fa fa-phone"></i> Add Call </a>
                                <a href="{!! route('calendar.todo.debtor.create', [$debtor->id]) !!}"  class="list-group-item no-border"  ><i class="fa fa-tasks"></i> Add ToDo </a>
                            </div>
                        </div>
                    </div>

                </div>
            @endif
    </div>
    <div class="modal fade email-pop" role="dialog" aria-labelledby="gridSystemModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="gridSystemModalLabel">Send email</h4>
                </div>
                <div class="modal-body">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-md-12">
                                {!! Form::open(array('route' => array('debtor.mail.store', $debtor->id), 'autocomplete' => 'off')) !!}
                                <div class="form-group {!! ($errors->has('to')) ? 'has-error' : '' !!}">
                                    <div class="row">
                                        <div class="col-md-1">
                                            {!! Form::label('to', 'To') !!}
                                        </div>
                                        <div class="col-md-8 to-email">
                                            <input type="hidden" class="email-select" id="email-select-id" value="{!! $debtor->email.'&&debtor&&'.$debtor->id !!}" name="to">
                                            <span class="help-block">{!! ($errors->has('to') ? $errors->first('to') : '') !!}</span>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="radio">
                                                <label>
                                                    <input type="radio"  name="to-mail" id="user" value="user" >
                                                    User
                                                </label>
                                                <label>
                                                    <input type="radio" name="to-mail" id="client" value="client" >
                                                    Client
                                                </label>
                                                <label>
                                                    <input type="radio" name="to-mail" id="debtor" value="debtor" checked>
                                                    Debtor
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group {!! ($errors->has('cc')) ? 'has-error' : '' !!}">
                                    <div class="row">
                                        <div class="col-md-1">
                                            {!! Form::label('cc', 'Cc') !!}
                                        </div>
                                        <div class="col-md-8">
                                            <input type="hidden" class="email-select" name="cc">
                                            <span class="help-block">{!! ($errors->has('cc') ? $errors->first('cc') : '') !!}</span>
                                        </div>
                                        <div class="col-md-3">

                                        </div>
                                    </div>
                                </div>
                                <div class="form-group {!! ($errors->has('bcc')) ? 'has-error' : '' !!}">
                                    <div class="row">
                                        <div class="col-md-1">
                                            {!! Form::label('bcc', 'Bcc') !!}
                                        </div>
                                        <div class="col-md-8">
                                            <input type="hidden" class="email-select" name="bcc">
                                            <span class="help-block">{!! ($errors->has('bcc') ? $errors->first('bcc') : '') !!}</span>
                                        </div>
                                        <div class="col-md-3">

                                        </div>
                                    </div>
                                </div>
                                <div class="form-group {!! ($errors->has('subject')) ? 'has-error' : '' !!}">
                                    <div class="row">
                                        <div class="col-md-1">
                                            {!! Form::label('subject', 'Subject') !!}
                                        </div>
                                        <div class="col-md-11">
                                            {!! Form::text('subject', null, array('class' => 'form-control subject', 'placeholder' => 'Eg: payment', 'autocomplete' => 'off')) !!}
                                            {!! ($errors->has('subject') ? $errors->first('subject') : '') !!}
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group {!! ($errors->has('content')) ? 'has-error' : '' !!}">
                                    <div class="row">
                                        <div class="col-md-1">
                                            {!! Form::label('content', 'Content') !!}
                                        </div>
                                        <div class="col-md-11">
                                            <textarea class="textarea" name="content" placeholder="Place some text here" style="width: 100%; height: 200px; font-size: 14px; line-height: 18px; border: 1px solid #dddddd; padding: 10px;"></textarea>
                                            {!! ($errors->has('content') ? $errors->first('content') : '') !!}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary"><i class="fa fa-envelope-o"></i> Send</button>
                    {!!Form::close()!!}
                </div>
            </div><!-- /.modal-content -->
        </div><!-- /.modal-dialog -->
    </div>
@stop
@section('include-js')
    @parent
@stop

@section('document-ready-js')
    @parent
    var url = '{!! route("mail.send") !!}';
    var model = 'debtor';
    $('input:radio[name="to-mail"]').change(
    function () {

    if ($(this).is(':checked')) {

    model = $(this).val();
    }
    });
    $('.email-select').select2({
    width: '100%',
    minimumInputLength: 1,
    tags: true,
    ajax: {
    url: url,
    dataType: 'json',
    quietMillis: 100,
    data: function (term) {
    return {
    term: term,
    model: model
    };
    },
    results: function (data) {
    var results = [];
    $.each(data, function (index, item) {

    if (model == 'user')
    {
    results.push({
    id: item.email + '&&' + model + '&&' + item.id,
    text: '"' + item.last_name + '" ' + item.email,
    });
    }
    else
    {
    results.push({
    id: item.email + '&&' + model + '&&' + item.id,
    text: '"' + item.name + '" ' + item.email,
    });
    }
    });
    return {
    results: results
    };
    },
    },
    initSelection: function (element, callback) {
    console.log('3');
    callback({id: value = "{!! $debtor->email.'&&debtor&&'.$debtor->id !!}", text: value = "{!! ''.$debtor->name.' '.$debtor->email !!}"});
    }
    });
@stop
