@extends('layouts.master')
@section('title')
@parent
Email template
@stop

@section('content')
<div class="box">
    <div class="box-header">
        <h3 class="box-title">Email template create</h3>
    </div><!-- /.box-header -->
    <div class="box-body">
        {!! Form::open(array('route' => array('emailTemplate.store'), 'autocomplete' => 'off')) !!}

        <div class="form-group {!! ($errors->has('name')) ? 'has-error' : '' !!}">
            {!! Form::label('name', 'Template Name') !!}
            {!! Form::text('name', null, array('class' => 'form-control', 'placeholder' => 'Template name', 'autocomplete' => 'off')) !!}
            {!! ($errors->has('name') ? $errors->first('name') : '') !!}
        </div>
        
        <div class="form-group {!! ($errors->has('subject')) ? 'has-error' : '' !!}">
            {!! Form::label('subject', 'Subject') !!}
            {!! Form::text('subject', null, array('class' => 'form-control', 'placeholder' => 'Email subject', 'autocomplete' => 'off')) !!}
            {!! ($errors->has('subject') ? $errors->first('subject') : '') !!}
        </div>
        
        <div class="form-group {!! ($errors->has('content')) ? 'has-error' : '' !!}">
            {!! Form::label('content', 'Content') !!}
            {!! Form::textarea('content', null, array('class' => 'form-control', 'placeholder' => 'Email content', 'autocomplete' => 'off')) !!}
            {!! ($errors->has('content') ? $errors->first('content') : '') !!}
        </div>
        
       
      
    </div>
    <div class="box-footer clearfix"> 
        <div class=" pull-right">
            {!! Form::submit('Create', array('class' => 'btn btn-success')) !!} &nbsp;&nbsp;
            <a href="{!!URL::route('emailTemplate.index')!!}" class="btn btn-default">Cancel</a>
            {!!Form::close()!!} 
        </div>
    </div>
</div>

@stop
@section('include-js')
@parent

@stop

