@extends('layouts.master')
@section('title')
@parent
Email template edit
@stop

@section('content')
<div class="box">
    <div class="box-header">
        <h3 class="box-title">Email template edit</h3>
    </div><!-- /.box-header -->
    <div class="box-body">
        {!! Form::model($emailTemplate, ['method' => 'PATCH', 'route' => ['emailTemplate.update', $emailTemplate->id]]) !!}

       
        <div class="form-group {!! ($errors->has('name')) ? 'has-error' : '' !!}">
            {!! Form::label('name', 'Template Name') !!}
            {!! Form::text('name', null, array('class' => 'form-control', 'placeholder' => 'Template name', 'autocomplete' => 'off')) !!}
            {!! ($errors->has('name') ? $errors->first('name') : '') !!}
        </div>
        
        <div class="form-group {!! ($errors->has('subject')) ? 'has-error' : '' !!}">
            {!! Form::label('subject', 'Subject') !!}
            {!! Form::text('subject', null, array('class' => 'form-control', 'placeholder' => 'Email subject', 'autocomplete' => 'off')) !!}
            {!! ($errors->has('subject') ? $errors->first('subject') : '') !!}
        </div>
        
        <div class="form-group {!! ($errors->has('content')) ? 'has-error' : '' !!}">
            {!! Form::label('content', 'Content') !!}
            {!! Form::textarea('content', null, array('class' => 'form-control', 'placeholder' => 'Email content', 'autocomplete' => 'off')) !!}
            {!! ($errors->has('content') ? $errors->first('content') : '') !!}
        </div>
       <div class="form-group {!! ($errors->has('deleted')) ? 'has-error' : '' !!}">
           {!! Form::label('deleted', 'State', ['class' => 'control-label']) !!}
           {!!  Form::select('deleted',  [ '1'=>'Not Active', '0'=>'Active'], $emailTemplate->deleted ,['class' => 'form-control', 'placeholder' => 'state', 'required'])  !!}
            <span class="help-block">{!! ($errors->has('deleted') ? $errors->first('deleted') : '') !!}</span>
       </div>
    </div>
    <div class="box-footer clearfix"> 
        <div class=" pull-right">
            {!! Form::submit('Update', array('class' => 'btn btn-info')) !!} &nbsp;&nbsp;
            <a href="{!!URL::route('emailTemplate.index')!!}" class="btn btn-default">Cancel</a>
            {!!Form::close()!!} 
        </div>
    </div>
</div>

@stop
@section('include-js')
@parent

@stop

