@extends('layouts.master')
@section('title')
@parent
Email templateuration
@stop

@section('content')
<div class="box">
    <div class="box-header">
        <h3 class="box-title">Email templateuration</h3> 
        <div class="btn-group pull-right">
            {!! link_to_route('emailTemplate.create' , 'Add email template', [], ['class' => 'btn btn-success btn-create']) !!}
        </div>
    </div><!-- /.box-header -->
    <div class="box-body">
        <table class="table table-bordered">
            <tr>
                <th style="width: 10px">#</th>
                <th>Name</th> 
                  <th>Subject</th>
                <th>State</th>

                <th >Action</th>
            </tr> 

            @foreach($emailTemplates as $emailTemplate)

            <tr>
                <td></td>
                <td>{!!$emailTemplate->name !!}</td>
                <td>{!!$emailTemplate->subject !!}</td>
                <td>@if($emailTemplate->deleted === 0)
                        Active
                    @else
                        Not Active
                    @endif</td> 
               
                <td>

                    <a href="{!! route('emailTemplate.edit', [$emailTemplate->id]) !!}"><i class="fa  fa-edit" rel="tooltip" title="Edit"></i>  </a>&nbsp;&nbsp;
                    <a href="{!! route('emailTemplate.delete', [$emailTemplate->id]) !!}"><i class="fa  fa-archive" rel="tooltip" title="Delete"></i>  </a>


                </td>
            </tr>
            @endforeach
        </table>
    </div><!-- /.box-body -->
    <div class="box-footer clearfix">
        {!! $emailTemplates->render() !!}
    </div>
</div>

@stop
@section('include-js')
@parent

@stop

