@extends('layouts.master')
@section('title')
@parent
group create
@stop

@section('content')
<div class="box">
    <div class="box-header">
        <h3 class="box-title"></h3>
    </div><!-- /.box-header -->
    <div class="box-body">  
        <div class="nav-tabs-custom">
            @include('users/nav')
            <div class="tab-content">
                <div class="tab-pane active"> 

                    <div class="box box-info">
                        <div class="box-header">
                            <h3 class="box-title">Group create</h3>
                        </div> 
                        <div class="box-body">

                             
                             {!! Form::open(array('route' => array('group.store'), 'autocomplete' => 'off')) !!}
                            <div class="form-group {!! ($errors->has('name')) ? 'has-error' : '' !!}"> 
                                <div class="row">
                                    <div class="col-md-2">
                                {!! Form::label('name', 'Group name') !!} 
                                    </div> 
                                     <div class="col-md-6">
                                {!! Form::text('name', '', array('class' => 'form-control', 'placeholder' => 'Group Name')) !!}
                                {!! ($errors->has('name') ? $errors->first('name') : '') !!}
                                     </div>
                                     </div>
                                </div> 
                            <div class="table-responsive">
                                <table class="table table-striped table-header-rotated">
                                    <thead> 
                                        <tr> 
                                            <th></th>
                                            @foreach($actions as $action)
                                            <th class="rotate-45"><div><span>{!!$action->name!!}</span></div></th>
                                    @endforeach
                                    </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($models as $model)
                                        <tr>
                                            <td>{!!$model->name!!}</td>
                                            @foreach($actions as $action)
                                            <td>
                                                @if($model->actions->find($action->id))    
                                               
                                                {!! Form::checkbox($model->name.'.'.$action->name), '' !!}
                                               
                                                @endif
                                            </td>
                                            @endforeach
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>  
                            </div> 

                        </div>
                    </div>


                </div>
            </div>
        </div>
    </div>
    <div class="box-footer clearfix"> 
        <div class=" pull-right">
            {!! Form::submit('Add New Group', array('class' => 'btn btn-success')) !!}
            <a href="{!!URL::route('group.index')!!}" class="btn btn-default">Cancel</a>
            {!!Form::close()!!} 
        </div>
    </div>
</div>

@stop
@section('include-js')
@parent

@stop

