@extends('layouts.master')
@section('title')
@parent
debtor edit
@stop

@section('content')
<div class="box">
    <div class="box-header">
        <h3 class="box-title">Debtors edit</h3>
    </div><!-- /.box-header -->
    <div class="box-body">
        {!! Form::model($debtor, ['method' => 'PATCH', 'route' => ['debtor.update', $debtor->id]]) !!}

        <div class="form-group {!! ($errors->has('email')) ? 'has-error' : '' !!}">
            {!! Form::label('email', 'Email') !!}
            {!! Form::text('email', null, array('class' => 'form-control', 'placeholder' => 'Eg: example@example.com', 'autocomplete' => 'off', 'readonly')) !!}
            {!! ($errors->has('email') ? $errors->first('email') : '') !!}
        </div>
      
        <div class="form-group {!! ($errors->has('debtor_code')) ? 'has-error' : '' !!}">
            {!! Form::label('debtor_code', 'Code') !!}
            {!! Form::text('debtor_code', null, array('class' => 'form-control', 'placeholder' => 'Eg: Ryan')) !!}
            {!! ($errors->has('debtor_code') ? $errors->first('debtor_code') : '') !!}
        </div> 
        <div class="form-group {!! ($errors->has('name')) ? 'has-error' : '' !!}">
            {!! Form::label('name', 'Name') !!}
            {!! Form::text('name', null, array('class' => 'form-control', 'placeholder' => 'Eg: Emery')) !!}
            {!! ($errors->has('name') ? $errors->first('name') : '') !!}
        </div> 
        <div class="form-group {!! ($errors->has('address')) ? 'has-error' : '' !!}">
            {!! Form::label('address', 'Address') !!}
            {!! Form::text('address', null, array('class' => 'form-control', 'placeholder' => 'Eg: Emery')) !!}
            {!! ($errors->has('address') ? $errors->first('address') : '') !!}
        </div>  
        <div class="form-group {!! ($errors->has('account_state')) ? 'has-error' : '' !!}">
           {!! Form::label('account_state', 'Account state', ['class' => 'control-label']) !!}
           {!!  Form::select('account_state',  [ 'disable'=>'Disable', 'enable'=>'Enable'], null  ,['class' => 'form-control', 'placeholder' => 'account_state', 'required'])  !!}
            <span class="help-block">{!! ($errors->has('account_state') ? $errors->first('account_state') : '') !!}</span>
       </div> 
         <div class="form-group {!! ($errors->has('follow_up')) ? 'has-error' : '' !!}">
            {!! Form::label('follow_up', 'Follow up') !!}
            {!! Form::text('follow_up', null, array('class' => 'form-control', 'placeholder' => 'Eg: Emery')) !!}
            {!! ($errors->has('follow_up') ? $errors->first('follow_up') : '') !!}
        </div> 
         <div class="form-group {!! ($errors->has('original_debt')) ? 'has-error' : '' !!}">
            {!! Form::label('original_debt', 'Original debt') !!}
            {!! Form::text('original_debt', null, array('class' => 'form-control', 'placeholder' => 'Eg: example@example.com', 'autocomplete' => 'off')) !!}
            {!! ($errors->has('original_debt') ? $errors->first('original_debt') : '') !!}
        </div> 
        <div class="form-group {!! ($errors->has('current_balance')) ? 'has-error' : '' !!}">
            {!! Form::label('current_balance', 'Current balance') !!}
            {!! Form::text('current_balance', null, array('class' => 'form-control', 'placeholder' => 'Eg: example@example.com', 'autocomplete' => 'off')) !!}
            {!! ($errors->has('current_balance') ? $errors->first('current_balance') : '') !!}
        </div>  
         <div class="form-group {!! ($errors->has('last_payment')) ? 'has-error' : '' !!}">
            {!! Form::label('last_payment', 'Last payment') !!}
            {!! Form::text('last_payment', null, array('class' => 'form-control', 'placeholder' => 'Eg: example@example.com', 'autocomplete' => 'off')) !!}
            {!! ($errors->has('last_payment') ? $errors->first('last_payment') : '') !!}
        </div> 
         <div class="form-group {!! ($errors->has('last_paid')) ? 'has-error' : '' !!}">
            {!! Form::label('last_paid', 'Last paid') !!}
            {!! Form::text('last_paid', null, array('class' => 'form-control', 'placeholder' => 'Eg: example@example.com', 'autocomplete' => 'off')) !!}
            {!! ($errors->has('last_paid') ? $errors->first('last_paid') : '') !!}
        </div>
    </div>
    <div class="box-footer clearfix"> 
        <div class=" pull-right">
            {!! Form::submit('Update', array('class' => 'btn btn-info')) !!} &nbsp;&nbsp;
            <a href="{!!URL::route('debtor.index')!!}" class="btn btn-default">Cancel</a>
            {!!Form::close()!!} 
        </div>
    </div>
</div>

@stop
@section('include-js')
@parent

@stop

