@extends('layouts.master')
@section('title')
@parent
Debtor invoice
@stop

@section('content') 

<div class="row">
    <div class="col-sm-12">
        <h4 class="pull-left page-title"> </h4>
        <ol class="breadcrumb pull-right">
            <li><a href="{!! route('home.index') !!}">Dashboard</a></li>
            <li><a href="{!! URL::route('debtor.index') !!}">Debtor</a></li> 
            <li><a href="{!! URL::route('debtor.show', [$debtor->id]) !!}">{!! $debtor->name !!}</a></li> 

            <li><a href="{!! URL::route('debtor.invoice', [$debtor->id]) !!}">invoice</a></li> 
            <li class="active">{!! $invoice->invoice_code !!}</li>

        </ol>
    </div>
</div> 


<div class="row"> 
    <div class="col-md-9">
        <div class="panel panel-primary">
            <div class="panel-heading">
                <div class="row"> 
                    <div class="col-md-12">
                        <div class="panel-heading pull-left">
                            <h3 class="panel-title"> Debtor invoice detail </h3>
                        </div>

                        <div class="pull-right">

                        </div> 
                    </div>
                </div>
            </div>
            <div class="panel-body">
                <table class="table table-bordered detail-table">
                    
                    <tr>
                        <td class="detail-content-label">Invoice code :</td>
                        <td class="detail-content-value">{!! $invoice->invoice_code !!}</td>
                        <td class="detail-content-label"> Client  : </td>
                        <td class="detail-content-value">{!! ($invoice->client)? $invoice->client->name : '' !!}</td>
                    </tr> 
                    <tr>

                        <td class="detail-content-label"> Invoice date : </td>
                        <td class="detail-content-value" >{!! $invoice->invoice_date !!}</td> 
                        <td class="detail-content-label">Invoice state:</td>
                        <td class="detail-content-value" >{!! $invoice->invoice_state !!}</td>
                    </tr>  
                    <tr>

                        <td class="detail-content-label"> Account state  : </td>
                        <td class="detail-content-value" >{!! $invoice->account_state !!}</td> 
                        <td class="detail-content-label">Follow up :</td>
                        <td class="detail-content-value" >{!! ($invoice->user)? $invoice->user->last_name.' '.$invoice->user->first_name : ''  !!}</td>

                    </tr>  



                </table>


            </div>
        </div>
        <div class="panel panel-primary">
            <div class="panel-heading">
                <div class="row"> 
                    <div class="col-md-12">
                        <div class="panel-heading pull-left">
                            <h3 class="panel-title"> Acount detail Details </h3>
                        </div>

                        <div class="pull-right">

                        </div> 
                    </div>
                </div>
            </div>
            <div class="panel-body"> 
                <table class="table table-bordered detail-table">

                    <tr>
                        <td class="detail-content-label">Original debt :</td>
                        <td class="detail-content-value">{!! $invoice->original_debt !!}</td>
                        <td class="detail-content-label"> Current balance : </td>
                        <td class="detail-content-value">{!! $invoice->current_balance !!}</td>
                    </tr>
                    <tr>
                        <td class="detail-content-label">Total paid :</td>
                        <td class="detail-content-value" >{!! $invoice->total_paid !!}</td>
                        <td class="detail-content-label"> Last payment: </td>
                        <td class="detail-content-value" >{!! $invoice->last_payment !!}</td>
                    </tr>  
                    <tr>
                        <td class="detail-content-label">Last paid </td>
                        <td class="detail-content-value" >{!! $invoice->last_paid !!}</td>
                        <td class="detail-content-label"> Solicitor costs to date : </td>
                        <td class="detail-content-value" >{!! $invoice->solicitor_cost_date !!}</td>
                    </tr> 
                    <tr>
                        <td class="detail-content-label">Recoverable costs to date </td>
                        <td class="detail-content-value" >{!! $invoice->recoverable_cost_date !!}</td>
                        <td class="detail-content-label"> Non recoverable costs date: </td>
                        <td class="detail-content-value" >{!! $invoice->non_recoverable_cost_date !!}</td>
                    </tr>  
                    <tr>
                        <td class="detail-content-label">Debt recovered to date </td>
                        <td class="detail-content-value" >{!! $invoice->debt_recovered_date !!}</td>
                        <td class="detail-content-label"> costs recovered to date : </td>
                        <td class="detail-content-value" >{!! $invoice->costs_recovered_date !!}</td>
                    </tr>  


                </table>

            </div> 


        </div>   

        @if($invoice->invoice_state =='legal action')
        <div class="panel panel-primary">
            <div class="panel-heading">
                <div class="row"> 
                    <div class="col-md-12">
                        <div class="panel-heading pull-left">
                            <h3 class="panel-title"> Legal arrangement </h3>
                        </div>

                        <div class="pull-right">

                        </div> 
                    </div>
                </div>
            </div>
            <div class="panel-body">  
                <table class="table table-bordered detail-table">

                    <tr>
                        <td class="detail-content-label">Plaint filed :</td>
                        <td class="detail-content-value" colspan="3" >{!! nl2br( $invoice->plaint_filed) !!}</td>
                    </tr>
                    <tr>
                        <td class="detail-content-label">judgement date </td>
                        <td class="detail-content-value" >{!! $invoice->judgement_date !!}</td>
                        <td class="detail-content-label"> Plaint served : </td>
                        <td class="detail-content-value">{!! $invoice->plaint_served !!}</td>
                    </tr>
                    <tr>
                        <td class="detail-content-label">court :</td>
                        <td class="detail-content-value" >{!! $invoice->court !!}</td>
                        <td class="detail-content-label"> Plaint number: </td>
                        <td class="detail-content-value" >{!! $invoice->plaint_number !!}</td>
                    </tr> 

                    <tr>

                        <td class="detail-content-label"> arrangement : </td>
                        <td class="detail-content-value" colspan="3" >{!! nl2br($invoice->arrangement) !!}</td>
                    </tr> 



                </table>
            </div> 
        </div>  

        @endif

        <div class="btn-group btn-group-justified" role="group" aria-label="...">
            <div class="btn-group" role="group">
                <button type="button" class="btn btn-default">Office notes</button>
            </div>
            <div class="btn-group" role="group">
                <button type="button" class="btn btn-default">Communication</button>
            </div>
            <div class="btn-group" role="group">
                <button type="button" class="btn btn-default">Email</button>
            </div> 
            <div class="btn-group" role="group">
                <button type="button" class="btn btn-default">Sms detail</button>
            </div> 
            <div class="btn-group" role="group">
                <button type="button" class="btn btn-default">Reports</button>
            </div> 
            <div class="btn-group" role="group">
                <button type="button" class="btn btn-default">Letter</button>
            </div>

        </div>  
    </div> 
    <div class="col-md-3 ">  


        <div class="panel panel-color panel-primary p-0  m-t-20">
            <div class="panel-heading"> 
                <h3 class="panel-title">Panel Primary</h3> 
            </div>
            <div class="panel-body p-0">
                <div class="list-group mail-list">
                    <a href="#" data-toggle="modal" class="list-group-item no-border" data-target=".email-pop" ><i class="fa fa-envelope-o"></i> Mail  </a>
                    <a href="#" class="list-group-item no-border" ><i class="fa  fa-building-o"></i> Email template</a>
                    <a href="#" class="list-group-item no-border" ><i class="fa fa-users"></i> Contact</a> 
                    <a href="#"  class="list-group-item no-border" ><i class="fa fa-filter"></i> Legal </a>

                </div>
            </div>
        </div>
    </div>
</div>



@stop
@section('include-js')
@parent

@stop

