@extends('layouts.master')
@section('title')
@parent
Debitor  invoice edit
@stop

@section('content')
<div class="row">
    <div class="col-sm-12">
        <h4 class="pull-left page-title"> </h4>
        <ol class="breadcrumb pull-right">
            <li><a href="{!! route('home.index') !!}">Dashboard</a></li>
            <li><a href="{!! route('debtor.index') !!}">Debtor</a></li>
            <li class="active" >Edit invoice</li> 
            <li class="active" >{!! $invoice->invoice_code !!}</li>
        </ol>
    </div>
</div> 


<div class="panel panel-primary">
    <div class="panel-heading">
        <div class="row"> 
            <div class="col-md-12">
                <div class="panel-heading pull-left">
                    <h3 class="panel-title"> Debtor  Edit </h3>
                </div>

                <div class="pull-right">

                </div> 
            </div>
        </div>
    </div><!-- /.box-header -->
    <div class="panel-body">
        <div class="row"> 
            <div class="col-md-6">

                {!! Form::model($invoice, ['method' => 'PATCH', 'route' => ['debtor.invoice.update',$debtor->id,$invoice->id]]) !!}
                <!--                                   
                -->
                <div class="form-group {!! ($errors->has('invoice_date')) ? 'has-error' : '' !!}">
                    {!! Form::label('invoice_date', 'Invoice date') !!}
                    {!! Form::text('invoice_date', null, array('class' => 'form-control datepicker', 'placeholder' => 'Eg: 03/19/2015', 'autocomplete' => 'off')) !!}
                    {!! ($errors->has('invoice_date') ? $errors->first('invoice_date') : '') !!}
                </div> 

                <div class="form-group {!! ($errors->has('invoice_state')) ? 'has-error' : '' !!}">
                    {!! Form::label('invoice_state', 'Invoice state', ['class' => 'control-label']) !!}
                    {!!  Form::select('invoice_state',  [ 'create'=>'Create', 'processing'=>'Processing', 'complete'=>'Complete', 'legal action'=>'Legal action', 'cancel'=>'Cancel'], null  ,['class' => 'form-control', 'placeholder' => 'state', 'required'])  !!}
                    <span class="help-block">{!! ($errors->has('invoice_state') ? $errors->first('invoice_state') : '') !!}</span>
                </div> 

            </div>
            <div class="col-md-6">
                <div class="form-group {!! ($errors->has('account_state')) ? 'has-error' : '' !!}">
                    {!! Form::label('account_state', 'Account state', ['class' => 'control-label']) !!}
                    {!!  Form::select('account_state',  [ 'p'=>'p', 't'=>'t'], null  ,['class' => 'form-control', 'placeholder' => 'state', 'required'])  !!}
                    <span class="help-block">{!! ($errors->has('account_state') ? $errors->first('account_state') : '') !!}</span>
                </div>

                <div class="form-group {!! ($errors->has('user_id')) ? 'has-error' : '' !!}">
                    {!! Form::label('user_id', 'Follow up', ['class' => 'control-label']) !!}
                    {!!  Form::select('user_id',  $users, null  ,['class' => 'form-control', 'placeholder' => 'state', 'required'])  !!}
                    <span class="help-block">{!! ($errors->has('user_id') ? $errors->first('user_id') : '') !!}</span>
                </div>   
            </div>
        </div> 
    </div>
</div>  

<div class="panel panel-primary">
    <div class="panel-heading">
        <div class="row"> 
            <div class="col-md-12">
                <div class="panel-heading pull-left">
                    <h3 class="panel-title"> Account Details </h3>
                </div>

                <div class="pull-right">

                </div> 
            </div>
        </div>
    </div><!-- /.box-header -->
    <div class="panel-body">
        <div class="row"> 
            <div class="col-md-6">
                <div class="form-group {!! ($errors->has('original_debt')) ? 'has-error' : '' !!}">
                    {!! Form::label('original_debt', 'Original debt') !!}
                    {!! Form::text('original_debt', null, array('class' => 'form-control', 'placeholder' => 'Eg: 259.00', 'autocomplete' => 'off')) !!}
                    {!! ($errors->has('original_debt') ? $errors->first('invoice_date') : '') !!}
                </div>  

                <div class="form-group {!! ($errors->has('current_balance')) ? 'has-error' : '' !!}">
                    {!! Form::label('current_balance', 'Current balance') !!}
                    {!! Form::text('current_balance', null, array('class' => 'form-control', 'placeholder' => 'Eg: 25.00', 'autocomplete' => 'off')) !!}
                    {!! ($errors->has('current_balance') ? $errors->first('current_balance') : '') !!}
                </div>  
                <div class="form-group {!! ($errors->has('non_recoverable_cost_date')) ? 'has-error' : '' !!}">
                    {!! Form::label('non_recoverable_cost_date', 'Non recoverable costs to date') !!}
                    {!! Form::text('non_recoverable_cost_date', null, array('class' => 'form-control datepicker', 'placeholder' => 'Eg: 03/19/2015', 'autocomplete' => 'off')) !!}
                    {!! ($errors->has('non_recoverable_cost_date') ? $errors->first('non_recoverable_cost_date') : '') !!}
                </div> 
                <div class="form-group {!! ($errors->has('debt_recovered_date')) ? 'has-error' : '' !!}">
                    {!! Form::label('debt_recovered_date', 'Debt recovered to date') !!}
                    {!! Form::text('debt_recovered_date', null, array('class' => 'form-control datepicker', 'placeholder' => 'Eg: 03/19/2015', 'autocomplete' => 'off')) !!}
                    {!! ($errors->has('debt_recovered_date') ? $errors->first('debt_recovered_date') : '') !!}
                </div> 
                <div class="form-group {!! ($errors->has('costs_recovered_date')) ? 'has-error' : '' !!}">
                    {!! Form::label('costs_recovered_date', 'Costs recovered to date') !!}
                    {!! Form::text('costs_recovered_date', null, array('class' => 'form-control datepicker', 'placeholder' => 'Eg: 03/19/2015', 'autocomplete' => 'off')) !!}
                    {!! ($errors->has('costs_recovered_date') ? $errors->first('costs_recovered_date') : '') !!}
                </div> 
            </div>
            <div class="col-md-6">
                <div class="form-group {!! ($errors->has('last_payment')) ? 'has-error' : '' !!}">
                    {!! Form::label('last_payment', 'Last payment') !!}
                    {!! Form::text('last_payment', null, array('class' => 'form-control', 'placeholder' => 'Eg: 201.00', 'autocomplete' => 'off')) !!}
                    {!! ($errors->has('last_payment') ? $errors->first('last_payment') : '') !!}
                </div> 
                <div class="form-group {!! ($errors->has('last_paid')) ? 'has-error' : '' !!}">
                    {!! Form::label('last_paid', 'Last payment date') !!}
                    {!! Form::text('last_paid', null, array('class' => 'form-control datepicker', 'placeholder' => 'Eg: 03/19/2015', 'autocomplete' => 'off')) !!}
                    {!! ($errors->has('last_paid') ? $errors->first('last_paid') : '') !!}
                </div>  
                <div class="form-group {!! ($errors->has('solicitor_cost_date')) ? 'has-error' : '' !!}">
                    {!! Form::label('solicitor_cost_date', 'Solicitor costs to date') !!}
                    {!! Form::text('solicitor_cost_date', null, array('class' => 'form-control datepicker', 'placeholder' => 'Eg: 03/19/2015', 'autocomplete' => 'off')) !!}
                    {!! ($errors->has('solicitor_cost_date') ? $errors->first('solicitor_cost_date') : '') !!}
                </div> 
                <div class="form-group {!! ($errors->has('recoverable_cost_date')) ? 'has-error' : '' !!}">
                    {!! Form::label('recoverable_cost_date', 'Recoverable costs to date') !!}
                    {!! Form::text('recoverable_cost_date', null, array('class' => 'form-control datepicker', 'placeholder' => 'Eg: 03/19/2015', 'autocomplete' => 'off')) !!}
                    {!! ($errors->has('recoverable_cost_date') ? $errors->first('recoverable_cost_date') : '') !!}
                </div> 


            </div>
        </div>
    </div>
</div> 
@if($invoice->invoice_state =='legal action') 

<div class="panel panel-primary">
    <div class="panel-heading">
        <div class="row"> 
            <div class="col-md-12">
                <div class="panel-heading pull-left">
                    <h3 class="panel-title"> Legal arrangement </h3>
                </div>

                <div class="pull-right">

                </div> 
            </div>
        </div>
    </div>
    <div class="panel-body">
        <div class="row"> 
            <div class="col-md-12">

                <div class="form-group {!! ($errors->has('plaint_filed')) ? 'has-error' : '' !!}">
                    {!! Form::label('plaint_filed', 'Plaint filed') !!}


                    {!! Form::textarea('plaint_filed', null, array('class' => 'form-control', 'placeholder' => '')) !!}
                    {!! ($errors->has('plaint_filed') ? $errors->first('plaint_filed') : '') !!}
                </div>
            </div>
            <div class="col-md-6">

                <div class="form-group {!! ($errors->has('plaint_served')) ? 'has-error' : '' !!}">
                    {!! Form::label('plaint_served', 'Plaint served') !!}
                    {!! Form::text('plaint_served', null, array('class' => 'form-control', 'placeholder' => 'Eg: Emery')) !!}
                    {!! ($errors->has('plaint_served') ? $errors->first('plaint_served') : '') !!}
                </div> 
                <div class="form-group {!! ($errors->has('court')) ? 'has-error' : '' !!}">
                    {!! Form::label('court', 'Court') !!}
                    {!! Form::text('court', null, array('class' => 'form-control', 'placeholder' => 'Eg: aus')) !!}
                    {!! ($errors->has('court') ? $errors->first('court') : '') !!}
                </div>
            </div> 
            <div class="col-md-6">


                <div class="form-group {!! ($errors->has('plaint_number,')) ? 'has-error' : '' !!}">
                    {!! Form::label('plaint_number', 'Plaint number,') !!}
                    {!! Form::text('plaint_number', null, array('class' => 'form-control', 'placeholder' => 'Eg: aus')) !!}
                    {!! ($errors->has('plaint_number') ? $errors->first('plaint_number') : '') !!}
                </div>
                <div class="form-group {!! ($errors->has('judgement_date')) ? 'has-error' : '' !!}">
                    {!! Form::label('judgement_date ', 'Judgement date ') !!}
                    {!! Form::text('judgement_date', null, array('class' => 'form-control datepicker', 'placeholder' => 'Eg: aus')) !!}
                    {!! ($errors->has('judgement_date') ? $errors->first('judgement_date') : '') !!}
                </div> 
            </div>
            <div class="col-md-12">
                <div class="form-group {!! ($errors->has('arrangement ')) ? 'has-error' : '' !!}">
                    {!! Form::label('arrangement ', 'Arrangement') !!}
                    {!! Form::textarea('arrangement', null, array('class' => 'form-control', 'placeholder' => '')) !!}
                    {!! ($errors->has('arrangement ') ? $errors->first('arrangement ') : '') !!}
                </div>
            </div>
        </div>
    </div>
</div> 
@endif

<div class="panel-footer"> 
   
        {!! Form::submit('Update', array('class' => 'btn btn-info')) !!} &nbsp;&nbsp;
        <a href="{!!  route('debtor.invoice', [$debtor->id]) !!}" class="btn btn-default">Cancel</a>
        {!!Form::close()!!} 
   
</div>






@stop
@section('include-js')
@parent

@stop

