@extends('layouts.master')
@section('title')
@parent
Solicitor
@stop

@section('content')

<div class="row">
    <div class="col-sm-12">
        <h4 class="pull-left page-title"> </h4>
        <ol class="breadcrumb pull-right">
            <li><a href="{!! route('home.index') !!}">Dashboard</a></li>
            <li class="active">imports files</li>
        </ol>
    </div>
</div>

<div class="panel panel-default">
    <div class="panel-heading">
        <div class="row"> 
            <div class="col-md-12">
                
            </div>
        </div>
    </div><!-- /.box-header -->
    <div class="panel-body table-rep-plugin"> 
        <div class="table-responsive" data-pattern="priority-columns">
             <table id="tech-companies-1" class="table  table-bordered ">
                            <thead>

                                <tr>
                                   <th> 
                                        Client code
                                    </th>
                                    <th data-priority="1" >
                                        Debtor code
                                    </th>
                                    <th  >Invoice code</th>
                                    <th data-priority="6" >Invoice date</th> 
                                    <th data-priority="6" >Invoice state</th> 
                                    <th data-priority="1" >Original debt </th>
                                    <th data-priority="1" >current balance</th>
                                    
                                    <th data-priority="3" >Action</th>
                                </tr> 
                            </thead> 
                            <tbody>
                            @foreach($debtors as $debtor)

                            <tr>
                                <td>{!!$debtor->client->client_code !!}</td>
                                <td>{!!$debtor->debtor->debtor_code !!}</td>
                                <td>{!!    $debtor->invoice_code !!}</td>
                                <td>
                                    {!! $debtor->invoice_date !!}
                                </td> 
                                <td>
                                    {!! $debtor->invoice_state !!}
                                </td>  
                                <td>
                                    {!! $debtor->original_debt !!}
                                </td> 

                                <td>
                                    {!! $debtor->current_balance !!}
                                </td> 
                              
                                <td> 
                                    
                                    <a href="{!! route('client.debtor.invoice.show', [$debtor->client_id, $debtor->id]) !!}"><i class="fa  fa-bars" rel="tooltip" title="Detail"></i>  </a>&nbsp;&nbsp; 
                                   
                                     
                                    
                                    <a href="{!! route('client.debtor.invoice.edit', [$debtor->client_id, $debtor->id]) !!}"><i class="fa  fa-edit" rel="tooltip" title="Edit"></i>  </a>&nbsp;&nbsp; 
                                    @if($debtor->invoice_status_code_id != 18)
                                     <a href="{!! route('client.debtor.invoice.delete', [$debtor->client_id, $debtor->id]) !!}"><i class="fa  fa-archive" rel="tooltip" title="Edit"></i>  </a>&nbsp;&nbsp;
                                     @endif
                                    <a href="{!! route('client.debtor.invoice.payment', [$debtor->client_id, $debtor->id]) !!}"><i class="fa  fa-money" rel="tooltip" title="Payment"></i>  </a>&nbsp;&nbsp;
                                 <a href="{!! route('client.debtor.invoice.due', [$debtor->client_id, $debtor->id]) !!}"><i class="fa  fa-pie-chart" rel="tooltip" title="Due"></i>  </a>&nbsp;&nbsp;
                                <a href="{!! route('client.debtor.invoice.follow', [$debtor->client_id, $debtor->id]) !!}"><i class="fa  fa-leaf" rel="tooltip" title="Follow"></i>  </a>&nbsp;&nbsp;
                              
                               
                                </td>

                            </tr>
                            @endforeach 
                            </tbody>
                        </table> 
        </div>                                           
    </div><!-- /.box-body -->
    <div class="panel-footer">
       
    </div>
</div>

@stop
@section('include-js')
@parent

@stop