@extends('layouts.master')
@section('title')
@parent
Mail
@stop

@section('content')
<div class="box">
    <div class="box-header">
        <h3 class="box-title">Mail </h3> 
        <div class="btn-group pull-right">

        </div>
    </div><!-- /.box-header -->
    <div class="box-body"> 

        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title">Compose New Message</h3>
            </div><!-- /.box-header --> 
            {!! Form::open(array('route' => array('mail.store'), 'autocomplete' => 'off')) !!}
            <div class="box-body"> 


                <div class="form-group {!! ($errors->has('to')) ? 'has-error' : '' !!}"> 
                    <div class="row">
                        <div class="col-md-1">
                            {!! Form::label('to', 'To') !!} 
                        </div> 
                        <div class="col-md-8">
                            <input type="hidden" class="invoice-select"  name="to">
                            <span class="help-block">{!! ($errors->has('to') ? $errors->first('to') : '') !!}</span>
                        </div> 
                        <div class="col-md-3">
                            <div class="radio">
                                <label>
                                    <input type="radio"  name="to-mail" id="user" value="user" >
                                    User
                                </label>
                                <label>
                                    <input type="radio" name="to-mail" id="client" value="client" >
                                    Client
                                </label> 
                                <label>
                                    <input type="radio" name="to-mail" id="debtor" value="debtor" checked>
                                    Debtor
                                </label>
                            </div>
                        </div>
                    </div>
                </div> 
                <div class="form-group {!! ($errors->has('cc')) ? 'has-error' : '' !!}"> 
                    <div class="row">
                        <div class="col-md-1">
                            {!! Form::label('cc', 'Cc') !!} 
                        </div> 
                        <div class="col-md-8">
                            <input type="hidden" class="invoice-select" name="cc">
                            <span class="help-block">{!! ($errors->has('cc') ? $errors->first('cc') : '') !!}</span>
                        </div> 
                        <div class="col-md-3">

                        </div>
                    </div>
                </div> 
                <div class="form-group {!! ($errors->has('bcc')) ? 'has-error' : '' !!}"> 
                    <div class="row">
                        <div class="col-md-1">
                            {!! Form::label('bcc', 'Bcc') !!} 
                        </div> 
                        <div class="col-md-8">
                            <input type="hidden" class="invoice-select" name="bcc">
                            <span class="help-block">{!! ($errors->has('bcc') ? $errors->first('bcc') : '') !!}</span>
                        </div> 
                        <div class="col-md-3">

                        </div>
                    </div>
                </div>
                <div class="form-group {!! ($errors->has('subject')) ? 'has-error' : '' !!}"> 
                    <div class="row">
                        <div class="col-md-1">
                            {!! Form::label('subject', 'Subject') !!} 
                        </div> 
                        <div class="col-md-11">
                            {!! Form::text('subject', null, array('class' => 'form-control subject', 'placeholder' => 'Eg: payment', 'autocomplete' => 'off')) !!}
                            {!! ($errors->has('subject') ? $errors->first('subject') : '') !!}
                        </div>
                    </div>
                </div>
                <div class="form-group {!! ($errors->has('content')) ? 'has-error' : '' !!}"> 
                    <div class="row">
                        <div class="col-md-1">
                            {!! Form::label('content', 'Content') !!} 
                        </div> 
                        <div class="col-md-11">
                            <textarea class="textarea" name="content" placeholder="Place some text here" style="width: 100%; height: 200px; font-size: 14px; line-height: 18px; border: 1px solid #dddddd; padding: 10px;"></textarea>
                            {!! ($errors->has('content') ? $errors->first('content') : '') !!}
                        </div>
                    </div>
                </div>

<!--                <div class="form-group">
                    <div class="btn btn-default btn-file">
                        <i class="fa fa-paperclip"></i> Attachment
                        <input type="file" name="attachment"/>
                    </div>
                    <p class="help-block">Max. 32MB</p>
                </div>-->
            </div><!-- /.box-body -->
            <div class="box-footer">
                <div class="pull-right">
                   
                    <button type="submit" class="btn btn-primary"><i class="fa fa-envelope-o"></i> Send</button>
                </div>
               
            </div> 
            {!!Form::close()!!} 
            <!-- /.box-footer -->
        </div>

    </div><!-- /.box-body -->
    <div class="box-footer clearfix">

    </div>
</div>

@stop
@section('include-js')
@parent

@stop 
<script>
    @section('document-ready-js')
            @parent


            var url = '{!! route("mail.send") !!}';
    var model = 'debtor';
    $('input:radio[name="to-mail"]').change(
            function () {

                if ($(this).is(':checked')) {
                   
                    model = $(this).val();
                }
                


            });


    $('.invoice-select').select2({
        width: '100%',
        minimumInputLength: 1,
       tags: true,
        ajax: {
            url: url,
            dataType: 'json',
            quietMillis: 100,
            
            data: function (term) {

                return {
                    term: term,
                    model: model
                };
            },
            results: function (data) {


                var results = [];
                $.each(data, function (index, item) {

                    if(model=='user') 
                    {
                    results.push({
                        id: item.email+'&&'+model+'&&'+item.id,
                        text: '"'+item.last_name+'" '+item.email,
                    }); 
                } 
                else
                {
                    results.push({
                        id: item.email+'&&'+model+'&&'+item.id,
                        text: '"'+item.name+'" '+item.email,
                    });  
                }
                });
                return {
                    results: results
                };
            },
        },
       
           
    }).on('change', function(e) {
    });

 
    @stop

</script>