@extends('layouts.master')
@section('title')
@parent
Payments
@stop

@section('content')


<div class="nav-tabs-custom">

    <div class="tab-content">

        <!-- /.tab-pane -->

        <div class="tab-pane active" > 
            <div class="box">
                <div class="box-header">
                    <h3 class="box-title">Payments update</h3> 
                    <div class="btn-group pull-right">
                        
                    </div>
                </div>  
                <div class="box-body"> 
                   
 {!! Form::model($payment, ['method' => 'PATCH', 'route' => ['payment.update',$payment->debtorInvoice->id, $payment->id]]) !!}
                    <table class="table table-bordered detail-table">
                        <tr class="detail-header">


                        </tr>
                        <tr>
                            <td class="detail-content-label">Invoice code :</td>
                            <td class="detail-content-value"> 
                                <div class="pull-right" id="client-name">{!! $invoice->invoice_code !!}</div> 
                                {!! Form::hidden('debtor_invoice_id',$invoice->id)!!}

                            </td>
                        </tr> 
                        <tr>
                            <td class="detail-content-label"> Client Name : </td>
                            <td class="detail-content-value"><div class="pull-right" id="client-name"> {!! ($invoice->client)? $invoice->client->name : '' !!} </div></td>
                        </tr>  
                        <tr>
                            <td class="detail-content-label"> Debtor name  : </td>
                            <td class="detail-content-value"><div class="pull-right" id="debtor-name">{!! ($invoice->debtor)? $invoice->debtor->name : '' !!}</div></td>
                        </tr> 
                        <tr>
                            <td class="detail-content-label"> Original debt : </td>
                            <td class="detail-content-value" ><div class="pull-right" id="original-debt">{!! $invoice->original_debt  !!}</div></td>
                        </tr> 
                        <tr>
                            <td class="detail-content-label"> Current_balance  : </td>
                            <td class="detail-content-value" ><div class="pull-right" id="current-balance">{!! $invoice->current_balance !!}</div></td>
                        </tr> 
                        <tr>
                            <td class="detail-content-label"> Pay amount  : </td>
                            <td class="detail-content-value"> 
                                <div class="form-group {!! ($errors->has('amount')) ? 'has-error' : '' !!}">
                                    
                                    {!! Form::text('amount', null, array('class' => 'form-control text-right amount-class', 'placeholder' => '20.00', 'autocomplete' => 'off')) !!}
                                    {!! ($errors->has('amount') ? $errors->first('amount') : '') !!}
                                </div>
                            </td> 
                        </tr> 
                        <tr>
                            <td class="detail-content-label"> Payment state : </td>
                            <td class="detail-content-value">  
                                <div class="form-group {!! ($errors->has('payment_state')) ? 'has-error' : '' !!}">

                                    {!!  Form::select('payment_state',  [ 'due'=>'Due', 'pay'=>'Pay'],  $payment->payment_state ,['class' => 'form-control state', 'placeholder' => 'state', 'required'])  !!}
                                    <span class="help-block">{!! ($errors->has('payment_state') ? $errors->first('payment_state') : '') !!}</span>
                                </div>  

                            </td>
                        </tr> 
                        <tr class="due-div ">
                            <td class="detail-content-label"> Payment date  : </td>
                            <td class="detail-content-value"> 
                                <div class="form-group {!! ($errors->has('payment_date')) ? 'has-error' : '' !!}">

                                    {!! Form::text('payment_date', null, array('class' => 'form-control datepicker', 'placeholder' => 'Eg: 03/19/2015', 'autocomplete' => 'off')) !!}
                                    {!! ($errors->has('payment_date') ? $errors->first('payment_date') : '') !!}
                                </div>

                            </td>
                        </tr> 
                        <tr  class=" pay-div" >
                            <td class="detail-content-label"> Payment type  : </td>
                            <td class="detail-content-value">  
                                <div class="form-group {!! ($errors->has('payment_type')) ? 'has-error' : '' !!}">

                                    {!!  Form::select('payment_type',  [ 'cash'=>'Cash', 'cheque'=>'Cheque'], $payment->payment_type  ,['class' => 'form-control payment', 'placeholder' => 'state', 'required'])  !!}
                                    <span class="help-block">{!! ($errors->has('payment_type') ? $errors->first('payment_type') : '') !!}</span>
                                </div>  

                            </td>
                        </tr> 
                        
                         <tr class=" pay-div">
                            <td class="detail-content-label"> Paid date  : </td>
                            <td class="detail-content-value"> 
                                <div class="form-group {!! ($errors->has('paid_date')) ? 'has-error' : '' !!}">

                                    {!! Form::text('paid_date', null, array('class' => 'form-control datepicker', 'placeholder' => 'Eg: 03/19/2015', 'autocomplete' => 'off')) !!}
                                    {!! ($errors->has('paid_date') ? $errors->first('paid_date') : '') !!}
                                </div>

                            </td>
                        </tr>

                        <tr class="cheque-div" style=" display: none;">
                            <td class="detail-content-label"> Bank  : </td>
                            <td class="detail-content-value"> 
                                <div class="form-group {!! ($errors->has('bank')) ? 'has-error' : '' !!}">

                                    {!! Form::text('bank', null, array('class' => 'form-control', 'placeholder' => 'Commacial Bank', 'autocomplete' => 'off')) !!}

                                    {!! ($errors->has('bank') ? $errors->first('last_payment') : '') !!}


                                </div> 
                            </td>
                        </tr>   
                        
                        
                        <tr class="cheque-div" style=" display: none;">
                            <td class="detail-content-label"> Branch  : </td>
                            <td class="detail-content-value"> 
                                <div class="form-group {!! ($errors->has('branch')) ? 'has-error' : '' !!}">

                                    {!! Form::text('branch', null, array('class' => 'form-control', 'placeholder' => 'Eg: Sydney', 'autocomplete' => 'off')) !!}

                                    {!! ($errors->has('branch') ? $errors->first('branch') : '') !!}


                                </div>

                            </td>
                        </tr>
                        <tr class="cheque-div" style=" display: none;">
                            <td class="detail-content-label"> Drawer  : </td>
                            <td class="detail-content-value"> 

                                <div class="form-group {!! ($errors->has('drawer')) ? 'has-error' : '' !!}">

                                    {!! Form::text('drawer', null, array('class' => 'form-control', 'placeholder' => 'Eg: Watchen', 'autocomplete' => 'off')) !!}

                                    {!! ($errors->has('drawer') ? $errors->first('branch') : '') !!}


                                </div>

                            </td>
                        </tr> 
                        <tr class="cheque-div" style=" display: none;">
                            <td class="detail-content-label"> Cheque no : </td>
                            <td class="detail-content-value"> 
                                <div class="form-group {!! ($errors->has('cheque_no')) ? 'has-error' : '' !!}">

                                    {!! Form::text('cheque_no', null, array('class' => 'form-control', 'placeholder' => 'Eg: tyyyu-iolk-2569', 'autocomplete' => 'off')) !!}

                                    {!! ($errors->has('cheque_no') ? $errors->first('cheque_no') : '') !!}


                                </div> 
                            </td>

                        </tr> 


<!--                                 <tr>
   <td class="detail-content-label"> Payment type  : </td>
   <td class="detail-content-value"> 
       
   </td>
</tr>-->


                        <tr>
                            <td colspan="2" class="detail-content-value"> <div class="pull-right"> {!! Form::submit('Due', array('class' => 'btn pay-due-btn btn-success')) !!} &nbsp;&nbsp; 
                                <a href="{!! URL::route('payment.index') !!}" class="btn btn-default">Back</a></div></td>
                        </tr> 
                    </table> 



                    {!!Form::close()!!} 
                </div>
            </div>
            
        </div>
    </div>
</div>


@stop
@section('include-js')
@parent

@stop 
<script>
    @section('document-ready-js')
            @parent


 if ($('.payment').val() == 'cheque')
        {
            $('.cheque-div').show();
        }
        else {
            $('.cheque-div').hide();
        }

if ($('.state').val() == 'due')
        {
             $('.pay-div').hide();
            $('.due-div').show();
            $('.pay-due-btn').val('Update Due');
        }
        else {
            $('.due-div').hide();
            $('.pay-div').show(); 
             $('.pay-due-btn').val('Update Pay');
        }


    $(".payment").change(function () {
        console.log($(this).val());
        if ($(this).val() == 'cheque')
        {
            $('.cheque-div').show();
        }
        else {
            $('.cheque-div').hide();
        }
    });  
     $(".state").change(function () {
        console.log($(this).val());
        if ($(this).val() == 'due')
        {
             $('.pay-div').hide();
            $('.due-div').show();
            $('.pay-due-btn').val('Due');
        }
        else {
            $('.due-div').hide();
            $('.pay-div').show(); 
             $('.pay-due-btn').val('Pay');
        }
    });
var pval= parseFloat($('#current-balance').text()) + parseFloat($('.amount-class').val());
    $('.amount-class').change(function () {
        var amount = $(this).val();
        var currentBalance = pval;
        if ((currentBalance -amount) < 0)
        {
           
           alert('pay amount must be less than current balance( '+currentBalance.toFixed(2)+' )');
           $(this).val(currentBalance.toFixed(2));
           $('#current-balance').text('0.00');
           return false;
        }
        var currentBalanceNew = parseFloat(currentBalance - amount).toFixed(2);
        $('#current-balance').text(currentBalanceNew);
    });
            @stop

</script>