@extends('layouts.master')
@section('title')
@parent
Payments
@stop

@section('content')
<ol class="breadcrumb">



</ol>

<div class="nav-tabs-custom">

    <div class="tab-content">

        <!-- /.tab-pane -->

        <div class="tab-pane active" > 

            <div class="panel panel-default">
                <div class="panel-heading">


                    <div class="row"> 
                        <div class="col-md-2">
                            <div class="panel-heading pull-left">
                                <h3 class="panel-title">Payment</h3>
                            </div>
                        </div> 
                        <div class="col-md-3" style="text-align: right" >Debtor</div>
                        <div class="col-md-7">
                            
                                         <input type="hidden"  class="debtor-select" id="debtor-select-id" name="debtor_id"> 
                                    
                                    
                        </div>
                    </div>



                </div><!-- /.box-header -->
                <div class="panel-body"> 

@if($debtorInvoice == 'no') 
<div class="alert alert-danger">
  <strong>Debtor Invoice !</strong> ist not found for that debtor.
</div>
@else


                    {!! Form::open(array('route' => array('client.debtor.invoice.payment',  $invoice->client_id, $invoice->id), 'autocomplete' => 'off')) !!}

                    <table class="table table-bordered detail-table">
                        <tr class="detail-header">


                        </tr>
                        <tr>
                            <td class="detail-content-label">Invoice code :</td>
                            <td class="detail-content-value"> 
                                <div class="pull-right" id="client-name">{!! $invoice->invoice_code !!}</div> 
                                <input type="hidden" value="mainPayment" name="mainPayment">

                            </td>
                        </tr> 
                        <tr>
                            <td class="detail-content-label"> Client Name : </td>
                            <td class="detail-content-value"><div class="pull-right" id="client-name"> {!! ($invoice->client)? $invoice->client->name : '' !!} </div></td>
                        </tr>  
                        <tr>
                            <td class="detail-content-label"> Debtor name  : </td>
                            <td class="detail-content-value"><div class="pull-right" id="debtor-name">{!! ($invoice->debtor)? $invoice->debtor->name : '' !!}</div></td>
                        </tr> 
                        <tr>
                            <td class="detail-content-label"> Original debt : </td>
                            <td class="detail-content-value" ><div class="pull-right" id="original-debt">{!! $invoice->original_debt  !!}</div></td>
                        </tr> 
                        <tr>
                            <td class="detail-content-label"> Current_balance  : </td>
                            <td class="detail-content-value" ><div class="pull-right" id="current-balance">{!! $invoice->current_balance !!}</div>
                                <input type="hidden" value="{!! $invoice->current_balance !!}" name="current_balance">
                            </td>
                        </tr> 
                        <tr>
                            <td class="detail-content-label"> Pay amount  : </td>
                            <td class="detail-content-value"> 
                                <div class="form-group {!! ($errors->has('amount')) ? 'has-error' : '' !!}">

                                    {!! Form::text('amount', null, array('class' => 'form-control text-right amount-class', 'placeholder' => '20.00', 'autocomplete' => 'off')) !!}
                                    {!! ($errors->has('amount') ? $errors->first('amount') : '') !!}
                                </div>
                            </td> 
                        </tr> 
                        <tr>
                            <td class="detail-content-label"> commission Percentage : </td>
                            <td class="detail-content-value"> 
                                <div class="form-group {!! ($errors->has('commission')) ? 'has-error' : '' !!}">
                                    <div class="input-group">
                                        {!! Form::text('commissionP', $invoice->client->commission, array('class' => 'form-control text-right commissionP', 'placeholder' => '20%', 'autocomplete' => 'off')) !!}
                                        <span class="input-group-addon" id="basic-addon2">%</span> 
                                    </div>
                                    {!! ($errors->has('commission') ? $errors->first('commission') : '') !!}
                                </div>  

                            </td> 
                        </tr> 
                        <tr>
                            <td class="detail-content-label"> commission  : </td>
                            <td class="detail-content-value"> 
                                <div class="form-group {!! ($errors->has('commission')) ? 'has-error' : '' !!}">

                                    {!! Form::text('commission', null, array('class' => 'form-control text-right commition-class', 'placeholder' => '20.00', 'autocomplete' => 'off')) !!}
                                    {!! ($errors->has('commission') ? $errors->first('commission') : '') !!}
                                </div>  

                            </td> 
                        </tr> 

                        <tr>
                            <td class="detail-content-label"> Payment place : </td>
                            <td class="detail-content-value">  
                                <div class="form-group {!! ($errors->has('paid_place')) ? 'has-error' : '' !!}">

                                    {!!  Form::select('paid_place',  [ 'Paid to CTC'=>'Paid to CTC' , 'Paid to client (Instead direct)'=>'Paid to client (Instead direct)'], 'Paid to CTC'  ,['class' => 'form-control state paid-place-class', 'placeholder' => 'state', 'required'])  !!}
                                    <span class="help-block">{!! ($errors->has('paid_place') ? $errors->first('paid_place') : '') !!}</span>
                                </div>  

                            </td>
                        </tr>
                        <tr class=" ">
                            <td class="detail-content-label"> Payment date  : </td>
                            <td class="detail-content-value"> 
                                <div class="form-group {!! ($errors->has('payment_date')) ? 'has-error' : '' !!}">

                                    {!! Form::text('payment_date', null, array('class' => 'form-control datepicker', 'placeholder' => 'Eg: 03/19/2015', 'autocomplete' => 'off')) !!}
                                    {!! ($errors->has('payment_date') ? $errors->first('payment_date') : '') !!}
                                </div>

                            </td>
                        </tr> 
                        <tr  class="pay-div" style=" display: none;">
                            <td class="detail-content-label"> Payment type  : </td>
                            <td class="detail-content-value">  
                                <div class="form-group {!! ($errors->has('payment_type')) ? 'has-error' : '' !!}">

                                    {!!  Form::select('payment_type',  [ 'cash'=>'Cash', 'cheque'=>'Cheque', 'EFT'=>'EFT', 'debit card'=> 'Debit card', 'credit card'=>'Credit card'], 'cash'  ,['class' => 'form-control payment', 'placeholder' => 'state', 'required'])  !!}
                                    <span class="help-block">{!! ($errors->has('payment_type') ? $errors->first('payment_type') : '') !!}</span>
                                </div>  

                            </td>
                        </tr> 

                        <tr class="cheque-div" style=" display: none;">
                            <td class="detail-content-label"> Paid date  : </td>
                            <td class="detail-content-value"> 
                                <div class="form-group {!! ($errors->has('paid_date')) ? 'has-error' : '' !!}">

                                    {!! Form::text('paid_date', null, array('class' => 'form-control datepicker', 'placeholder' => 'Eg: 03/19/2015', 'autocomplete' => 'off')) !!}
                                    {!! ($errors->has('paid_date') ? $errors->first('paid_date') : '') !!}
                                </div>

                            </td>
                        </tr>

                        <tr class="cheque-div" style=" display: none;">
                            <td class="detail-content-label"> Bank  : </td>
                            <td class="detail-content-value"> 
                                <div class="form-group {!! ($errors->has('bank')) ? 'has-error' : '' !!}">

                                    {!! Form::text('bank', null, array('class' => 'form-control', 'placeholder' => 'Commacial Bank', 'autocomplete' => 'off')) !!}

                                    {!! ($errors->has('bank') ? $errors->first('last_payment') : '') !!}


                                </div> 
                            </td>
                        </tr>   


                        <tr class="cheque-div" style=" display: none;">
                            <td class="detail-content-label"> Branch  : </td>
                            <td class="detail-content-value"> 
                                <div class="form-group {!! ($errors->has('branch')) ? 'has-error' : '' !!}">

                                    {!! Form::text('branch', null, array('class' => 'form-control', 'placeholder' => 'Eg: Sydney', 'autocomplete' => 'off')) !!}

                                    {!! ($errors->has('branch') ? $errors->first('branch') : '') !!}


                                </div>

                            </td>
                        </tr>
                        <tr class="cheque-div" style=" display: none;">
                            <td class="detail-content-label"> Drawer  : </td>
                            <td class="detail-content-value"> 

                                <div class="form-group {!! ($errors->has('drawer')) ? 'has-error' : '' !!}">

                                    {!! Form::text('drawer', null, array('class' => 'form-control', 'placeholder' => 'Eg: Watchen', 'autocomplete' => 'off')) !!}

                                    {!! ($errors->has('drawer') ? $errors->first('branch') : '') !!}


                                </div>

                            </td>
                        </tr> 
                        <tr class="cheque-div" style=" display: none;">
                            <td class="detail-content-label"> Cheque no : </td>
                            <td class="detail-content-value"> 
                                <div class="form-group {!! ($errors->has('cheque_no')) ? 'has-error' : '' !!}">

                                    {!! Form::text('cheque_no', null, array('class' => 'form-control', 'placeholder' => 'Eg: tyyyu-iolk-2569', 'autocomplete' => 'off')) !!}

                                    {!! ($errors->has('cheque_no') ? $errors->first('cheque_no') : '') !!}


                                </div> 
                            </td>

                        </tr> 

                        <tr class="card-div" style=" display: none;">
                            <td class="detail-content-label"> Card Holder's Name  : </td>
                            <td class="detail-content-value"> 
                                <div class="form-group {!! ($errors->has('name_on_card')) ? 'has-error' : '' !!}">

                                    {!! Form::text('name_on_card', null, array('class' => 'form-control', 'placeholder' => 'ravi', 'autocomplete' => 'off')) !!}
                                    {!! ($errors->has('name_on_card') ? $errors->first('name_on_card') : '') !!}
                                </div>

                            </td>
                        </tr>

                        <tr class="card-div" style=" display: none;">
                            <td class="detail-content-label"> Card Number  : </td>
                            <td class="detail-content-value"> 
                                <div class="form-group {!! ($errors->has('card_number')) ? 'has-error' : '' !!}">

                                    {!! Form::text('card_number', null, array('class' => 'form-control', 'placeholder' => '3254 4578 8695 8524', 'autocomplete' => 'off')) !!}

                                    {!! ($errors->has('card_number') ? $errors->first('card_number') : '') !!}


                                </div> 
                            </td>
                        </tr> 
                        <tr class="card-div" style=" display: none;">
                            <td class="detail-content-label"> Expiry Date  : </td>
                            <td class="detail-content-value">
                                <div class="control-group">

                                    <div class="controls">
                                        <div class="form-group {!! ($errors->has('card_expiry_month')) ? 'has-error' : '' !!}">

                                            <select class="span3" name="card_expiry_month" id="card_expiry_month">

                                                <option value="01">Jan (01)</option>
                                                <option value="02">Feb (02)</option>
                                                <option value="03">Mar (03)</option>
                                                <option value="04">Apr (04)</option>
                                                <option value="05">May (05)</option>
                                                <option value="06">June (06)</option>
                                                <option value="07">July (07)</option>
                                                <option value="08">Aug (08)</option>
                                                <option value="09">Sep (09)</option>
                                                <option value="10">Oct (10)</option>1
                                                <option value="11">Nov (11)</option>
                                                <option value="12">Dec (12)</option>
                                            </select> 
                                            {!! ($errors->has('card_expiry_month') ? $errors->first('card_expiry_month') : '') !!}
                                            <select class="span2" name="card_expiry_year">

                                                <option value="2017">2017</option>
                                                <option value="2018">2018</option>
                                                <option value="2019">2019</option>
                                                <option value="2020">2020</option>
                                                <option value="2021">2021</option>
                                                <option value="2022">2022</option>
                                                <option value="2023">2023</option> 
                                                <option value="2024">2024</option>
                                                <option value="2025">2025</option>
                                                <option value="2026">2026</option> 
                                                <option value="2027">2027</option>
                                                <option value="2028">2028</option>
                                                <option value="2029">2029</option>
                                            </select> 
                                            {!! ($errors->has('card_expiry_year') ? $errors->first('card_expiry_year') : '') !!}

                                        </div> 
                                    </div>
                                </div>
                            </td>
                        </tr>  

                        <tr class="card-div" style=" display: none;">
                            <td class="detail-content-label"> Receipt Number  : </td>
                            <td class="detail-content-value"> 
                                <div class="form-group {!! ($errors->has('receipt_number')) ? 'has-error' : '' !!}">

                                    {!! Form::text('receipt_number', null, array('class' => 'form-control', 'placeholder' => 'R12222', 'autocomplete' => 'off')) !!}

                                    {!! ($errors->has('receipt_number') ? $errors->first('receipt_number') : '') !!}


                                </div> 
                            </td>
                        </tr> 


<!--                                 <tr>
   <td class="detail-content-label"> Payment type  : </td>
   <td class="detail-content-value"> 
       
   </td>
</tr>-->


                        <tr>
                            <td colspan="2" class="detail-content-value"> <div class="pull-right"> {!! Form::submit('Due', array('class' => 'btn pay-due-btn btn-success')) !!} &nbsp;&nbsp; 

                                </div></td>
                        </tr> 
                    </table> 



                    {!!Form::close()!!}  
                    
                    @endif
                </div>
            </div>
            <div class="box">
                <div class="box-header">
                    <h3 class="box-title">Payment Details </h3> 
                    <div class="btn-group pull-right">

                    </div>
                </div><!-- /.box-header -->
                <div class="box-body"> 
                    <table class="table table-bordered">
                        <tr>
                            <th style="width: 10px">#</th> 
                            <th>Client</th> 
                             <th>Debtor</th>
                            <th> Payment place </th> 
                            <th> Payment type </th>

                            <th>Payment date</th>
                            <th>Amount</th>  
                            <th>commission </th>

                            <th>Action</th>


                        </tr> 

                        @foreach($payments as $payment)

                        <tr>
                            <td></td> 
                            <td>{!! $payment->client->name !!}</td>  
                            <td>{!! $payment->debtor->name !!}</td> 
                            <td>{!! $payment->trans_description !!}</td> 
                            <td>{!! $payment->payment_type !!}</td>
                            <td>{!! $payment->payment_date   !!}</td> 
                            <td>{!! $payment->amount !!}</td> 
                            <td>{!! $payment->commission !!}</td>

                            <td>

                              <a href="{!! route('client.invoice.payment.edit', [$payment->client_id, $payment->debtorInvoice->id, $payment->id ]) !!}"><i class="fa  fa-edit" rel="tooltip" title="Edit"></i>  </a>&nbsp;&nbsp; 

                            </td>

                        </tr>
                        @endforeach
                    </table> 
                    {!! $payments->render() !!}
                </div>
            </div>
        </div>
    </div>
</div>


@stop
@section('include-js')
@parent

@stop 

@section('document-ready-js')
@parent 


if ($('.payment').val() == 'cheque')
{
$('.cheque-div').show();
$('.card-div').hide();
}
else if ($('.payment').val() == 'credit card' || $('.payment').val() == 'debit card')
{
$('.card-div').show();
$('.cheque-div').hide();
}
else {
$('.pay-div').show(); 
$('.card-div').hide();
$('.cheque-div').hide();
}



//            $('.cheque-div').hide(); 
//             $('.pay-div').hide();   
$(".pay-div").show();
$('.due-div').hide();
$('.pay-due-btn').val('Pay');
$(".payment").change(function () {
console.log($(this).val());
if ($(this).val() == 'cheque')
{
$('.cheque-div').show();
$('.card-div').hide();
}
else if ($(this).val() == 'credit card' || $(this).val() == 'debit card')
{
$('.card-div').show();
$('.cheque-div').hide();
}
else {
$('.pay-div').show(); 
$('.card-div').hide();
$('.cheque-div').hide();
}
});

$(".state").change(function () {
if ($(this).val() == 'due')
{
$('.pay-div').hide();
$('.due-div').show();
$('.pay-due-btn').val('Due');
}
else {
$(".pay-div").show();
$('.due-div').hide();
$('.pay-due-btn').val('Pay');
}
});


var pval = $('#current-balance').text();
$('.amount-class').change(function () {
$('#current-balance').text(pval);
var amount = $(this).val();
var currentBalance = $('#current-balance').text();
console.log(currentBalance - amount);
if ((currentBalance - amount) < 0)
{

alert('pay amount must be less than current balance');
$(this).val('');
return false;
} 

var currentBalanceNew = currentBalance - amount;
$('#current-balance').text(currentBalanceNew); 

var commissionP = $('.commissionP').val();
$('.commition-class').val(amount*commissionP/100);
}); 
$('.commissionP').change(function () { 
var amount = $('.amount-class').val();
var commissionP = $('.commissionP').val();
$('.commition-class').val(amount*commissionP/100);
});   

function paiymentPlace()
{
var paymentPlace = $(".payment").val(); 

if( $('.paid-place-class').val() == 'Paid to CTC')
{ 
$('.pay-div').show();
if (paymentPlace == 'cheque')
{
$('.cheque-div').show();
$('.card-div').hide();
}
else if (paymentPlace== 'credit card' || paymentPlace == 'debit card')
{
$('.card-div').show();
$('.cheque-div').hide();
}
else {
$('.pay-div').show(); 
$('.card-div').hide();
$('.cheque-div').hide();
} 
} 
else 
{
$('.pay-div').hide(); 
$('.card-div').hide();
$('.cheque-div').hide(); 
$('.pay-div').hide();
}
}

$('.paid-place-class').change(function () { 

$('.pay-div').show();
paiymentPlace();

});

paiymentPlace();  


var getDebtorUrl = '{!! route("debtor.index") !!}';

$('.debtor-select').select2({
width: '100%',

ajax: {
url: getDebtorUrl,
dataType: 'json',
quietMillis: 100,
data: function (term) {
return {
term: term
};
},
results: function (data) {

console.log(data);
var results = [];

$.each(data, function (index, item) {

results.push({
id: item.id,
text: item.name + ' ' + item.debtor_code,
});
});

return {
results: results
};
}
},
minimumInputLength: 0,
}).on("change", function(e) { 
var url      = "{!! route('debtorInvoice.mainPayment') !!}";


var id=$('#debtor-select-id').val(); 

window.location.href = url+"?id="+id;
});



@stop
