@extends('layouts.pdf')
@section('content')




<header class="clearfix"> 
    <h1>General  Detail</h1>
    <table>
        <tbody>
            <tr>
                <td class="service">INVOICE NO: {!! $invoice->invoice_code !!} </td> 
                <td class="amount">DATE: {!! date("d/m/Y") !!}</td>
            </tr>
            <tr>
                <td class="grand"></td> 
                <td class="grand" ></td>
            </tr>
        </tbody> 
    </table>
    <table>
        <tbody> 
            <tr>
                <th width="100px"></th> 
                <th class="service">Client Detail</th> 
                <th class=" amount"> Debtor Detail</th>

            </tr>
            <tr>
                <td class="  head_size" > Name </td> 
                <td class="service"> {!! $client->name !!} </td> 
                <td class=" amount"> {!! $debtor->name !!} </td> 
            </tr> 
            <tr>
                <td class=" head_size" > Code </td> 
                <td class="service"> {!! $client->client_code !!} </td> 
                <td class=" amount"> {!! $debtor->debtor_code !!} </td> 
            </tr> 
            <tr>
                <td class=" head_size" > Address </td> 
                <td class="service"> {!! $client->address1 !!} <br> {!! $client->address2 !!} </td> 
                <td class=" amount">{!! $debtor->mailing_address !!} <br> {!! $debtor->mailing_suburb !!} </td> 
            </tr>

        </tbody>
    </table>




</header> 

<main  > 
    <h1>Payment Detail</h1>
    <table>
        <thead>
            <tr>
                <th>Debtor to CTC</th>
                <th>CTC to Client</th>
            </tr> 
            <tr>
                <td>
                    <table>
                        <thead>
                            <tr>

                                <th class="desc">DESCRIPTION</th>
                                <th class="amount">amount </th>
                            </tr>
                        </thead>
                        <tbody> 
                            <tr> 

                                <td class="service">Original Debt</td>
                                <td>{!! $invoice->original_debt !!}</td>
                            </tr> 
                            <tr> 

                                <td class="service">Total Collection </td>
                                <td>{!! $total_paid !!}</td>
                            </tr>
                            <tr> 

                                <td class="service">Last Collection {!! $invoice->last_paid !!} </td>
                                <td>{!! $invoice->last_payment !!}</td>
                            </tr> 
                <!--            <tr> 
                                <td class="service"></td>
                                <td class="service"> </td>
                                <td></td>
                            </tr> -->
                            <tr>

                                <td  class="grand service"> Current Balance</td>
                                <td class="grand total">{!! $invoice->current_balance !!}</td>
                            </tr> 

                        </tbody>
                    </table>
                </td> 
                <td>
                    <table>
                        <thead>
                            <tr>

                                <th class="desc">DESCRIPTION</th>
                                <th class="amount">amount </th>
                            </tr>
                        </thead>
                        <tbody> 
                            <tr> 

                                <td class="service">Total Collection </td>
                                <td>{!! $total_paid !!}</td>
                            </tr> 
                            <tr> 

                                <td class="service">Total Paid</td>
                                <td>{!! $clientInvoice->clientTransactions()->sum('amount') !!}</td>
                            </tr>
                            <tr> 

                                <td class="service">Last Payment  </td> 
                                @if($clientInvoice->clientTransactions()->orderBy('id', 'desc')->first()) 
                                
                                   <td>{!! $clientInvoice->clientTransactions()->orderBy('id', 'desc')->first()->amount !!}</td>
                             
                                @else
                                 <td></td>
                                @endif
                            </tr> 
                <!--            <tr> 
                                <td class="service"></td>
                                <td class="service"> </td>
                                <td></td>
                            </tr> -->
                            <tr>

                                <td  class="grand service"> Current Balance</td>
                                <td class="grand total">{!! number_format((float) $total_paid  - (float) $clientInvoice->clientTransactions()->sum('amount'), '2') !!}</td>
                            </tr> 

                        </tbody>
                    </table>
                   
                </td>
            </tr>
        </thead>
    </table>



    <div id="notices">
        <div>NOTICE:</div> 
        <br><br>
        <div class="notice"></div> 
        <table>
            <tbody>
                <tr>
                    <td class="service">............................
                        <br>Date</td> 
                    <td class="amount">..............................<br> Signature
                    </td>
                </tr>

            </tbody> 
        </table>
    </div>
</main>
<footer> 

    ..........................................................................
</footer>
@stop 