@extends('layouts.master')
@section('title')
@parent
Report
@stop

@section('content')
<div class="box">
    <div class="box-header">
        <h3 class="box-title">Report Create</h3>
    </div><!-- /.box-header -->
    <div class="box-body">
        {!! Form::open(array('route' => array('report.store'), 'autocomplete' => 'off')) !!}

        <div class="form-group {!! ($errors->has('name')) ? 'has-error' : '' !!}">
            {!! Form::label('name', 'Name') !!}
            {!! Form::text('name', null, array('class' => 'form-control', 'placeholder' => 'Eg: ragul', 'autocomplete' => 'off')) !!}
            {!! ($errors->has('name') ? $errors->first('name') : '') !!}
        </div>

        <div class="form-group {!! ($errors->has('model_id')) ? 'has-error' : '' !!}">
            {!! Form::label('model_id', 'Module', ['class' => 'control-label']) !!}
            <div class="row">
                <div class="col-md-12">
                    <input type="hidden"  class="model-select" id="model-select-id" name="model_id"> 
                </div> 

            </div>
            <span class="help-block">{!! ($errors->has('model_id') ? $errors->first('model_id') : '') !!}</span>
        </div> 
        <div class="form-group field-data-class {!! ($errors->has('field_id')) ? 'has-error' : '' !!}">
            {!! Form::label('Field_id', 'Field', ['class' => 'control-label']) !!}
            <div class="row ">
                <div class="col-md-12">
                    <input type="hidden"  class="field-select" id="field-select-id" name="field_id"> 
                </div> 

            </div>
            <span class="help-block">{!! ($errors->has('field_id') ? $errors->first('field_id') : '') !!}</span>
        </div> 
        
        
        <div class=" add-condition"> 
            <div class="box">
                <div class="box-header">
                    <h3 class="box-title">Choose filter conditions</h3>
                </div><!-- /.box-header -->
                <div class="box-body">
                    <div class="row"> 
                        <div class="col-md-12">
                        <h4>All Conditions (All conditions must be met)</h4> 

                        </div>
                    </div> 

                   <div class="row">
                       <div class="col-md-12 add-condtion-class add-condtion-and-class"> 



                       </div>
                   </div> 
                   <br>
                   <div class="row"> 
                        <div class="col-md-12">
                            <div class="btn btn-warning" id="add-condtion-btn" >Add Condition</div>

                        </div>
                    </div> 
                    <br><br> 
                    <div class="row"> 
                        <div class="col-md-12">
                        <h4>Any Conditions (At least one of the conditions must be met)</h4> 

                        </div>
                    </div> 

                   <div class="row">
                       <div class="col-md-12 add-condtion-or-class add-condtion-class"> 



                       </div>
                   </div> 
                   <br><br>
                   <div class="row"> 
                        <div class="col-md-12">
                            <div class="btn btn-warning" id="add-condtion-or-btn" >Add Condition</div>

                        </div>
                    </div>
                   
                </div>
           </div>
        </div>


    </div>
    <div class="box-footer clearfix"> 
        <div class=" pull-right">
            {!! Form::submit('Create', array('class' => 'btn btn-success')) !!} &nbsp;&nbsp;
            <a href="{!!URL::route('report.index')!!}" class="btn btn-default">Cancel</a>
            {!!Form::close()!!} 
        </div>
    </div>
</div>  


<div>
    <input type="text" class="datepicker-new date-condition-value form-control" >
</div>

@stop
@section('include-js')
@parent

@stop 

    @section('document-ready-js')
            @parent


            var getModelUrl = '{!! route("model.index") !!}'; 
            var getFieldUrl = '{!! route("field.index") !!}';
var model_id=0;
var model_name='';
$('.field-data-class').hide();

    $('.model-select').select2({
        width: '100%',
        minimumInputLength: 0,
        ajax: {
            url: getModelUrl,
            dataType: 'json',
            quietMillis: 100,
            data: function (term) {
                return {
                    term: term
                };
            },
            results: function (data) {

                console.log(data);
                var results = [];

                $.each(data, function (index, item) {

                    results.push({
                        id: item.id,
                        text: item.name,
                    });
                });

                return {
                    results: results
                };
            }
        }
    }).on("change", function(e) { 
       model_id=e.added.id; 
       model_name=e.added.text;
       $('.field-data-class').show();
        
    });
$('.field-select').select2({
        width: '100%',
        minimumInputLength: 0,
        multiple: true,
        ajax: {
            url: getFieldUrl,
            dataType: 'json',
            quietMillis: 100,
            data: function (term) {
                return {
                    term: term,
                    modelId:model_id
                };
            },
            results: function (data) {

                console.log(data);
                var results = [];

                $.each(data, function (index, item) {

                    results.push({
                        id: item.id,
                        text: item.name,
                    });
                });

                return {
                    results: results
                };
            }
        }
    }); 
    
     function addd(a )
    { 
       
    $('#'+a).select2({
        width: '100%',
        minimumInputLength: 0,
       
        ajax: {
            url: getFieldUrl,
            dataType: 'json',
            quietMillis: 100,
            data: function (term) {
                return {
                    term: term,
                    modelId:model_id
                };
            },
            results: function (data) {

                console.log(data);
                var results = [];

                $.each(data, function (index, item) {

                    results.push({
                        id: item.id,
                        text: item.name,
                    });
                });

                return {
                    results: results
                };
            }
        } 
    }).on("change", function(e) { 
     
       var fieldClass=   $(this).attr('data-condition-id');
           console.log(this);
        
    }); 
    }  
    
     function condtion(condtion )
    { 
       
    $('#'+condtion).select2({
        width: '100%',
        minimumInputLength: 0,
       
        ajax: {
            url: getFieldUrl,
            dataType: 'json',
            quietMillis: 100,
            data: function (term) { 
                
             var fieldClass=   $(this).attr('data-f-id');
             var actionValue= $('#'+fieldClass).val() ;
                return {
                    term: term,
                    modelId:model_id, 
                    action:'condition',
                    actionValue:actionValue
                };
            },
            results: function (data) {

                console.log(data);
                var results = [];

                $.each(data, function (index, item) {

                    results.push({
                        id: item.id,
                        text: item.name,
                    });
                });

                return {
                    results: results
                };
            }
        } 
    }).on("change", function(e) { 
     
       var fieldClass=   $(this).attr('data-v-id');
       var nameCondition= $(this).attr('data-condition-name');
       //alert(nameCondition);
       
        $.ajax({
          url: getFieldUrl+'?action=conditionValue&&actionValue='+$(this).val(),
            dataType: 'json',
            
           
  success: function(result){ 
      var conditionType=result['value_type']; 
      $('.add-condtion-class #div-'+fieldClass).empty();
     $('.datepicker-days').hide();
      if(conditionType != 'hidden')
      {
          
     
      
    $( ".date-condition-value" ).clone().prependTo( '.add-condtion-class #div-'+fieldClass ); 
    
    $( '.add-condtion-class #div-'+fieldClass +' input').attr('name', nameCondition ).removeClass('date-condition-value');
    
     // $('.add-condtion-class #'+'condition-value-id1').addClass('datepicker');
     //$('#'+fieldClass).addClass('datepicker'); 
     //alert(conditionType);
     if(conditionType == 'date')
     {
     
     var checkout = $( '.add-condtion-class #div-'+fieldClass +' input').datepicker({
                    format: 'yyyy-mm-dd',
                    scrollInput: false,
                    
                }).on('changeDate', function (ev) {
                    $('.datepicker-days').hide();
                }).data('datepicker');
           
        } 
    }
    }
        
});
        
    });  
    } 
    
    var tt=1;
    $('#add-condtion-btn').click(function()
            { 
                var conditionHtml='<div class="row condition-top-calss">'
                        +'<div class="col-md-3" ><input type="hidden"  class="condtion-select-value"  value="and"    name="condition_type_'+tt+'"><input type="hidden"  class="field-select-value" data-condition-id="condtion-select-id'+tt+'"   id="field-select-id'+tt+'" name="field_id_'+tt+'"> </div>'
                        +'<div class="col-md-3" ><input type="hidden"  class="condtion-select-value" data-condition-name="condition_value_'+tt+'" data-v-id="condition-value-id'+tt+'" data-f-id="field-select-id'+tt+'"  id="condition-select-id'+tt+'" name="condition_id_'+tt+'"></div>'
                        +'<div class="col-md-4" id="div-condition-value-id'+tt+'"  > </div>'
                        + '<div class="col-md-2" ><div class="add-condition-delete-btn btn" ><i class="fa  fa-archive " rel="tooltip" title="Delete">  </i></div></div>'
                        +'</div>';
                $(".add-condtion-and-class").append(conditionHtml); 
               
                addd("field-select-id"+tt); 
                condtion("condition-select-id"+tt );
                 tt=tt+1;
            }
            );  
    
    $('#add-condtion-or-btn').click(function()
            { 
                var conditionHtml='<div class="row condition-top-calss">'
                        +'<div class="col-md-3" ><input type="hidden"  class="condtion-select-value"  value="or"    name="condition_type_'+tt+'"><input type="hidden"  class="field-select-value" data-condition-id="condtion-select-id'+tt+'"   id="field-select-id'+tt+'" name="field_id_'+tt+'"> </div>'
                        +'<div class="col-md-3" ><input type="hidden"  class="condtion-select-value" data-condition-name="condition_value_'+tt+'" data-v-id="condition-value-id'+tt+'" data-f-id="field-select-id'+tt+'"  id="condition-select-id'+tt+'" name="condition_id_'+tt+'"></div>'
                        +'<div class="col-md-4" id="div-condition-value-id'+tt+'"  > </div>'
                        + '<div class="col-md-2" ><div class="add-condition-delete-btn btn" ><i class="fa  fa-archive " rel="tooltip" title="Delete">  </i></div></div>'
                        +'</div>';
                $(".add-condtion-or-class").append(conditionHtml); 
               
                addd("field-select-id"+tt); 
                condtion("condition-select-id"+tt );
                 tt=tt+1;
            }
            ); 
    $('.add-condition').on( "click", ".add-condition-delete-btn", function() {
           
                
                console.log($(this).parent().parent().remove());
                
            });

    @stop


