@extends('layouts.master')
@section('title')
@parent
Report edit
@stop

@section('content')
<div class="box">
    <div class="box-header">
        <h3 class="box-title">Solicitor edit</h3>
    </div><!-- /.box-header -->
    <div class="box-body">
        {!! Form::model($report, ['method' => 'PATCH', 'route' => ['report.update', $report->id]]) !!}

       
         <div class="form-group {!! ($errors->has('name')) ? 'has-error' : '' !!}">
            {!! Form::label('name', 'Name') !!}
            {!! Form::text('name', null, array('class' => 'form-control', 'placeholder' => 'Eg: Total', 'autocomplete' => 'off')) !!}
            {!! ($errors->has('name') ? $errors->first('name') : '') !!}
        </div> 
        
        <div class="form-group {!! ($errors->has('model_id')) ? 'has-error' : '' !!}">
            {!! Form::label('debtor_id', 'Model', ['class' => 'control-label']) !!}
            <div class="row">
                <div class="col-md-12">
                    <input type="hidden"  class="model-select" id="model-select-id" value="{!! $report->model_id !!}" name="model_id"> 
                </div> 

            </div>
            <span class="help-block">{!! ($errors->has('model_id') ? $errors->first('model_id') : '') !!}</span>
        </div>  
        
          <div class="form-group field-data-class {!! ($errors->has('field_id')) ? 'has-error' : '' !!}">
            {!! Form::label('Field_id', 'Field', ['class' => 'control-label']) !!}
            <div class="row ">
                <div class="col-md-12">
                    <input type="hidden"  class="field-select" value="1" id="field-select-id" name="field_id"> 
                </div> 

            </div>
            <span class="help-block">{!! ($errors->has('field_id') ? $errors->first('field_id') : '') !!}</span>
        </div>

        <ul class="field-id-hide" >
            @foreach($report->fields as $field)
            
            <li data-id="{!! $field->id !!}" data-name="{!! $field->name !!}" ></li>
  @endforeach
</ul>
        
        
    </div>
    <div class="box-footer clearfix"> 
        <div class=" pull-right">
            {!! Form::submit('Update', array('class' => 'btn btn-info')) !!} &nbsp;&nbsp;
            <a href="{!!URL::route('report.index')!!}" class="btn btn-default">Cancel</a>
            {!!Form::close()!!} 
        </div>
    </div>
</div>

@stop
@section('include-js')
@parent

@stop
<script>
    @section('document-ready-js')
            @parent


            var getModelUrl = '{!! route("model.index") !!}'; 
            var getFieldUrl = '{!! route("field.index") !!}';
var model_id={!! $report->model_id !!};
var model_name='';
$('.field-id-hide').hide();
    $('.model-select').select2({
        width: '100%',
        minimumInputLength: 1,
        ajax: {
            url: getModelUrl,
            dataType: 'json',
            quietMillis: 100,
            data: function (term) {
                return {
                    term: term
                };
            },
            results: function (data) {

                console.log(data);
                var results = [];

                $.each(data, function (index, item) {

                    results.push({
                        id: item.id,
                        text: item.name,
                    });
                });

                return {
                    results: results
                };
            }
        },
        initSelection : function (element, callback) { 
            
        var data = {id: {!! $report->model_id !!}, text: {!! "'".$report->model->name."'" !!} };
        callback(data);
    }
    }).on("change", function(e) { 
       model_id=e.added.id; 
       model_name=e.added.text;
      
        
    });
$('.field-select').select2({
        width: '100%',
        minimumInputLength: 1,
        multiple: true,
        ajax: {
            url: getFieldUrl,
            dataType: 'json',
            quietMillis: 100,
            data: function (term) {
                return {
                    term: term,
                    modelId:model_id
                };
            },
            results: function (data) {

                console.log(data);
                var results = [];

                $.each(data, function (index, item) {

                    results.push({
                        id: item.id,
                        text: item.name,
                    });
                });

                return {
                    results: results
                };
            }
        } ,
        initSelection : function (element, callback) {
        var data = [];
        
        $('.field-id-hide li').each(function () {
            console.log($( this ).attr('data-id'));
            data.push({id: $( this ).attr('data-id'), text: $( this ).attr('data-name')});
        });
        callback(data);
    }
    });

    @stop
</script>

