@extends('layouts.master')
@section('title')
@parent
Report
@stop

@section('content')
<div class="box">
    <div class="box-header"> 
        <div class="row" >
            <div class="col-md-3">
                <h3 class="box-title">{!! $report->name.' from '.$valueString !!}</h3> 
            </div> 
            <div class="col-md-2">

                <div class="row" > 
                    <div class="col-md-12">
                        <input class="form-control"  value="{!! $valueString !!}"  id="month-select" > 
                    </div>

                </div>

            </div> 


        </div>


    </div><!-- /.box-header -->
    <div class="box-body">


        <table class="table table-bordered">
            <tr> 
                <th>Client name </th> 
                <th>Last data of month</th> 

                <th>Opening Amount	 </th> 



            </tr>  

            
            @foreach($openingBalance->whereRaw('MONTH(last_date_of_month) = "' . $month . '"')->whereRaw('YEAR(last_date_of_month) = "' . $year . '"')->get() as $data) 
            
           
            <tr> 

                <td>{!! $data->client->name !!}</td>  
                <td>{!!  $data->last_date_of_month !!}
                    
                </td>  
                <td  >  {!! number_format( $data->opening_amount_for_next_month, 2) !!}</td>  


            </tr> 
            
           
            @endforeach
             
             
        </table>


    </div><!-- /.box-body -->
    <div class="box-footer clearfix">

    </div>
</div>

@stop
@section('include-js')
@parent

@stop


@section('document-ready-js')
@parent 
var value= {!! "'".$value."'" !!};

$('#month-select').monthpicker().bind('monthpicker-click-month', function (e, month) {
var url      = "{!! route('fixed.report.show', [$report->id]) !!}";
value = $(this).val(); 


window.location.href = url+"?filter=filter&&value="+value;
});



$( "#from" ).change(function() { 

fromTo();


}); 
$( "#to" ).change(function() {
fromTo();
});

function  fromTo()
{

var url      = "{!! route('fixed.report.show', [$report->id]) !!}";

var from = $('#from').val(); 
var to = $('#to').val();
window.location.href = url+"?filter=filter&&from="+from+'&&to='+to;
} 

$('.pdf-class').attr("href", window.location.href+'&&action=pdf');

@stop

