@extends('layouts.master')
@section('title')
@parent
Report
@stop

@section('content')
<div class="box">
    <div class="box-header"> 
        <div class="row" >
            <div class="col-md-3">
                 <h3 class="box-title">{!! $report->name !!}</h3> 
            </div> 
            <div class="col-md-2">
               
                    <div class="row" > 
                        <div class="col-md-12">
                    <input class="form-control"  value="{!! $valueString !!}"  id="month-select" > 
                    </div>
                       
                    </div>
               
            </div> 
            <div class="col-md-6"> 
                <div class="row"> 
                    <div class="col-md-6"> 
                        <div class="row"> 
                            <div class="col-md-3">
                                From
                            </div>
                            <div class="col-md-9">
                                <input name="from" value="{!! $from !!}" class="datepicker" id="from"> 
                            </div>
                        </div>
                        
                    </div> 
                    <div class="col-md-6"> 
                        <div class="row"> 
                            <div class="col-md-3">
                                To
                            </div>
                            <div class="col-md-9">
                                <input name="to" value="{!! $to  !!}" class="datepicker" id="to" > 
                            </div>
                        </div>
                        
                    </div> 
                     
                </div>
              
            </div>
            <div class="col-md-1">
                <div class=" pull-right">  
                    
                    @if($to == ''  && $from == ''  )
                 
                    <a class="btn btn-default" href="{!! route('fixed.report.show', [$report->id] ).'?type=export&&action=pdf&&filter=filter&&value='.$value!!}" >PDF</a> 
                   @else
                    <a class="btn btn-default" href="{!! route('fixed.report.show', [$report->id] ).'?type=export&&action=pdf&&filter=filter&&from='.$from.'&&'.'to'.$to !!}" >PDF</a> 
                    @endif
                </div>
            </div>
        </div>
       
        
    </div><!-- /.box-header -->
    <div class="box-body">
        
      
       <table class="table table-bordered">
            <tr> 
                <th>Debtor Name </th> 
                <th>Card Holder's Name</th> 
                 
                <th>Card Number</th> 
                  <th>Expiry Date </th> 
                <th> Amount</th>
              
                
            </tr> 

           
        @foreach($datas as $data)
           <tr>
               <td> {!! $data['debtor_name'] !!} </td> 
              <td> {!! $data['name_on_card']  !!} </td>
            <td style=""> 
                <?php 
               $cardNumber =  substr($data['card_number'], -4); 
              $lenth = strlen($data['card_number']); 
              $cardString = '';
              for($i=0; $lenth> $i ; $i++  )
              {
                 $cardString=$cardString.'*';
              } 
              $cardString = $cardString.$cardNumber;
                ?>
                {!! $cardString !!} </td> 
              <td style="">{!! $data['card_expiry_date']  !!} </td> 
                <td style="text-align: right;" >{!! $data['amount'] !!} </td> 
             
            
             
         </tr> 
         @endforeach
        </table>
       
       
    </div><!-- /.box-body -->
    <div class="box-footer clearfix">

    </div>
</div>

@stop
@section('include-js')
@parent

@stop


    @section('document-ready-js')
            @parent 
  var value= {!! "'".$value."'" !!};
 
$('#month-select').monthpicker().bind('monthpicker-click-month', function (e, month) {
var url      = "{!! route('fixed.report.show', [$report->id]) !!}";
    value = $(this).val(); 
  
    
window.location.href = url+"?filter=filter&&value="+value;
});



    $( "#from" ).change(function() { 
    
    fromTo();

    
}); 
 $( "#to" ).change(function() {
  fromTo();
});
 
        function  fromTo()
        {
           
         var url      = "{!! route('fixed.report.show', [$report->id]) !!}";
            
    var from = $('#from').val(); 
    var to = $('#to').val();
            window.location.href = url+"?filter=filter&&from="+from+'&&to='+to;
        } 
        
        $('.pdf-class').attr("href", window.location.href+'&&action=pdf');

            @stop

