@extends('layouts.master')
@section('title')
@parent
Report
@stop

@section('content')
<div class="box">
    <div class="box-header"> 
        <div class="row" >
            <div class="col-md-3">
                <h3 class="box-title">{!! $report->name !!}</h3> 
            </div> 
            <div class="col-md-7">

                <div class="row" > 
                    <div class="col-md-4">
                        <input class="form-control" value="{!! $valueString !!}"  id="month-select" > 
                    </div>
                    <div class="col-md-4">
                        <input type="hidden"  class="client-select" value=""  id="client-select-id" name="client_id"> 
                    </div> 
                    <div class="col-md-4">
                         
                        <input type="hidden"  class="invoice-state-select" id="invoice-state-select-id" name="invoice_status_code_id"> 
                    
                    </div>
                </div>

            </div> 
            <div class="col-md-2">
                <div class=" pull-right"> 
                    @if($clientArray['set']  == 'yes') 
                    <a class="btn btn-default" href="{!! route('fixed.report.show', [$report->id] ).'?type=export&&action=excel5&&filter=filter&&value='.$value.'&&clientId='.$clientArray['id'] !!}" >Excel</a> 
                    @else

                    <a class="btn btn-default" href="{!! route('fixed.report.show', [$report->id] ).'?type=export&&action=excel5&&filter=filter&&value='.$value !!}" >Excel</a> 
                    @endif
                </div>
            </div>
        </div>


    </div> 
    <div class="box-body">


        <table class="table table-bordered">
            <tr> 
                <th>Debtor Name</th> 
                <th>Debtor Address </th> 
                <th>Debtor Code </th> 
                  <th>Invoice Code </th> 
                <th>Original Debt</th> 
                <th>Current Balance </th> 
                <th> Amount</th>
                <th>Payment Date </th> 

                <th>Where Paid </th> 
                <th>Previous Status </th>
                <th>Current Status </th>

            </tr> 

            @foreach($datas as $data) 
            <tr>
                <td> {!! $data['DebtorName'] !!} </td> 
                <td> {!! $data['DebtorAddress']  !!} </td>
                <td style="">{!! $data['DebtorCode']  !!} </td> 
                <td style="">{!! $data['invoiceCode']  !!} </td>

                <td style="text-align: right;" >{!! $data['OriginalDebt'] !!} </td> 
                <td style="text-align: right;" >{!! $data['CurrentBalance'] !!} </td>
                <td style="text-align: right;" >{!! $data['amount'] !!} </td>  
                <td style="">{!! $data['paymentDate']  !!} </td>
                <td style="">{!! $data['WherePaid']  !!} </td>
                <td style="">{!! $data['PreviousStatus']  !!} </td>
                <td style="">{!! $data['CurrentStatus']  !!} </td>

            </tr>




            @endforeach  
        </table>
    </div>
    <div class="box-footer clearfix">

    </div> 
</div>

<!-- /.box-body -->


@stop
@section('include-js')
@parent

@stop


@section('document-ready-js')
@parent 

var getClientUrl = '{!! route("client.index") !!}'; 
var value= {!! "'".$value."'" !!};

$('.client-select').select2({
width: '100%',
minimumInputLength: 0,
ajax: {
url: getClientUrl,
dataType: 'json',
quietMillis: 100,
data: function (term) {
return {
term: term
};
},
results: function (data) {

console.log(data);
var results = [];

$.each(data, function (index, item) {

results.push({
id: item.id,
text: item.name,
});
});

return {
results: results
};
}
},
initSelection : function (element, callback) { 

var data = {id: {!! $client->id !!}, text: {!! "'".$client->name."'" !!} };
callback(data);
}
}).on("change", function(e) { 
var url      = "{!! route('fixed.report.show', [$report->id]) !!}";


var clientId=$('#client-select-id').val(); 

window.location.href = url+"?filter=filter&&value="+value+'&&clientId='+clientId;
});

$('#month-select').monthpicker().bind('monthpicker-click-month', function (e, month) {
var url      = "{!! route('fixed.report.show', [$report->id]) !!}";
value = $(this).val(); 
var clientId=$('#client-select-id').val(); 

window.location.href = url+"?filter=filter&&value="+value+'&&clientId='+clientId;
}); 
if ("{!! $clientArray['set'] !!}" == 'yes')
{
$('body .client-select .select2-chosen').text("{!! $clientArray['name'] !!}" + ' ' + "{!! $clientArray['code'] !!}");
$('body  #client-select-id').val("{!! $clientArray['id'] !!}");
} 



var getInvoiceStateUrl = '{!! route("invoiceStatusCode.index") !!}';
$('.invoice-state-select').select2({
width: '100%',

ajax: {
url: getInvoiceStateUrl,
dataType: 'json',
quietMillis: 100,
data: function (term) {
return {
term: term
};
},
results: function (data) {


var results = [];

$.each(data, function (index, item) {

results.push({
id: item.id,
text: item.code+ ' ' + item.description,
});
});

return {
results: results
};
}
},
minimumInputLength: 0,
}).on("change", function(e) { 
var url      = "{!! route('fixed.report.show', [$report->id]) !!}";


var clientId=$('#client-select-id').val();  

var invoiceStateCodeId = $('#invoice-state-select-id').val();

window.location.href = url+"?filter=filter&&value="+value+'&&clientId='+clientId+'&&invoiceStateCodeId='+invoiceStateCodeId;
});

if ("{!! $clientArray['set'] !!}" == 'code')
{
$('body .invoice-state-select .select2-chosen').text("{!! $clientArray['invoiceStateCode'] !!}" );

} 
@stop

