@extends('layouts.master')
@section('title')
@parent
Report
@stop

@section('content')
<div class="box">
    <div class="box-header"> 
        <div class="row" >
            <div class="col-md-3">
                <h3 class="box-title">{!! $report->name !!}</h3> 
            </div> 
            <div class="col-md-2">

                <div class="row" > 
                    <div class="col-md-12">
                        <input class="form-control"  value="{!! $valueString !!}"  id="month-select" > 
                    </div>

                </div>

            </div> 
            <div class="col-md-6"> 
                <div class="row"> 
                    <div class="col-md-6"> 
                        <div class="row"> 
                            <div class="col-md-3">
                                From
                            </div>
                            <div class="col-md-9">
                                <input name="from" value="{!! $from !!}" class="datepicker" id="from"> 
                            </div>
                        </div>

                    </div> 
                    <div class="col-md-6"> 
                        <div class="row"> 
                            <div class="col-md-3">
                                To
                            </div>
                            <div class="col-md-9">
                                <input name="to" value="{!! $to  !!}" class="datepicker" id="to" > 
                            </div>
                        </div>

                    </div> 

                </div>

            </div>
            <div class="col-md-1">
                <div class=" pull-right">  

                    @if($to == ''  && $from == ''  )

                    <a class="btn btn-default" href="{!! route('fixed.report.show', [$report->id] ).'?type=export&&action=pdf&&filter=filter&&value='.$value!!}" >PDF</a> 
                    @else
                    <a class="btn btn-default" href="{!! route('fixed.report.show', [$report->id] ).'?type=export&&action=pdf&&filter=filter&&from='.$from.'&&'.'to'.$to !!}" >PDF</a> 
                    @endif
                </div>
            </div>
        </div>


    </div><!-- /.box-header -->
    <div class="box-body">


        <table class="table table-bordered">
            <tr> 
                <th>Payee </th> 
                <th>Bank</th> 
                <th>Payment Type</th> 
                <th>Branch</th> 
                <th>Cheque No</th> 
                <th> Amount</th>


            </tr> 


            @foreach($datas as $data)
            <tr>
                <td> {!! $data['debtor_name'] !!} </td> 
                <td> {!! $data['bank']  !!} </td> 
                 <td> {!! $data['payment_type']  !!} </td>
                <td style=""> 
                    {!! $data['branch']  !!}
                </td>  
                <td style=""> 
                    {!! $data['cheque_no']  !!}
                </td> 

                <td style="text-align: right;" >{!! $data['amount'] !!} </td> 



            </tr> 
            @endforeach
        </table>


    </div><!-- /.box-body -->
    <div class="box-footer clearfix">

    </div>
</div>

@stop
@section('include-js')
@parent

@stop


@section('document-ready-js')
@parent 
var value= {!! "'".$value."'" !!};

$('#month-select').monthpicker().bind('monthpicker-click-month', function (e, month) {
var url      = "{!! route('fixed.report.show', [$report->id]) !!}";
value = $(this).val(); 


window.location.href = url+"?filter=filter&&value="+value;
});



$( "#from" ).change(function() { 

fromTo();


}); 
$( "#to" ).change(function() {
fromTo();
});

function  fromTo()
{

var url      = "{!! route('fixed.report.show', [$report->id]) !!}";

var from = $('#from').val(); 
var to = $('#to').val();
window.location.href = url+"?filter=filter&&from="+from+'&&to='+to;
} 

$('.pdf-class').attr("href", window.location.href+'&&action=pdf');

@stop

