@extends('layouts.master')
@section('title')
@parent
Collection Action Code edit
@stop

@section('content')

<div class="row">
    <div class="col-sm-12">
        <h4 class="pull-left page-title"> </h4>
        <ol class="breadcrumb pull-right">
            <li><a href="{!! route('home.index') !!}">Dashboard</a></li>
            <li><a href="{!! route('collectionActionCode.index') !!}">Collection Action Code</a></li>
            <li class="active">Collection Action Code Edit</li>
        </ol>
    </div>
</div>

<div class="panel panel-default">
    <div class="panel-heading">
        <div class="row"> 
            <div class="col-md-12">
                <div class="panel-heading pull-left">
                    <h3 class="panel-title"> Collection Action Code {!! $collectionActionCode->name !!} Edit </h3>
                </div>

                <div class="pull-right">

                </div> 
            </div>
        </div>
    </div>
    <div class="panel-body">

        {!! Form::model($collectionActionCode, ['method' => 'PATCH', 'route' => ['collectionActionCode.update', $collectionActionCode->id]]) !!}


         <div class="form-group {!! ($errors->has('code')) ? 'has-error' : '' !!}">
            {!! Form::label('code', 'Code') !!}
            {!! Form::text('code', null, array('class' => 'form-control', 'placeholder' => 'code', 'autocomplete' => 'off')) !!}
            {!! ($errors->has('code') ? $errors->first('code') : '') !!}
        </div>

        <div class="form-group {!! ($errors->has('description')) ? 'has-error' : '' !!}">
            {!! Form::label('description', 'Description') !!}
            {!! Form::text('description', null, array('class' => 'form-control', 'placeholder' => 'description', 'autocomplete' => 'off')) !!}
            {!! ($errors->has('email') ? $errors->first('email') : '') !!}
        </div>
         <div class="form-group {!! ($errors->has('form')) ? 'has-error' : '' !!}">
            {!! Form::label('form', 'Form') !!}
            {!! Form::text('form', null, array('class' => 'form-control', 'placeholder' => 'form', 'autocomplete' => 'off')) !!}
            {!! ($errors->has('form') ? $errors->first('form') : '') !!}
        </div>

        <div class="form-group {!! ($errors->has('prtr_disc')) ? 'has-error' : '' !!}">
            {!! Form::label('prtr_disc', 'Prtr/Disc') !!}
            {!! Form::text('prtr_disc', null, array('class' => 'form-control', 'placeholder' => '', 'autocomplete' => 'off')) !!}
            {!! ($errors->has('prtr_disc') ? $errors->first('prtr_disc') : '') !!}
        </div> 
        <div class="form-group {!! ($errors->has('fee_schedules')) ? 'has-error' : '' !!}">
            {!! Form::label('fee_schedules', 'Fee Schedules') !!}
            {!! Form::text('fee_schedules', null, array('class' => 'form-control', 'placeholder' => 'Fee Schedules', 'autocomplete' => 'off')) !!}
            {!! ($errors->has('fee_schedules') ? $errors->first('fee_schedules') : '') !!}
        </div>


    </div>
    <div class="panel-footer">
        {!! Form::submit('Update', array('class' => 'btn btn-success')) !!} &nbsp;&nbsp;
        <a href="{!!URL::route('collectionActionCode.index')!!}" class="btn btn-default">Cancel</a>
        {!!Form::close()!!} 
    </div>
</div>

@stop
@section('include-js')
@parent

@stop

