@extends('layouts.master')
@section('title')
@parent
Debt Type
@stop

@section('content')

<div class="row">
    <div class="col-sm-12">
        <h4 class="pull-left page-title"> </h4>
        <ol class="breadcrumb pull-right">
            <li><a href="{!! route('home.index') !!}">Dashboard</a></li>
            <li class="active">Debt Type</li>
        </ol>
    </div>
</div>

<div class="panel panel-default">
    <div class="panel-heading">
        <div class="row"> 
            <div class="col-md-12">
                <div class="panel-heading pull-left">
                    <h3 class="panel-title">Debt Type </h3>
                </div>

                <div class="pull-right">
                    {!! link_to_route('debtType.create' , 'Add Debt Type', [], ['class' => 'btn btn-primary btn-create']) !!}  
                </div> 
            </div>
        </div>
    </div><!-- /.box-header -->
    <div class="panel-body table-rep-plugin"> 
        <div class="table-responsive" data-pattern="priority-columns">
            <table id="tech-companies-1" class="table table-small-font table-bordered table-striped">
                <tr>
                    <thead>
                    <th style="width: 10px">#</th>
                    <th data-priority="1" >Code</th> 
                    <th data-priority="3" >Description</th>


                    <th data-priority="3" >Action</th> 
            </thead>
                </tr> 
                <tbody>
                @foreach($debtTypes as $debtType)

                <tr>
                    <td></td>
                    <td>{!!$debtType->code !!}</td>
                    <td>{!!$debtType->description !!}</td>
                  <td>

                        <a href="{!! route('debtType.edit', [$debtType->id]) !!}"><i class="fa  fa-edit" rel="tooltip" title="Edit"></i>  </a>&nbsp;&nbsp;
                        <a href="{!! route('debtType.delete', [$debtType->id]) !!}"><i class="fa  fa-archive" rel="tooltip" title="Delete"></i>  </a>


                    </td>
                </tr>
                @endforeach 
                </tbody>
            </table>
        </div>                                           
    </div><!-- /.box-body -->
    <div class="panel-footer">
        {!! $debtTypes->render() !!}
    </div>
</div>

@stop
@section('include-js')
@parent

@stop

