@extends('layouts.master')
@section('title')
@parent
Home
@stop

@section('content') 
<div class="row">
    <div class="col-sm-12">
        <h4 class="pull-left page-title"> </h4>
        <ol class="breadcrumb pull-right">
            <li><a href="{!! route('home.index') !!}">Dashboard</a></li>
            <li><a href="{!! route('user.index') !!}">User</a></li>
            <li class="active">User Add</li>
        </ol>
    </div>
</div>
<div class="panel panel-default">
    <div class="panel-heading">
        <div class="row"> 
            <div class="col-md-12">
                <div class="panel-heading pull-left">
                    <h3 class="panel-title"> User  Add </h3>
                </div>

                <div class="pull-right">

                </div> 
            </div>
        </div>
    </div><!-- /.box-header -->
    <div class="panel-body">
        <div class="row"> 
            <div class="col-md-6">
                {!! Form::open(array('route' => array('user.store'), 'autocomplete' => 'off')) !!}

                <div class="form-group {!! ($errors->has('email')) ? 'has-error' : '' !!}">
                    {!! Form::label('email', 'Email') !!}
                    {!! Form::text('email', null, array('class' => 'form-control', 'placeholder' => 'Eg: example@example.com', 'autocomplete' => 'off')) !!}
                    {!! ($errors->has('email') ? $errors->first('email') : '') !!}
                </div>
                <div class="form-group pass-wrapper {!! ($errors->has('password')) ? 'has-error' : '' !!}">
                    {!! Form::label('password', 'Password') !!}
                    {!! Form::password('password', array('class' => 'form-control', 'placeholder' => 'password', 'autocomplete' => 'off')) !!}
                    {!! ($errors->has('password') ?  $errors->first('password') : '') !!}
                </div>
                <div class="form-group pass-wrapper {!! ($errors->has('password_confirmation')) ? 'has-error' : '' !!}">
                    {!! Form::label('password_confirmation', 'Confirm password') !!}
                    {!! Form::password('password_confirmation', array('class' => 'form-control', 'placeholder' => 'Retype the password', 'autocomplete' => 'off')) !!}
                    {!! ($errors->has('password_confirmation') ?  $errors->first('password_confirmation') : '') !!}
                </div> 
                <div class="form-group {!! ($errors->has('group_id')) ? 'has-error' : '' !!}">
                    {!! Form::label('group_id', 'Group', ['class' => 'control-label']) !!}
                    {!!  Form::select('group_id',  $groups, null  ,['class' => 'form-control', 'placeholder' => 'state', 'required'])  !!}
                    <span class="help-block">{!! ($errors->has('group_id') ? $errors->first('group_id') : '') !!}</span>
                </div> 

            </div>

            <div class="col-md-6"> 

                <div class="form-group {!! ($errors->has('first_name')) ? 'has-error' : '' !!}">
                    {!! Form::label('first_name', 'First name') !!}
                    {!! Form::text('first_name', null, array('class' => 'form-control', 'placeholder' => 'Eg: Ryan')) !!}
                    {!! ($errors->has('name') ? $errors->first('first_name') : '') !!}
                </div>  



                <div class="form-group {!! ($errors->has('last_name')) ? 'has-error' : '' !!}">
                    {!! Form::label('last_name', 'Last name') !!}
                    {!! Form::text('last_name', null, array('class' => 'form-control', 'placeholder' => 'Eg: Emery')) !!}
                    {!! ($errors->has('last_name') ? $errors->first('last_name') : '') !!}
                </div>  
                <div class="form-group {!! ($errors->has('phone_number')) ? 'has-error' : '' !!}">
                    {!! Form::label('phone_number', 'Phone number') !!}
                    {!! Form::text('phone_number', null, array('class' => 'form-control', 'placeholder' => 'Eg: 0065222569633')) !!}
                    {!! ($errors->has('phone_number') ? $errors->first('first_name') : '') !!}
                </div>  

            </div> 
        </div> 
    </div>
    <div class="panel-footer">     
        {!! Form::submit('Add', array('class' => 'btn btn-success')) !!} &nbsp;&nbsp;
        <a href="{!!URL::route('user.index')!!}" class="btn btn-default">Cancel</a>
        {!!Form::close()!!} 
    </div>
</div>

@stop
@section('include-js')
@parent

@stop

