@extends('layouts.master')
@section('title')
@parent
User delete
@stop

@section('content')
<div class="box">
    <div class="box-header">
        <h3 class="box-title">Users {!! $user->first_name.' '. $user->last_name !!}</h3>
    </div> 
    {!! Form::model($user, ['method' => 'DELETE', 'route' => ['user.destroy',   $user->id]]) !!} 
    <div class="box-body">
           <div class="nav-tabs-custom">
            @include('users/nav')
            <div class="tab-content">
                <div class="tab-pane active"> 
            <p>Are you sure to delete <del>{!! $user->first_name.' '. $user->last_name !!}</del> user?</p>  
                </div>
            </div>
           </div>
    </div>
    
    <div class="box-footer clearfix"> 
        <div class=" pull-right">
          {!! Form::submit('Delete', array('class' => 'btn btn-danger')) !!}
                {!! link_to_route('user.index', 'Cancel', [], ['class' => 'btn btn-default']) !!}
        </div>
    </div>
</div>
    

@stop
@section('include-js')
@parent

@stop

