@extends('layouts.master')
@section('title')
@parent
user edit
@stop

@section('content')
<div class="box">
    <div class="box-header">
       
    </div><!-- /.box-header -->
    <div class="box-body">  
        <div class="nav-tabs-custom">
            @include('users/nav')
            <div class="tab-content">
                <div class="tab-pane active">  
                    {!! Form::model($user, ['method' => 'PATCH', 'route' => ['user.update', $user->id]]) !!}

                    <div class="box box-info">
                        <div class="box-header">
                            <h3 class="box-title">User edit</h3>
                        </div> 
                        <div class="box-body">
                            <div class="row"> 
                                <div class="col-md-6">

                                    <div class="form-group {!! ($errors->has('email')) ? 'has-error' : '' !!}">
                                        {!! Form::label('email', 'Email') !!}
                                        {!! Form::text('email', null, array('class' => 'form-control', 'placeholder' => 'Eg: example@example.com', 'autocomplete' => 'off', 'readonly')) !!}
                                        {!! ($errors->has('email') ? $errors->first('email') : '') !!}
                                    </div> 
                                    <div class="form-group {!! ($errors->has('group_id')) ? 'has-error' : '' !!}">
                                        {!! Form::label('group_id', 'Group', ['class' => 'control-label']) !!}
                                        {!!  Form::select('group_id',  $groups, null  ,['class' => 'form-control', 'placeholder' => 'state', 'required'])  !!}
                                        <span class="help-block">{!! ($errors->has('group_id') ? $errors->first('group_id') : '') !!}</span>
                                    </div> 
                                </div>
                                <div class="col-md-6">

                                    <div class="form-group {!! ($errors->has('first_name')) ? 'has-error' : '' !!}">
                                        {!! Form::label('first_name', 'First name') !!}
                                        {!! Form::text('first_name', null, array('class' => 'form-control', 'placeholder' => 'Eg: Ryan')) !!}
                                        {!! ($errors->has('name') ? $errors->first('first_name') : '') !!}
                                    </div> 
                                    <div class="form-group {!! ($errors->has('last_name')) ? 'has-error' : '' !!}">
                                        {!! Form::label('last_name', 'Last name') !!}
                                        {!! Form::text('last_name', null, array('class' => 'form-control', 'placeholder' => 'Eg: Emery')) !!}
                                        {!! ($errors->has('last_name') ? $errors->first('last_name') : '') !!}
                                    </div>  
                                     <div class="form-group {!! ($errors->has('phone_number')) ? 'has-error' : '' !!}">
                                        {!! Form::label('phone_number', 'Phone number') !!}
                                        {!! Form::text('phone_number', null, array('class' => 'form-control', 'placeholder' => 'Eg: 0065222569633')) !!}
                                        {!! ($errors->has('phone_number') ? $errors->first('first_name') : '') !!}
                                    </div>  


                                </div> 
                            </div> 
                        </div> 
                    </div>

                </div>
            </div>

        </div>
    </div>
    <div class="box-footer clearfix"> 
        <div class=" pull-right">
            {!! Form::submit('Update', array('class' => 'btn btn-info')) !!} &nbsp;&nbsp;
            <a href="{!!URL::route('user.index')!!}" class="btn btn-default">Cancel</a>
            {!!Form::close()!!} 
        </div>
    </div>
</div>

@stop
@section('include-js')
@parent

@stop

