@extends('layouts.master')
@section('title')
@parent
Users
@stop

@section('content') 

<div class="row">
    <div class="col-sm-12">
        <h4 class="pull-left page-title"> </h4>
        <ol class="breadcrumb pull-right">
            <li><a href="{!! route('home.index') !!}">Dashboard</a></li>
            <li class="active">User</li>
        </ol>
    </div>
</div>


<div class="panel panel-default">
    <div class="panel-heading">
        <div class="row"> 
            <div class="col-md-12">
                <div class="panel-heading pull-left">
                    <h3 class="panel-title">User</h3>
                </div>

                <div class="pull-right">
                    {!! link_to_route('user.create' , 'Add user', [], ['class' => 'btn btn-primary btn-create']) !!}
                </div> 
            </div>
        </div>
    </div>

    <div class="panel-body table-rep-plugin"> 
        <div class="table-responsive" data-pattern="priority-columns">
            <table id="tech-companies-1" class="table table-small-font table-bordered table-striped">
                <thead>
                    <tr>
                        <th style="width: 10px">#</th>
                        <th data-priority="1" >First name</th>
                        <th data-priority="1" >Last name</th>
                        <th  >Email</th> 
                        <th data-priority="1" >Role</th>
                        <th data-priority="1" >Action</th>
                    </tr> 
                </thead>
                <tbody>
                    @foreach($users as $user)

                    <tr>
                        <td></td>
                        <td>{!!$user->first_name !!}</td>
                        <td>{!! $user->last_name !!}</td>
                        <td>
                            {!! $user->email !!}
                        </td>
                        <td> {!! $user->group->name !!}</td>
                        <td> 
                            <a href="{!! route('user.edit', [$user->id]) !!}"><i class="fa  fa-edit" rel="tooltip" title="Edit"></i>  </a>&nbsp;&nbsp;
                            <a href="{!! route('user.delete', [$user->id]) !!}"><i class="fa  fa-archive" rel="tooltip" title="Delete"></i>  </a>

                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>  


        </div>
    </div><!-- /.box-body -->
    <div class="panel-footer">
        {!! $users->render() !!}
    </div>
</div> 


@stop
@section('include-js')
@parent

@stop

